/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.BasicGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.EnumerationGraphSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.IndicatorSource;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.TextGraph;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.TimeZoomSlider;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomSlider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class EnumerationGraph
implements TextGraph {
    TimeZoomSlider xslider;
    ZoomSlider yslider;
    Color fg_col;
    int line_width = 1;
    int line_style = 1;
    EnumerationGraphSource source;

    public void setIndicatorSource(IndicatorSource isource) {
    }

    public EnumerationGraph(TimeZoomSlider xslider, ZoomSlider yslider, Color col, EnumerationGraphSource source) {
        this.xslider = xslider;
        this.yslider = yslider;
        this.fg_col = col;
        this.source = source;
    }

    public BasicGraphSource getGraphSource() {
        return this.source;
    }

    public double getXMin() {
        return this.source.getMin();
    }

    public double getXMax() {
        return this.source.getMax();
    }

    public double getYMin() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return Double.POSITIVE_INFINITY;
    }

    public TimeZoomSlider getXSlider() {
        return this.xslider;
    }

    public ZoomSlider getYSlider() {
        return this.yslider;
    }

    public void setXSlider(TimeZoomSlider slider) {
        this.xslider = slider;
    }

    public void setYSlider(ZoomSlider slider) {
        this.yslider = slider;
    }

    public void setForeground(Color col) {
        this.fg_col = col;
    }

    public Color getForeground() {
        return this.fg_col;
    }

    public void setLineWidth(int w) {
        this.line_width = w;
    }

    public int getLineWidth() {
        return this.line_width;
    }

    public void setLineStyle(int swt_line_style) {
        this.line_style = swt_line_style;
    }

    public int getLineStyle() {
        return this.line_style;
    }

    public void setUseIndicator(boolean b) {
    }

    public void paintGraph(GC gc, int x, int y, int w, int h) {
        this.paintGraph(gc, x, y, w, h, 0);
    }

    public int paintGraph(GC gc, int x, int y, int w, int h, int stroffset) {
        int yoffset = stroffset;
        int fheight = gc.getFontMetrics().getHeight();
        gc.setForeground(this.fg_col);
        gc.setLineWidth(this.line_width);
        gc.setLineStyle(this.line_style);
        Object prev = null;
        for (int i = x; i < x + w; ++i) {
            double t = this.xslider.pixel2Value(i);
            if (!(t >= this.source.getMin()) || !(t <= this.source.getMax())) continue;
            Object str = this.source.getValueAt(t);
            if (str != prev && !str.equals(prev)) {
                gc.setForeground(this.fg_col);
                gc.drawLine(i, y, i, y + h);
                gc.drawString(str.toString(), i + 2, yoffset + y + 1, true);
                gc.setForeground(this.yslider.getDisplay().getSystemColor(2));
                gc.drawString(str.toString(), i + 1, yoffset + y, true);
                if ((yoffset += fheight) + fheight > h) {
                    yoffset = 0;
                }
            }
            prev = str;
        }
        return yoffset;
    }

    public void setStaticScaling(double mult) {
    }

    public double getStaticScaling() {
        return 1.0;
    }
}

