/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.MeterDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.SVGDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGMeter
extends SVGDocumentGenerator
implements IGraphicDocumentStyle,
IDataInputConstants,
IDataInputProcessingExceptionCodes,
Serializable {
    private final MeterDataRetriever dataRetriever;

    public SVGMeter() {
        this.graphicType = "meter";
        this.dataRetriever = new MeterDataRetriever();
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        if (newDataDocument == null) {
            int code = 114;
            String element = "";
            DataInputProcessingException e = new DataInputProcessingException(code, element);
            e.setWidgetType(this.graphicType);
            throw e;
        }
        DataRange dataRange = null;
        SegmentMarker[] markers = null;
        DataSet dataSet = null;
        try {
            dataRange = this.dataRetriever.getDataRange(newDataDocument, "");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        if (dataRange == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (dataRange.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        markers = dataRange.getSegmentMarkers();
        dataSet = this.dataRetriever.getDatasetWithPosition(newDataDocument, "0");
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, 0, 0, 0, 0, 0);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        try {
            Hashtable labels = this.dataRetriever.getLabels(newDataDocument);
            DataPoint[] dps = dataSet.getDataPoints();
            DataPoint dp = null;
            if (dps != null && dps.length > 0) {
                dp = dps[0];
            }
            if (dp.getType() != 1) {
                this.addDial(generatedDocument, graphicAttrs, labels, markers, dp);
            }
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        return generatedDocument;
    }

    private void addDefaultInternalStylesheet(Document generatedDocument, Element parent) {
        StringBuffer styleRules = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        styleRules.append(" ");
        styleRules.append(".minmaxRate {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .rateDef {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;opacity:0.5} .critDiv {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; opacity:0.5} .graphOutline{fill:none;} .ticks{fill:none;}  .speedometerBg{fill:#FFFFFF;} .innerRim{fill:#999999;} .outerRim{fill:#006666;} .needle{fill:#000000;stroke-width:1.5;stroke-linecap:round;} .outerCircle{fill:#000000;stroke:none;} .innerCircle{fill:#FFFFFF;stroke:none;} .center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .safeRange{fill:#CCCCCC;stroke:none;} .semiCritical{fill:#FFFF99;stroke:none;} .critical{fill:#FF0000;stroke:none;} .actualRate{fill:#CCCCCC;stroke:#999999;} ");
        CDATASection newCDATASection = generatedDocument.createCDATASection(styleRules.toString());
        Element newElement = generatedDocument.createElement("style");
        newElement.setAttribute("id", "defaultStyleRules");
        newElement.setAttribute("type", "text/css");
        newElement.appendChild(newCDATASection);
        parent.appendChild(newElement);
    }

    protected Element addDefinitions(Document generatedDocument, GraphicAttributes attrs) {
        Element defsElement = super.addDefinitions(generatedDocument, attrs);
        this.addDefaultInternalStylesheet(generatedDocument, defsElement);
        Element gElement_tick = generatedDocument.createElement("g");
        gElement_tick.setAttribute("id", "tickline");
        Element tickElement = generatedDocument.createElement("polyline");
        tickElement.setAttribute("class", "grid");
        tickElement.setAttribute("points", "0 0 5 0");
        gElement_tick.appendChild(tickElement);
        defsElement.appendChild(gElement_tick);
        return defsElement;
    }

    private void addDial(Document generatedDocument, GraphicAttributes attrs, Hashtable titles, SegmentMarker[] segmentMarkers, DataPoint needle) throws DataInputProcessingException {
        double needleValue;
        double y;
        double x;
        String unitLabel;
        Element gElement;
        Element parent = generatedDocument.getDocumentElement();
        short gWidth = attrs.getGraphicWidth();
        short gHeight = attrs.getGraphicHeight();
        double cx = gWidth / 2;
        double cy = gHeight / 2 + 5;
        short baseLength = gHeight >= gWidth ? gWidth : gHeight;
        Element newElement = generatedDocument.createElement("circle");
        newElement.setAttribute("class", "st1 outerRim");
        newElement.setAttribute("cx", Double.toString(cx));
        newElement.setAttribute("cy", Double.toString(cy));
        newElement.setAttribute("r", Double.toString((double)baseLength * 0.36));
        parent.appendChild(newElement);
        newElement = generatedDocument.createElement("circle");
        newElement.setAttribute("class", "st1 innerRim");
        newElement.setAttribute("cx", Double.toString(cx));
        newElement.setAttribute("cy", Double.toString(cy));
        newElement.setAttribute("r", Double.toString((double)baseLength * 0.352));
        parent.appendChild(newElement);
        newElement = generatedDocument.createElement("circle");
        newElement.setAttribute("class", "st1 speedometerBg");
        newElement.setAttribute("cx", Double.toString(cx));
        newElement.setAttribute("cy", Double.toString(cy));
        newElement.setAttribute("r", Double.toString((double)baseLength * 0.344));
        newElement.setAttribute("fill", "#ffffff");
        parent.appendChild(newElement);
        double boxWidth = (double)baseLength * 0.262;
        double boxYOffset = (double)baseLength * 0.1;
        short boxHeight = 14;
        newElement = generatedDocument.createElement("rect");
        newElement.setAttribute("class", "st1 actualRate");
        newElement.setAttribute("width", Double.toString(boxWidth));
        newElement.setAttribute("height", Short.toString(boxHeight));
        newElement.setAttribute("x", Double.toString(cx - boxWidth / 2.0));
        newElement.setAttribute("y", Double.toString(cy + boxYOffset));
        parent.appendChild(newElement);
        String actualRate = (String)titles.get("actualRate");
        if (actualRate != null) {
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "minmaxRate");
            gElement.setAttribute("class", "minmaxRate anchorAtMiddle");
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, actualRate, null, cx, cy + boxYOffset + (double)boxHeight - 3.0, 0);
        }
        if ((unitLabel = (String)titles.get("rateDefinition")) != null && !unitLabel.equals("")) {
            gElement = generatedDocument.createElement("g");
            gElement.setAttribute("id", "rateDefinition");
            gElement.setAttribute("class", "rateDef anchorAtMiddle");
            parent.appendChild(gElement);
            this.addLabel(generatedDocument, attrs, gElement, unitLabel, null, cx, cy + 14.0, 0);
        }
        if (segmentMarkers.length < 2) {
            int code = 104;
            String element = "dataRange";
            DataInputProcessingException e = new DataInputProcessingException(code, element);
            throw e;
        }
        if (segmentMarkers.length > 4) {
            int code = 103;
            String element = "dataRange";
            DataInputProcessingException e = new DataInputProcessingException(code, element);
            throw e;
        }
        SegmentMarker minMarker = null;
        SegmentMarker safeMarker = null;
        SegmentMarker criticalMarker = null;
        SegmentMarker maxMarker = null;
        if (segmentMarkers.length == 4) {
            minMarker = segmentMarkers[0];
            criticalMarker = segmentMarkers[1];
            safeMarker = segmentMarkers[2];
            maxMarker = segmentMarkers[3];
        } else if (segmentMarkers.length == 3) {
            minMarker = segmentMarkers[0];
            criticalMarker = segmentMarkers[1];
            maxMarker = segmentMarkers[2];
        } else {
            minMarker = segmentMarkers[0];
            maxMarker = segmentMarkers[1];
        }
        double totalUnits = maxMarker.getValue() - minMarker.getValue();
        String minLabel = this.getSegmentLabel(attrs, minMarker);
        String criticalLabel = this.getSegmentLabel(attrs, criticalMarker);
        String safeLabel = this.getSegmentLabel(attrs, safeMarker);
        String maxLabel = this.getSegmentLabel(attrs, maxMarker);
        double unitsCriticalRange = 0.0;
        double unitsSemiCriticalRange = 0.0;
        double unitsSafeRange = totalUnits;
        double radians = 0.01745329252;
        if (criticalMarker != null) {
            unitsCriticalRange = criticalMarker.getValue() - minMarker.getValue();
            unitsSemiCriticalRange = -criticalMarker.getValue();
            if (safeMarker != null) {
                unitsSemiCriticalRange = safeMarker.getValue() - criticalMarker.getValue();
                unitsSafeRange = maxMarker.getValue() - safeMarker.getValue();
            }
        }
        double safeDegrees = 0.0;
        double semiDegrees = 0.0;
        double critDegrees = 0.0;
        if (unitsSafeRange > 0.0) {
            safeDegrees = unitsSafeRange / totalUnits * 180.0 * radians;
        }
        if (unitsSemiCriticalRange > 0.0) {
            semiDegrees = unitsSemiCriticalRange / totalUnits * 180.0 * radians;
        }
        if (unitsCriticalRange > 0.0) {
            critDegrees = unitsCriticalRange / totalUnits * 180.0 * radians;
        }
        double radius = (double)baseLength * 0.25;
        String path = "";
        String translateString = "translate(" + cx + "," + cy + ")";
        if (safeDegrees > 0.0) {
            x = Math.cos(safeDegrees - 1.0E-6) * radius;
            y = Math.sin(safeDegrees - 1.0E-6) * radius;
            path = "M " + radius + " 0 A " + radius + " " + radius + " 0 0 0 " + x + " -" + y + " L 0 0 Z";
            newElement = generatedDocument.createElement("path");
            newElement.setAttribute("class", "st1 safeRange");
            newElement.setAttribute("transform", translateString);
            newElement.setAttribute("d", path);
            parent.appendChild(newElement);
        }
        if (semiDegrees > 0.0) {
            x = Math.cos(semiDegrees) * radius;
            y = Math.sin(semiDegrees) * radius;
            path = "M " + radius + " 0 A " + radius + " " + radius + " 0 0 0 " + x + " -" + y + " L 0 0 Z";
            newElement = generatedDocument.createElement("path");
            newElement.setAttribute("class", "st1 semiCritical");
            newElement.setAttribute("transform", translateString + " rotate(-" + safeDegrees / radians + ")");
            newElement.setAttribute("d", path);
            parent.appendChild(newElement);
        }
        if (critDegrees > 0.0) {
            x = Math.cos(critDegrees) * radius;
            y = Math.sin(critDegrees) * radius;
            path = "M " + radius + " 0 A " + radius + " " + radius + " 0 0 0 " + x + " -" + y + " L 0 0 Z";
            newElement = generatedDocument.createElement("path");
            newElement.setAttribute("class", "st1 critical");
            newElement.setAttribute("transform", translateString + " rotate(-" + (180.0 - critDegrees / radians) + ")");
            newElement.setAttribute("d", path);
            parent.appendChild(newElement);
        }
        Element meterLabelElement = generatedDocument.createElement("g");
        meterLabelElement.setAttribute("id", "meterLabel");
        parent.appendChild(meterLabelElement);
        x = cx - radius - 2.0;
        y = cy + 2.0;
        this.addLabel(generatedDocument, attrs, meterLabelElement, minLabel, "minmaxRate anchorAtEnd", x, y, 0);
        x = cx + radius + 1.0;
        y = cy + 2.0;
        this.addLabel(generatedDocument, attrs, meterLabelElement, maxLabel, "minmaxRate anchorAtStart", x, y, 0);
        double totalRange = maxMarker.getValue() - minMarker.getValue();
        if (criticalMarker != null) {
            ArrayList criticalMarkerInfo = this.calculateMarkerPosition(criticalMarker.getValue() - minMarker.getValue(), totalRange, radius);
            String criticalMarkerX = (String)criticalMarkerInfo.get(0);
            String criticalMarkerY = (String)criticalMarkerInfo.get(1);
            String criticalMarkerStyle = (String)criticalMarkerInfo.get(2);
            this.addTranslationLabel(generatedDocument, meterLabelElement, criticalMarkerX, criticalMarkerY, criticalLabel, translateString, criticalMarkerStyle);
        }
        if (safeMarker != null) {
            ArrayList safeMarkerInfo = this.calculateMarkerPosition(safeMarker.getValue() - minMarker.getValue(), totalRange, radius);
            String safeMarkerX = (String)safeMarkerInfo.get(0);
            String safeMarkerY = (String)safeMarkerInfo.get(1);
            String safeMarkerStyle = (String)safeMarkerInfo.get(2);
            this.addTranslationLabel(generatedDocument, meterLabelElement, safeMarkerX, safeMarkerY, safeLabel, translateString, safeMarkerStyle);
        }
        double angle = 9.0;
        String rotateString = "";
        for (int i = 0; i < 19; ++i) {
            double rad = angle * Math.PI / 180.0;
            double xpos = Math.cos(-1.0 * rad) * (radius - 5.0);
            double ypos = Math.sin(-1.0 * rad) * (radius - 5.0);
            rotateString = "rotate(-" + angle + "," + xpos + "," + ypos + ")";
            newElement = generatedDocument.createElement("use");
            newElement.setAttribute("xlink:href", "#tickline");
            newElement.setAttribute("x", Double.toString(xpos));
            newElement.setAttribute("y", Double.toString(ypos));
            newElement.setAttribute("transform", translateString + rotateString);
            parent.appendChild(newElement);
            angle += 9.0;
        }
        if (needle != null && (needleValue = needle.getValue2()) >= minMarker.getValue() && needleValue <= maxMarker.getValue()) {
            double needleAngle = (needleValue - minMarker.getValue()) / (maxMarker.getValue() - minMarker.getValue()) * 180.0 + 180.0;
            newElement = generatedDocument.createElement("rect");
            newElement.setAttribute("class", "st1 needle");
            newElement.setAttribute("width", Double.toString(radius - 6.0));
            newElement.setAttribute("height", Double.toString(1.3));
            newElement.setAttribute("x", Double.toString(cx));
            newElement.setAttribute("y", Double.toString(cy));
            newElement.setAttribute("transform", "rotate(" + needleAngle + "," + Double.toString(cx) + "," + Double.toString(cy) + ")");
            parent.appendChild(newElement);
            newElement = generatedDocument.createElement("circle");
            newElement.setAttribute("class", "st1 outerCircle");
            newElement.setAttribute("cx", Double.toString(cx));
            newElement.setAttribute("cy", Double.toString(cy));
            newElement.setAttribute("r", Double.toString(2.5));
            parent.appendChild(newElement);
            newElement = generatedDocument.createElement("circle");
            newElement.setAttribute("class", "st1 innerCircle");
            newElement.setAttribute("cx", Double.toString(cx));
            newElement.setAttribute("cy", Double.toString(cy));
            newElement.setAttribute("r", Double.toString(1.7));
            parent.appendChild(newElement);
            newElement = generatedDocument.createElement("circle");
            newElement.setAttribute("class", "st1 center");
            newElement.setAttribute("cx", Double.toString(cx));
            newElement.setAttribute("cy", Double.toString(cy));
            newElement.setAttribute("r", Double.toString(0.5));
            parent.appendChild(newElement);
        }
    }

    private String getSegmentLabel(GraphicAttributes attrs, SegmentMarker marker) {
        if (marker != null) {
            String label = marker.getLabel();
            return label != null ? label : attrs.formatNumber(marker.getValue());
        }
        return "";
    }

    private void addTranslationLabel(Document generatedDocument, Element parent, String x, String y, String label, String translateString, String styleSheetClass) {
        Element newElement = generatedDocument.createElement("text");
        newElement.setAttribute("class", "critDiv " + styleSheetClass);
        newElement.setAttribute("x", x);
        newElement.setAttribute("y", y);
        newElement.setAttribute("transform", translateString);
        newElement.appendChild(generatedDocument.createTextNode(label));
        parent.appendChild(newElement);
    }

    ArrayList calculateMarkerPosition(double marker, double totalRange, double radius) {
        double markerDeg = (totalRange - marker) / totalRange * 180.0;
        double markerRad = markerDeg * Math.PI / 180.0;
        double markerX = Math.cos(-1.0 * markerRad) * (radius + 3.0);
        double markerY = Math.sin(-1.0 * markerRad) * (radius + 3.0);
        String markerStyle = "";
        if (markerDeg < 90.0) {
            markerStyle = "anchorAtStart";
        } else if (markerDeg == 90.0) {
            markerStyle = "anchorAtMiddle";
        } else if (markerDeg > 90.0) {
            markerStyle = "anchorAtEnd";
        }
        ArrayList<String> markerPosInfo = new ArrayList<String>();
        markerPosInfo.add(Double.toString(markerX));
        markerPosInfo.add(Double.toString(markerY));
        markerPosInfo.add(new String(markerStyle));
        return markerPosInfo;
    }

    private void getConfigAttributes(GraphicAttributes attrs) throws DataInputProcessingException {
        Hashtable configProperties = this.dataRetriever.getConfigurationAttributes(attrs.getConfigDocument(), attrs.getDataDocument());
        if (configProperties == null) {
            return;
        }
        String width = (String)configProperties.get("width");
        String height = (String)configProperties.get("height");
        String title = (String)configProperties.get("title");
        String timestampPrefix = (String)configProperties.get("timestampPrefix");
        if (width != null) {
            attrs.setGraphicWidth(width);
        }
        if (height != null) {
            attrs.setGraphicHeight(height);
        }
        if (title != null) {
            attrs.setGraphicTitle(title);
        }
        if (timestampPrefix != null) {
            attrs.setGraphicTimestampPrefix(timestampPrefix);
        }
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("325");
        graphicAttrs.setPreferencesPage("prefs_meter.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("350");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

