/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.RecorderX509TrustManager;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class SSLCheckClass {
    String sslCipherSuite = "";
    String sslProtocol = "";
    SSLContext serverSideConnectionContext = null;
    String sslKeyFile = "C:\\testkeys";
    SSLSocket sslServer = null;
    SSLSocket spySocket = null;
    ClientSideReader csr = null;
    SSLSocket HTTPServerSocket = null;
    static final String SpySocketException = HttpRecResourceBundle.getInstance().getString("RECORDER_SSL_SPYSOCKET_EXCEPTION");
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");

    public boolean makeSecureConnection() {
        boolean bl = false;
        if (this.connectToSecureServer(this.csr.destServer, this.csr.serverPort)) {
            if (this.createSSLSpyServerSocket()) {
                this.checkRightSideContexts();
                this.csr.packetWriter.writeOpenSecureConnectionInfo(this.csr.bSecure, this.csr.iConnection, this.csr.destServer, this.csr.serverPort, this.csr.client, this.csr.httpServer, this.spySocket, this.sslServer, this.csr.sslCipherSuite, this.csr.sslProtocol);
            }
            try {
                this.csr.to_client = this.spySocket.getOutputStream();
                this.csr.from_client = this.spySocket.getInputStream();
                this.csr.to_server = this.sslServer.getOutputStream();
                this.csr.from_server = this.sslServer.getInputStream();
                this.csr.httpServer.close();
                this.csr.httpServer = this.sslServer;
                this.csr.bSecure = true;
                this.csr.serverReader = new ServerSideReader(this.csr.client, this.csr.httpServer, this.csr.from_server, this.csr.to_client, this.csr.packetWriter, this.csr.connectionNumber, this.csr.bSecure, this.spySocket.getReceiveBufferSize());
                this.csr.serverReader.start();
            }
            catch (IOException iOException) {
                this.csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + iOException);
                this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)iOException);
                return false;
            }
        }
        this.csr.bNoPrintToServer = true;
        return this.csr.bSecure;
    }

    public boolean connectToSecureServer(String string, int n) {
        SSLContext sSLContext = null;
        try {
            SSLSocketFactory sSLSocketFactory = null;
            TrustManager[] trustManagerArray = new TrustManager[]{new RecorderX509TrustManager()};
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            this.sslServer = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            this.sslServer.startHandshake();
        }
        catch (Exception exception) {
            this.csr.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            this.csr.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            return false;
        }
        this.serverSideConnectionContext = sSLContext;
        return true;
    }

    public SSLCheckClass(ClientSideReader clientSideReader, String string) {
        this.sslKeyFile = string;
        this.csr = clientSideReader;
    }

    public SSLCheckClass(ClientSideReader clientSideReader) {
        this(clientSideReader, "C:\\testkeys");
    }

    public boolean createSSLSpyServerSocket() {
        SSLSocketFactory sSLSocketFactory = null;
        SSLContext sSLContext = null;
        try {
            KeyManagerFactory keyManagerFactory;
            char[] cArray = "passphrase".toCharArray();
            String string = System.getProperty("java.vm.vendor");
            if (string.indexOf("Sun") >= 0) {
                sSLContext = SSLContext.getInstance("TLS");
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            } else {
                sSLContext = SSLContext.getInstance("SSL");
                keyManagerFactory = KeyManagerFactory.getInstance("IbmX509");
            }
            KeyStore keyStore = KeyStore.getInstance("jks");
            if (this.sslKeyFile == null || this.sslKeyFile.length() == 0) {
                this.sslKeyFile = "C:\\testkeys";
            }
            keyStore.load(new FileInputStream(this.sslKeyFile), cArray);
            keyManagerFactory.init(keyStore, cArray);
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            this.spySocket = (SSLSocket)sSLSocketFactory.createSocket(this.csr.client, "localhost", this.csr.client.getLocalPort(), true);
            this.spySocket.setUseClientMode(false);
        }
        catch (Exception exception) {
            this.csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + exception);
            this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)exception);
            return false;
        }
        return true;
    }

    public boolean makeSecureConnectionHTTP(String string, String string2, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (string.length() > 0) {
            bl2 = this.sendConnectToProxyServer(string);
            if (!bl2) {
                return false;
            }
            boolean bl3 = false;
            bl3 = this.convertHTTPServerConnectionToSSL(string2, n);
            if (bl3) {
                if (this.createSSLSpyServerSocket()) {
                    this.checkRightSideContexts();
                }
                this.csr.packetWriter.writeOpenSecureConnectionInfo(this.csr.bSecure, this.csr.iConnection, this.csr.destServer, this.csr.serverPort, this.csr.client, this.csr.httpServer, this.spySocket, this.sslServer, this.csr.sslCipherSuite, this.csr.sslProtocol);
                try {
                    this.csr.to_client = this.spySocket.getOutputStream();
                    this.csr.from_client = this.spySocket.getInputStream();
                    this.csr.httpServer = this.HTTPServerSocket;
                    this.csr.to_server = this.HTTPServerSocket.getOutputStream();
                    this.csr.from_server = this.HTTPServerSocket.getInputStream();
                    this.csr.bSecure = true;
                    this.csr.secureConnectionOK = true;
                    this.csr.serverReader = new ServerSideReader(this.csr.client, this.csr.httpServer, this.csr.from_server, this.csr.to_client, this.csr.packetWriter, this.csr.connectionNumber, this.csr.bSecure, this.spySocket.getReceiveBufferSize());
                    this.csr.serverReader.start();
                }
                catch (IOException iOException) {
                    this.csr.packetWriter.writeRecorderMessage(2, "exception in creating SSL Spy Socket: " + iOException);
                    this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)iOException);
                    return false;
                }
            }
        }
        this.csr.bNoPrintToServer = true;
        return this.csr.bSecure;
    }

    boolean sendConnectToProxyServer(String string) {
        boolean bl = false;
        if (string.length() > 0) {
            try {
                byte[] byArray = new byte[this.csr.client.getReceiveBufferSize()];
                byte[] byArray2 = new byte[this.csr.httpServer.getReceiveBufferSize()];
                byArray = string.getBytes();
                this.csr.to_server.write(byArray, 0, byArray.length);
                this.csr.to_server.flush();
                int n = this.csr.from_server.read(byArray2);
                if (n > 0) {
                    String string2 = new String(byArray2, 0, n);
                    int n2 = string2.indexOf(" 200 ");
                    if (n2 >= 0) {
                        this.csr.to_client.write(byArray2, 0, n);
                        this.csr.to_client.flush();
                        bl = true;
                    } else {
                        bl = false;
                    }
                }
            }
            catch (IOException iOException) {
                this.csr.packetWriter.writeRecorderMessage(2, "exception in makeSecureConnection(): " + iOException);
                this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)iOException);
                return false;
            }
        }
        return bl;
    }

    boolean convertHTTPServerConnectionToSSL(String string, int n) {
        SSLContext sSLContext;
        boolean bl = true;
        SSLSocketFactory sSLSocketFactory = null;
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{new RecorderX509TrustManager()};
            sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            this.HTTPServerSocket = (SSLSocket)sSLSocketFactory.createSocket(this.csr.httpServer, this.csr.destServer, this.csr.serverPort, true);
            this.HTTPServerSocket.setUseClientMode(true);
            this.csr.httpServer = this.HTTPServerSocket;
        }
        catch (Exception exception) {
            this.csr.packetWriter.writeRecorderMessage(2, "exception in creating HTTPServer Spy Socket: " + exception);
            this.csr.packetWriter.getAgentController().reportException(SpySocketException, (Throwable)exception);
            return false;
        }
        this.serverSideConnectionContext = sSLContext;
        return bl;
    }

    public void checkRightSideContexts() {
        Object object;
        int n;
        Vector<SSLSession> vector = new Vector<SSLSession>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        SSLSessionContext sSLSessionContext = this.serverSideConnectionContext.getServerSessionContext();
        SSLSessionContext sSLSessionContext2 = this.serverSideConnectionContext.getClientSessionContext();
        Enumeration<byte[]> enumeration = sSLSessionContext.getIds();
        Enumeration<byte[]> enumeration2 = sSLSessionContext2.getIds();
        while (enumeration2.hasMoreElements()) {
            byte[] byArray = enumeration2.nextElement();
            vector.add(sSLSessionContext2.getSession(byArray));
        }
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            object = (SSLSession)vector.elementAt(n);
            vector2.add(object.getCipherSuite());
            vector3.add(object.getProtocol());
        }
        for (n = 0; n < n2; ++n) {
            object = (String)vector3.get(n);
            String string = (String)vector2.get(n);
            if (n != 0) continue;
            this.csr.sslProtocol = object;
            this.csr.sslCipherSuite = string;
        }
        if (this.csr.sslCipherSuite.length() > 0 && this.csr.sslProtocol.length() > 0) {
            this.csr.defaultCipherSuite = this.csr.sslCipherSuite;
            this.csr.defaultProtocol = this.csr.sslProtocol;
        } else {
            this.csr.sslCipherSuite = this.csr.defaultCipherSuite;
            this.csr.sslProtocol = this.csr.defaultProtocol;
        }
    }
}

