/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.hyades.test.ui.TestUIPlugin;

public class EventUtil {
    public static final String TIME_FORMAT = "yyyy.MM.dd - hh:mm:ss a";
    public static final String DURATION_FORMAT = "HH:mm:ss:SSS";

    public static String getTime(long timestamp) {
        if (timestamp != 0L) {
            try {
                DateFormat format = DateFormat.getDateTimeInstance(2, 0);
                return format.format(new Date(timestamp));
            }
            catch (RuntimeException e) {
                TestUIPlugin.logError(e);
            }
        }
        return "";
    }

    public static String getDuration(long timestamp, long endTimestamp) {
        if (timestamp != 0L && endTimestamp != 0L) {
            try {
                long duration = endTimestamp - timestamp;
                SimpleDateFormat format = new SimpleDateFormat(DURATION_FORMAT);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                return format.format(new Date(duration));
            }
            catch (RuntimeException e) {
                TestUIPlugin.logError(e);
            }
        }
        return "";
    }
}

