/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.configurations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.launch.configurations.AbstractLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;

public class ExecutionHistoryLaunchConfigurationFacade
extends AbstractLaunchConfigurationFacade {
    private static final String PROPERTY_USER_TEH_NAME = "org.eclipse.hyades.test.ui.launch.tehName";
    private static final String PROPERTY_USER_TEH_OVERRIDE = "org.eclipse.hyades.test.ui.launch.tehOverride";
    private static final String PROPERTY_USER_TEH_LOCATION = "org.eclipse.hyades.test.ui.launch.tehLocation";
    private static final String PROPERTY_DEFAULT_TEH_NAME = "org.eclipse.hyades.test.ui.launch.defaultName";
    private static final String PROPERTY_DEFAULT_TEH_OVERRIDE_STATE = "org.eclipse.hyades.test.ui.launch.defaultOverride";
    private static final String PROPERTY_DEFAULT_TEH_LOCATION = "org.eclipse.hyades.test.ui.launch.defaultLocation";

    public static String getExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
        if (ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultName(configuration)) {
            return ExecutionHistoryLaunchConfigurationFacade.computeDefaultName(configuration);
        }
        return ExecutionHistoryLaunchConfigurationFacade.getUserName(configuration);
    }

    public static void setExecutionHistoryName(ILaunchConfigurationWorkingCopy configuration, String name) {
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultName(configuration, false);
        ExecutionHistoryLaunchConfigurationFacade.setUserName(configuration, name);
    }

    public static boolean isExecutionHistoryOverriden(ILaunchConfiguration configuration) throws CoreException {
        if (ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultOverrideState(configuration)) {
            return ExecutionHistoryLaunchConfigurationFacade.computeDefaultOverrideState(configuration);
        }
        return ExecutionHistoryLaunchConfigurationFacade.isUserOverriden(configuration);
    }

    public static void setExecutionHistoryOverriden(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultOverrideState(configuration, false);
        ExecutionHistoryLaunchConfigurationFacade.setUserOverriden(configuration, value);
    }

    public static IContainer getExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
        if (ExecutionHistoryLaunchConfigurationFacade.isUsingDefaultLocation(configuration)) {
            return ExecutionHistoryLaunchConfigurationFacade.computeDefaultLocation(configuration);
        }
        return ExecutionHistoryLaunchConfigurationFacade.getUserLocation(configuration);
    }

    public static void setExecutionHistoryLocation(ILaunchConfigurationWorkingCopy configuration, IContainer location) {
        if (location != null && location.getType() == 8) {
            throw new IllegalArgumentException("location argument cannot be the Workspace Root");
        }
        ExecutionHistoryLaunchConfigurationFacade.setUsingDefaultLocation(configuration, false);
        ExecutionHistoryLaunchConfigurationFacade.setUserLocation(configuration, location);
    }

    public static boolean isUsingDefaultName(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_DEFAULT_TEH_NAME, true);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    public static boolean isUsingDefaultOverrideState(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_DEFAULT_TEH_OVERRIDE_STATE, true);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    public static boolean isUsingDefaultLocation(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_DEFAULT_TEH_LOCATION, true);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    public static void setUsingDefaultName(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_DEFAULT_TEH_NAME, value);
    }

    public static void setUsingDefaultOverrideState(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_DEFAULT_TEH_OVERRIDE_STATE, value);
    }

    public static void setUsingDefaultLocation(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_DEFAULT_TEH_LOCATION, value);
    }

    private static String getUserName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(PROPERTY_USER_TEH_NAME, (String)null);
    }

    private static void setUserName(ILaunchConfigurationWorkingCopy configuration, String name) {
        configuration.setAttribute(PROPERTY_USER_TEH_NAME, name);
    }

    private static boolean isUserOverriden(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(PROPERTY_USER_TEH_OVERRIDE, false);
    }

    private static void setUserOverriden(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_USER_TEH_OVERRIDE, value);
    }

    private static IContainer getUserLocation(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.getContainerProperty(configuration, PROPERTY_USER_TEH_LOCATION);
    }

    private static void setUserLocation(ILaunchConfigurationWorkingCopy configuration, IContainer location) {
        if (location != null && location.getType() == 8) {
            throw new IllegalArgumentException("location argument cannot be the Workspace Root");
        }
        ExecutionHistoryLaunchConfigurationFacade.setContainerProperty(configuration, PROPERTY_USER_TEH_LOCATION, location);
    }

    private static IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider2(ILaunchConfiguration configuration) {
        IExecutionHistoryDefaultsProvider2 defaultsProvider2;
        String launchConfigurationType = null;
        try {
            launchConfigurationType = configuration.getType().getIdentifier();
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
        if (launchConfigurationType != null && (defaultsProvider2 = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider2(launchConfigurationType)) != null) {
            return defaultsProvider2;
        }
        return null;
    }

    private static String computeDefaultName(ILaunchConfiguration configuration) {
        String name = null;
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            name = defaultsProvider2.getDefaultName(configuration);
        }
        if (name == null) {
            TPFTest test = null;
            try {
                test = TestLaunchConfigurationFacade.getTest(configuration);
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
            IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
            if (defaultsProvider != null) {
                name = defaultsProvider.getDefaultName(test);
            }
            if (name == null) {
                name = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(test);
            }
        }
        return name;
    }

    private static boolean computeDefaultOverrideState(ILaunchConfiguration configuration) {
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            return defaultsProvider2.getDefaultOverrideState(configuration);
        }
        TPFTest test = null;
        try {
            test = TestLaunchConfigurationFacade.getTest(configuration);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
        IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
        return defaultsProvider.getDefaultOverrideState(test);
    }

    private static IContainer computeDefaultLocation(ILaunchConfiguration configuration) {
        IContainer location = null;
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            location = defaultsProvider2.getDefaultLocation(configuration);
        }
        if (location == null) {
            TPFTest test = null;
            try {
                test = TestLaunchConfigurationFacade.getTest(configuration);
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
            IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
            location = defaultsProvider.getDefaultLocation(test);
            if (location == null) {
                location = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(test);
            }
            if (location == null) {
                location = ExecutionHistoryLaunchConfigurationFacade.getContextLocation();
            }
        }
        return location;
    }

    private static IContainer getContextLocation() {
        try {
            IProject project;
            IStructuredSelection ss;
            Object obj;
            ISelection selection;
            IWorkbenchPage page = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IResource && (project = ((IResource)obj).getProject()) != null) {
                return project;
            }
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
        }
        return null;
    }
}

