/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
import org.eclipse.hyades.resources.database.internal.impl.QueryStatement;
import org.eclipse.hyades.resources.database.internal.impl.RDBHelper;
import org.eclipse.hyades.resources.database.internal.impl.TypeConverter;

public class AttributeValueQuery
extends QueryStatement {
    protected EClass eClass;
    protected List values;
    protected List ids;
    protected String primaryKeyName;

    public AttributeValueQuery(DatabaseType type, DBMap map, EClass eClass, List values, List ids) {
        super(type, map, (EModelElement)eClass);
        this.eClass = eClass;
        this.values = values;
        this.ids = ids;
    }

    protected void createSelectFrom() {
        RDBHelper rdbHelper = new RDBHelper();
        this.primaryKeyName = rdbHelper.getPrimaryKey(this.table).getName();
        this.statement.append("SELECT ");
        this.statement.append(this.addQuotes(this.primaryKeyName));
        this.statement.append(" FROM ");
        this.statement.append(this.addQuotes(this.table.getName()));
    }

    protected void createWhereClause(int begin) {
        if (this.values.isEmpty() && this.ids.isEmpty()) {
            return;
        }
        this.statement.append(" WHERE");
        this.createAttributeTests();
        this.createIdTest();
    }

    protected void createAttributeTests() {
        if (this.values.isEmpty()) {
            return;
        }
        int l = this.values.size();
        for (int i = 0; i < l - 1; i += 2) {
            EAttribute attribute = (EAttribute)this.values.get(i);
            Object value = this.values.get(i + 1);
            this.createAttributeTest(attribute, value, i);
        }
    }

    protected void createAttributeTest(EAttribute attribute, Object value, int i) {
        String name = this.getColumnName(attribute);
        int type = this.getSQLType(attribute);
        if (i == 0) {
            this.statement.append(" ");
        } else {
            this.statement.append(" AND ");
        }
        if (this.isString(type) && value == null) {
            this.statement.append(this.addQuotes(name));
            this.statement.append(" IS NULL");
        } else {
            this.statement.append(this.addQuotes(name));
            this.statement.append(" = ");
            if (TypeConverter.isBooleanType(attribute)) {
                this.appendBooleanValue(value);
            } else {
                this.appendValue(value, type);
            }
        }
    }

    protected void appendValue(Object value, int type) {
        if (this.isString(type)) {
            this.statement.append("'");
            this.statement.append(value.toString());
            this.statement.append("'");
        } else {
            this.statement.append(value.toString());
        }
    }

    protected void appendBooleanValue(Object value) {
        this.statement.append("'");
        if (value == Boolean.TRUE) {
            this.statement.append("T");
        } else if (value == Boolean.FALSE) {
            this.statement.append("F");
        }
        this.statement.append("'");
    }

    protected boolean isString(int type) {
        return type == 12 || type == 1;
    }

    protected String getColumnName(EAttribute attribute) {
        Column column = this.getColumn(attribute);
        return column.getName();
    }

    protected Column getColumn(EAttribute attribute) {
        DBMap.AttributeData data = (DBMap.AttributeData)this.dbMap.getDBRepresentation((EModelElement)attribute);
        return data.getValueColumn();
    }

    protected int getSQLType(EAttribute attribute) {
        Column column = this.getColumn(attribute);
        return column.getType().getSqlType();
    }

    protected void createIdTest() {
        if (this.ids.isEmpty()) {
            return;
        }
        this.statement.append(" AND ");
        this.statement.append(this.addQuotes(this.primaryKeyName));
        this.statement.append(" IN ( ");
        boolean first = true;
        int l = this.ids.size();
        for (int i = 0; i < l; ++i) {
            Integer id = (Integer)this.ids.get(i);
            if (first) {
                first = false;
                this.statement.append(id.toString());
                continue;
            }
            this.statement.append(", ");
            this.statement.append(id.toString());
        }
        this.statement.append(")");
    }
}

