/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.perfmon.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.hyades.perfmon.xml.FastStringBuffer;
import org.eclipse.hyades.perfmon.xml.XMLParserListener;

public class XMLParser {
    private static final boolean DEBUG = false;
    InputStream input;
    private static final byte ROOT = 0;
    private static final byte TEXT_NODE = 1;
    private static final byte OPEN_TAG = 2;
    private static final byte TAG_NAME = 3;
    private static final byte TAG_ATTRIBUTE = 4;
    private static final byte CLOSE_TAG = 5;
    private static final byte ID_OR_ATTRIBUTE = 6;
    int pch = 0;
    int ch = 0;
    int line = 0;
    int column = 0;

    public XMLParser() {
    }

    public XMLParser(String string) throws IOException {
        this.setInput(string);
    }

    public XMLParser(FastStringBuffer fastStringBuffer) throws IOException {
        this.setInput(fastStringBuffer);
    }

    public XMLParser(InputStream inputStream) throws IOException {
        this.setInput(inputStream);
    }

    public void setInput(InputStream inputStream) throws IOException {
        this.input = new BufferedInputStream(inputStream);
        this.ch = this.input.read();
        this.line = 0;
        this.column = 0;
    }

    public void setInput(String string) throws IOException {
        this.setInput(new ByteArrayInputStream(string.getBytes()));
    }

    public void setInput(FastStringBuffer fastStringBuffer) throws IOException {
        this.setInput(new ByteArrayInputStream(fastStringBuffer.toString().getBytes()));
    }

    public void parse(XMLParserListener xMLParserListener) throws Exception {
        this.parse(xMLParserListener, this.input);
    }

    public void parse(XMLParserListener xMLParserListener, InputStream inputStream) throws Exception {
        this.setInput(inputStream);
        xMLParserListener.startDocument();
        boolean bl = false;
        boolean bl2 = true;
        String string = "ERROR";
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 1;
        while (true) {
            switch (n) {
                case 1: {
                    fastStringBuffer.setLength(0);
                    this.parseText(fastStringBuffer);
                    if (this.peekChar() == -1) {
                        xMLParserListener.endDocument();
                        return;
                    }
                    if (fastStringBuffer.length() > 0) {
                        xMLParserListener.text(fastStringBuffer.toString());
                    }
                    n = 2;
                    break;
                }
                case 2: {
                    if (this.nextChar() != 60) {
                        this.error("expected open tag < not " + this.prevChar());
                    }
                    if (this.peekChar() == 33) {
                        this.nextChar();
                        if (this.peekChar() == 45) {
                            if (this.nextChar() != 45) {
                                this.error("expected comment -");
                            }
                            if (this.nextChar() != 45) {
                                this.error("expected comment --");
                            }
                            this.parseComment(null);
                            n = 1;
                            break;
                        }
                        if (this.peekChar() == 91) {
                            this.nextChar();
                            if (this.nextChar() != 67) {
                                this.error("expected ![CDATA[ comment C");
                            }
                            if (this.nextChar() != 68) {
                                this.error("expected ![CDATA[ comment D");
                            }
                            if (this.nextChar() != 65) {
                                this.error("expected ![CDATA[ comment A");
                            }
                            if (this.nextChar() != 84) {
                                this.error("expected ![CDATA[ comment T");
                            }
                            if (this.nextChar() != 65) {
                                this.error("expected ![CDATA[ comment A");
                            }
                            if (this.nextChar() != 91) {
                                this.error("expected ![CDATA[ comment [");
                            }
                            this.parseCDATA(null);
                            n = 1;
                            break;
                        }
                        bl2 = true;
                        bl = true;
                        n = 6;
                        this.parseWhitespace(null);
                        break;
                    }
                    if (this.peekChar() == 63) {
                        this.nextChar();
                        bl2 = true;
                        bl = true;
                    } else if (this.peekChar() == 47) {
                        this.nextChar();
                        bl2 = false;
                    } else {
                        hashMap = new HashMap();
                        bl2 = true;
                    }
                    bl = false;
                    n = 3;
                    this.parseWhitespace(null);
                    break;
                }
                case 3: {
                    fastStringBuffer.setLength(0);
                    this.parseIdentifier(fastStringBuffer);
                    if (fastStringBuffer.length() == 0) {
                        this.error("expected tag name (or some other valid open tag like \"<!--\", \"<!DOCTYP\" or \"<![CDATA[\" )");
                    }
                    string = fastStringBuffer.toString();
                    this.parseWhitespace(null);
                    n = 4;
                    break;
                }
                case 6: {
                    if (this.peekChar() == 47) {
                        n = 5;
                        break;
                    }
                    if (this.peekChar() == 63) {
                        n = 5;
                        break;
                    }
                    if (this.peekChar() == 62) {
                        n = 5;
                        break;
                    }
                    if (this.peekChar() == 34 || this.peekChar() == 39) {
                        this.parseQuoted(null);
                    } else {
                        this.parseIdentifier(null);
                        this.parseWhitespace(null);
                        if (this.peekChar() == 61) {
                            this.nextChar();
                            this.parseWhitespace(null);
                            this.parseQuoted(null);
                        }
                    }
                    this.parseWhitespace(null);
                    break;
                }
                case 4: {
                    if (this.peekChar() == 47) {
                        n = 5;
                        break;
                    }
                    if (this.peekChar() == 63) {
                        n = 5;
                        break;
                    }
                    if (this.peekChar() == 62) {
                        n = 5;
                        break;
                    }
                    if (!bl2) {
                        this.error("attributes found in end tag");
                    }
                    fastStringBuffer.setLength(0);
                    this.parseIdentifier(fastStringBuffer);
                    String string2 = fastStringBuffer.toString();
                    if (string2.length() == 0) {
                        this.error("expected tag attribute key (blah=\"...\")");
                    }
                    this.parseWhitespace(null);
                    if (this.nextChar() != 61) {
                        this.error("expected attribute equals = (blah=\"...\")");
                    }
                    this.parseWhitespace(null);
                    if (this.peekChar() != 34 && this.peekChar() != 39) {
                        this.error("expected attribute value in quotes (blah=\"value\")");
                    }
                    fastStringBuffer.setLength(0);
                    this.parseQuoted(fastStringBuffer);
                    this.convertValue(fastStringBuffer);
                    String string3 = fastStringBuffer.toString();
                    hashMap.put(string2, string3);
                    this.parseWhitespace(null);
                    break;
                }
                case 5: {
                    if (this.peekChar() == 63) {
                        this.nextChar();
                        if (this.nextChar() != 62) {
                            this.error("expected close tag \"?>\" at end of xml spec tag");
                        }
                    } else if (this.peekChar() == 47) {
                        if (!bl2) {
                            this.error("invalid close tag \"/>\" on end tag, close tag should be \">\" on end tag");
                        }
                        this.nextChar();
                        if (this.nextChar() != 62) {
                            this.error("expected close tag > (e.g. \"<mytag />\")");
                        }
                        if (!bl) {
                            xMLParserListener.startElement(string, hashMap);
                            xMLParserListener.endElement(string);
                        }
                        bl = false;
                    } else {
                        if (this.nextChar() != 62) {
                            this.error("expected close tag >");
                        }
                        if (!bl) {
                            if (bl2) {
                                xMLParserListener.startElement(string, hashMap);
                            } else {
                                xMLParserListener.endElement(string);
                            }
                        }
                        bl = false;
                    }
                    n = 1;
                }
            }
        }
    }

    private int peekChar() throws IOException {
        return this.ch;
    }

    private int nextChar() throws IOException {
        int n = this.ch;
        this.ch = this.input.read();
        this.pch = this.fixChar(n);
        return this.pch;
    }

    private char prevChar() throws IOException {
        return (char)this.pch;
    }

    private int fixChar(int n) throws IOException {
        if (n == 13) {
            n = this.peekChar() == 10 ? this.nextChar() : 10;
        }
        if (n == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return n;
    }

    private void error(String string) throws Exception {
        throw new Exception(string + ", line " + this.line + ", column " + this.column + " pch=" + this.prevChar() + " peek=" + (char)this.peekChar());
    }

    private int stringBufferIndexOf(char c, FastStringBuffer fastStringBuffer, int n) {
        return fastStringBuffer.indexOf(c, n);
    }

    private void convertValue(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        while (n < fastStringBuffer.length()) {
            char c = fastStringBuffer.charAt(n);
            if (c == '&') {
                int n2 = fastStringBuffer.length() - n;
                if (n2 > 3) {
                    if (fastStringBuffer.charAt(n + 1) == '#') {
                        int n3 = this.stringBufferIndexOf(';', fastStringBuffer, n + 1);
                        if (n3 != -1) {
                            char c2 = (char)Integer.parseInt(fastStringBuffer.substring(n + 2, n3));
                            fastStringBuffer.replace(n, n3 + 1, String.valueOf(c2));
                        }
                    } else if (fastStringBuffer.charAt(n + 1) == 'l' && fastStringBuffer.charAt(n + 2) == 't' && fastStringBuffer.charAt(n + 3) == ';') {
                        fastStringBuffer.replace(n, n + 4, "<");
                    } else if (fastStringBuffer.charAt(n + 1) == 'g' && fastStringBuffer.charAt(n + 2) == 't' && fastStringBuffer.charAt(n + 3) == ';') {
                        fastStringBuffer.replace(n, n + 4, ">");
                    }
                }
                if (n2 > 4 && fastStringBuffer.charAt(n + 1) == 'a' && fastStringBuffer.charAt(n + 2) == 'm' && fastStringBuffer.charAt(n + 3) == 'p' && fastStringBuffer.charAt(n + 4) == ';') {
                    fastStringBuffer.replace(n, n + 5, "&");
                }
                if (n2 > 5) {
                    if (fastStringBuffer.charAt(n + 1) == 'q' && fastStringBuffer.charAt(n + 2) == 'u' && fastStringBuffer.charAt(n + 3) == 'o' && fastStringBuffer.charAt(n + 4) == 't' && fastStringBuffer.charAt(n + 5) == ';') {
                        fastStringBuffer.replace(n, n + 6, "\"");
                    } else if (fastStringBuffer.charAt(n + 1) == 'a' && fastStringBuffer.charAt(n + 2) == 'p' && fastStringBuffer.charAt(n + 3) == 'o' && fastStringBuffer.charAt(n + 4) == 's' && fastStringBuffer.charAt(n + 5) == ';') {
                        fastStringBuffer.replace(n, n + 6, "'");
                    }
                }
            }
            ++n;
        }
    }

    private int parseCDATA(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.peekChar();
        int n3 = 0;
        while (n2 > 31 && n2 < 127 || n2 > 127 && n2 < 255 || n2 == 9 || n2 == 10) {
            if (n3 == 0 && n2 == 93) {
                ++n3;
            } else if (n3 == 1 && n2 == 93) {
                ++n3;
            } else {
                if (n3 == 2 && n2 == 62) {
                    this.nextChar();
                    if (fastStringBuffer != null) {
                        fastStringBuffer.setLength(fastStringBuffer.length() - 2);
                    }
                    return n - 2;
                }
                n3 = 0;
            }
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n2);
            }
            ++n;
            this.nextChar();
            n2 = this.peekChar();
        }
        return n;
    }

    private int parseComment(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.peekChar();
        int n3 = 0;
        while (n2 > 31 && n2 < 127 || n2 > 127 && n2 < 255 || n2 == 9 || n2 == 10) {
            if (n3 == 0 && n2 == 45) {
                ++n3;
            } else if (n3 == 1 && n2 == 45) {
                ++n3;
            } else {
                if (n3 == 2 && n2 == 62) {
                    this.nextChar();
                    if (fastStringBuffer != null) {
                        fastStringBuffer.setLength(fastStringBuffer.length() - 2);
                    }
                    return n - 2;
                }
                n3 = 0;
            }
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n2);
            }
            ++n;
            this.nextChar();
            n2 = this.peekChar();
        }
        return n;
    }

    private int parseIdentifier(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.peekChar();
        while (n2 > 47 && n2 < 59 || n2 > 64 && n2 < 91 || n2 > 96 && n2 < 123 || n2 == 95) {
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n2);
            }
            ++n;
            this.nextChar();
            n2 = this.peekChar();
        }
        return n;
    }

    private int parseQuoted(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.nextChar();
        int n3 = this.peekChar();
        while (n3 > 31 && n3 < 127 || n3 > 127 && n3 < 255) {
            if (n3 == n2) {
                this.nextChar();
                return n;
            }
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n3);
            }
            ++n;
            this.nextChar();
            n3 = this.peekChar();
        }
        return n;
    }

    private int parseText(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.peekChar();
        while (n2 > 31 && n2 < 127 || n2 > 127 && n2 < 255 || n2 == 9 || n2 == 10 || n2 == 13) {
            if (n2 == 60) {
                return n;
            }
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n2);
            }
            ++n;
            this.nextChar();
            n2 = this.peekChar();
        }
        return n;
    }

    private int parseWhitespace(FastStringBuffer fastStringBuffer) throws IOException {
        int n = 0;
        int n2 = this.peekChar();
        while (n2 == 32 || n2 == 9 || n2 == 10 || n2 == 13) {
            if (fastStringBuffer != null) {
                fastStringBuffer.append((char)n2);
            }
            ++n;
            this.nextChar();
            n2 = this.peekChar();
        }
        return n;
    }
}

