/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.ContextIds;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class BaseTraceInteractions
implements IUml2SDLoader,
ISelectionListener,
ISDFindProvider {
    protected SDView view;
    protected Frame frame;
    protected TraceProcesses currentProcesses;
    protected EObject currentMofObjectFromPDProjectExplorer;
    private Cursor waitCursor;
    protected IProgressMonitor monitor;
    protected HashMap traceThreadMap;
    protected ArrayList traceThreadList;

    public void setViewer(SDView sDView) {
        this.view = sDView;
        this.view.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.view.setSDFindProvider((ISDFindProvider)this);
        this.onSetViewer();
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
        this.parseModelBackground();
    }

    public abstract void onSetViewer();

    public void aboutToBeReplaced() {
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        this.clearInternals();
        this.view = null;
    }

    protected void clearInternals() {
        this.currentMofObjectFromPDProjectExplorer = null;
        this.currentProcesses = null;
        this.frame = null;
        if (this.waitCursor != null && !this.waitCursor.isDisposed()) {
            this.waitCursor.dispose();
        }
        this.waitCursor = null;
    }

    protected synchronized void parseModel(EObject eObject) {
        this.clearInternals();
        this.currentMofObjectFromPDProjectExplorer = eObject;
        this.createFrame();
        if (this.currentProcesses == null) {
            if (this.view != null && !this.view.getSDWidget().isDisposed()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
            return;
        }
        this.computeModel();
        try {
            this.fillPage(new TraceInteractionUpdate());
            if (this.view != null && !this.view.getSDWidget().isDisposed() && this.frame != null && !this.monitor.isCanceled()) {
                this.setFrameName();
                this.view.setFrameSync(this.frame);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected abstract void computeModel();

    protected abstract void updateSD(TraceInteractionUpdate var1);

    private void beforeLongTask(IProgressMonitor iProgressMonitor, String string) {
        if (this.view == null || this.view.getSDWidget().isDisposed()) {
            iProgressMonitor.setCanceled(true);
            return;
        }
        this.view.toggleWaitCursorSync(true);
        this.monitor = iProgressMonitor;
        this.monitor.beginTask(string, 100);
    }

    private void afterLongTask() {
        this.monitor.done();
        this.monitor = null;
        if (this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.view.toggleWaitCursorSync(false);
        }
    }

    protected void parseModelBackground() {
        final EObject eObject = HyadesUtil.getMofObject();
        if (eObject == null) {
            return;
        }
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(iProgressMonitor, TraceSDPlugin.getResourceString("TASK_NAME_CREATING_SD"));
                if (!BaseTraceInteractions.this.monitor.isCanceled()) {
                    BaseTraceInteractions.this.parseModel(eObject);
                }
                BaseTraceInteractions.this.afterLongTask();
            }
        });
    }

    protected void updateSDBackground(final TraceInteractionUpdate traceInteractionUpdate) {
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(iProgressMonitor, TraceSDPlugin.getResourceString("TASK_NAME_UPDATING_SD"));
                if (!BaseTraceInteractions.this.monitor.isCanceled()) {
                    BaseTraceInteractions.this.updateSD(traceInteractionUpdate);
                }
                BaseTraceInteractions.this.afterLongTask();
            }
        });
    }

    protected void ensureSelectedAndMoveToFirst(List list) {
        if (list != null && list.size() > 0) {
            this.view.getSDWidget().addSelection(list);
            this.view.ensureVisibleSync((GraphNode)list.get(0));
        }
    }

    protected void createFrame() {
        if (this.currentProcesses == null) {
            this.currentProcesses = TraceProcesses.getTraceProcesses(this.currentMofObjectFromPDProjectExplorer, this.monitor);
        }
        this.frame = new Frame();
        if (this.currentProcesses == null) {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_NO_PROCESSES_HERE"));
        } else {
            this.frame.setTimeUnitName(TraceSDPlugin.getResourceString("STR_TIME_UNIT_IS_SECOND"));
        }
    }

    public abstract void setFrameName();

    public abstract void fillPage(TraceInteractionUpdate var1);

    protected TraceCallStack getTraceCallStack(TRCThread tRCThread) {
        TraceCallStack traceCallStack = (TraceCallStack)this.traceThreadMap.get(tRCThread);
        if (traceCallStack == null) {
            traceCallStack = new TraceCallStack(this, tRCThread);
            this.traceThreadMap.put(tRCThread, traceCallStack);
            this.traceThreadList.add(traceCallStack);
        }
        return traceCallStack;
    }

    public void sortTraceThreadList(TraceCallStack traceCallStack) {
        this.traceThreadList.remove(traceCallStack);
        int n = 0;
        while (n < this.traceThreadList.size()) {
            TraceCallStack traceCallStack2 = (TraceCallStack)this.traceThreadList.get(n);
            if (traceCallStack.getCurrentExitTime() < traceCallStack2.getCurrentExitTime()) {
                this.traceThreadList.add(n, traceCallStack);
                return;
            }
            ++n;
        }
        this.traceThreadList.add(traceCallStack);
    }

    protected double getTraceThreadListFirstTime() {
        double d = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getCurrentExitTime() : Double.MAX_VALUE;
        return d;
    }

    protected void setExecutionOccurence(TraceLifelineDraft traceLifelineDraft) {
        if (traceLifelineDraft != null) {
            ExecutionOccurrence executionOccurrence = new ExecutionOccurrence();
            executionOccurrence.setStartOccurrence(traceLifelineDraft.getStart());
            executionOccurrence.setEndOccurrence(traceLifelineDraft.getEnd());
            traceLifelineDraft.getLifeline().addExecution(executionOccurrence);
        }
    }

    protected abstract EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation var1);

    protected abstract String getLifeLineTitle(EObject var1, boolean var2);

    protected abstract int getLifeLineCategory(EObject var1);

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof PDProjectExplorer) {
            if (!((PDProjectExplorer)iWorkbenchPart).isLinkingEnabled()) {
                return;
            }
            if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
                if (this.currentMofObjectFromPDProjectExplorer == HyadesUtil.getMofObject()) {
                    return;
                }
                this.parseModelBackground();
            }
        } else if (!(iWorkbenchPart instanceof SDView)) {
            if (this.frame == null) {
                return;
            }
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            this.externalSelectionChanged(iWorkbenchPart, iSelection, traceInteractionUpdate);
            if (traceInteractionUpdate.needsUpdate()) {
                this.updateSDBackground(traceInteractionUpdate);
            }
        }
    }

    protected void externalEObjectSelectionChanged(IEObjectSelection iEObjectSelection, TraceInteractionUpdate traceInteractionUpdate) {
        IEObjectSelection iEObjectSelection2 = iEObjectSelection;
        EObject eObject = iEObjectSelection2.getEObject();
        if (eObject instanceof TRCThread) {
            traceInteractionUpdate.setThreadSelectionChanged(true);
            traceInteractionUpdate.addSelectedThread((TRCThread)eObject);
        }
    }

    protected void externalSelectionChanged(IWorkbenchPart iWorkbenchPart, Object object, TraceInteractionUpdate traceInteractionUpdate) {
        if (object instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)object;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.externalSelectionChanged(iWorkbenchPart, e, traceInteractionUpdate);
            }
        } else if (!this.externalExtendedSelectionChanged(iWorkbenchPart, object, traceInteractionUpdate) && object instanceof IEObjectSelection) {
            this.externalEObjectSelectionChanged((IEObjectSelection)object, traceInteractionUpdate);
        }
    }

    protected abstract boolean externalExtendedSelectionChanged(IWorkbenchPart var1, Object var2, TraceInteractionUpdate var3);

    public boolean isLifelineSupported() {
        return true;
    }

    public boolean isSyncMessageSupported() {
        return false;
    }

    public boolean isSyncMessageReturnSupported() {
        return false;
    }

    public boolean isAsyncMessageSupported() {
        return false;
    }

    public boolean isAsyncMessageReturnSupported() {
        return false;
    }

    public boolean isStopSupported() {
        return false;
    }

    public boolean find(Criteria criteria) {
        int n;
        if (this.frame == null) {
            return false;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (criteria.isLifeLineSelected()) {
            n = 0;
            while (n < this.frame.lifeLinesCount()) {
                if (TraceInteractionUtils.matchCriteria(this.frame.getLifeline(n).getName(), criteria)) {
                    arrayList.add(this.frame.getLifeline(n));
                }
                ++n;
            }
        }
        if (criteria.isSyncMessageSelected()) {
            n = 0;
            while (n < this.frame.syncMessageCount()) {
                if (TraceInteractionUtils.matchCriteria(this.frame.getSyncMessage(n).getName(), criteria)) {
                    arrayList.add(this.frame.getSyncMessage(n));
                }
                ++n;
            }
        }
        this.view.getSDWidget().clearSelection();
        this.ensureSelectedAndMoveToFirst(arrayList);
        if (arrayList.size() > 0) {
            return true;
        }
        if (this instanceof ISDPagingProvider) {
            boolean bl;
            TraceInteractionUpdate traceInteractionUpdate = new TraceInteractionUpdate();
            traceInteractionUpdate.setFindRequired(true);
            traceInteractionUpdate.setFindCriteria(criteria);
            Frame frame = this.frame;
            this.updateSDBackground(traceInteractionUpdate);
            boolean bl2 = bl = traceInteractionUpdate.getFindResults() != null && traceInteractionUpdate.getFindResults().size() > 0;
            if (!bl) {
                this.frame = frame;
            }
            return bl;
        }
        return false;
    }
}

