/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.BaseTraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.ui.IWorkbenchPart;

public abstract class NoMessageInteractions
extends BaseTraceInteractions {
    private HashMap instancesMap;
    private TraceLifelineDraft currentTraceLifeline;
    private int lastEventOccurrence;
    protected double lastTime;

    public void onSetViewer() {
    }

    public void fillPage(TraceInteractionUpdate traceInteractionUpdate) {
        this.traceThreadMap = new HashMap();
        this.traceThreadList = new ArrayList();
        this.instancesMap = new HashMap();
        this.currentTraceLifeline = null;
        this.lastEventOccurrence = 1;
        this.currentProcesses.init();
        TRCFullMethodInvocation tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        while (tRCFullMethodInvocation != null && !this.monitor.isCanceled()) {
            this.getTraceLifelineDraftForMethodInvocation(this.frame, tRCFullMethodInvocation);
            tRCFullMethodInvocation = this.currentProcesses.consumeMethodInvocation();
        }
        if (this.currentTraceLifeline != null) {
            this.currentTraceLifeline.setEnd(this.lastEventOccurrence++);
            this.setExecutionOccurence(this.currentTraceLifeline);
            this.createSyncMessageReturn(this.currentTraceLifeline, null);
        }
        this.traceThreadMap = null;
        this.traceThreadList = null;
        this.instancesMap = null;
        this.currentTraceLifeline = null;
    }

    protected void getTraceLifelineDraftForMethodInvocation(Frame frame, TRCFullMethodInvocation tRCFullMethodInvocation) {
        EObject eObject = this.getLifelineEObjectFromMethodInvocation(tRCFullMethodInvocation);
        TraceLifelineDraft traceLifelineDraft = (TraceLifelineDraft)this.instancesMap.get(eObject);
        if (traceLifelineDraft != this.currentTraceLifeline && this.currentTraceLifeline != null) {
            this.currentTraceLifeline.setEnd(this.lastEventOccurrence++);
            this.setExecutionOccurence(this.currentTraceLifeline);
            this.createSyncMessageReturn(this.currentTraceLifeline, tRCFullMethodInvocation);
        }
        if (traceLifelineDraft == null) {
            traceLifelineDraft = new TraceLifelineDraft();
            this.instancesMap.put(eObject, traceLifelineDraft);
            Lifeline lifeline = new Lifeline();
            traceLifelineDraft.setLifeline(lifeline);
            lifeline.setName(this.getLifeLineTitle(eObject, this.currentProcesses.size() > 1));
            lifeline.setCategory(this.getLifeLineCategory(eObject));
            frame.addLifeLine(lifeline);
        }
        if (traceLifelineDraft != this.currentTraceLifeline) {
            traceLifelineDraft.setMethodInvocation(tRCFullMethodInvocation);
            traceLifelineDraft.setStart(this.lastEventOccurrence++);
            this.createSyncMessage(traceLifelineDraft);
            this.currentTraceLifeline = traceLifelineDraft;
        }
    }

    protected void createSyncMessage(TraceLifelineDraft traceLifelineDraft) {
        SyncMessage syncMessage = new SyncMessage();
        traceLifelineDraft.getLifeline().setCurrentEventOccurrence(traceLifelineDraft.getStart());
        syncMessage.setEndLifeline(traceLifelineDraft.getLifeline());
        syncMessage.setTime(this.getEntryTime(traceLifelineDraft.getMethodInvocation()));
        this.frame.addMessage((BaseMessage)syncMessage);
    }

    protected void createSyncMessageReturn(TraceLifelineDraft traceLifelineDraft, TRCFullMethodInvocation tRCFullMethodInvocation) {
        SyncMessageReturn syncMessageReturn = new SyncMessageReturn();
        traceLifelineDraft.getLifeline().setCurrentEventOccurrence(traceLifelineDraft.getEnd());
        syncMessageReturn.setStartLifeline(traceLifelineDraft.getLifeline());
        if (tRCFullMethodInvocation != null) {
            if (tRCFullMethodInvocation.getProcess() == traceLifelineDraft.getMethodInvocation().getProcess()) {
                syncMessageReturn.setTime(this.getEntryTime(tRCFullMethodInvocation));
            } else {
                syncMessageReturn.setTime(TraceInteractionUtils.getAbsoluteExitTime(traceLifelineDraft.getMethodInvocation()));
            }
        } else {
            syncMessageReturn.setTime(this.lastTime);
        }
        this.frame.addMessage((BaseMessage)syncMessageReturn);
    }

    protected abstract double getEntryTime(TRCFullMethodInvocation var1);

    protected void updateSD(TraceInteractionUpdate traceInteractionUpdate) {
    }

    protected void computeModel() {
        this.lastTime = 0.0;
        Iterator iterator = this.currentProcesses.iterator();
        while (iterator.hasNext()) {
            TRCProcess tRCProcess = ((TraceProcess)iterator.next()).getProcess();
            double d = TraceInteractionUtils.getAbsoluteEntryTime(tRCProcess);
            double d2 = TraceInteractionUtils.getAbsoluteExitTime(tRCProcess);
            if (!(this.lastTime < d2)) continue;
            this.lastTime = d2;
        }
    }

    protected boolean externalExtendedSelectionChanged(IWorkbenchPart iWorkbenchPart, Object object, TraceInteractionUpdate traceInteractionUpdate) {
        return false;
    }
}

