/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.NoMessageInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;

public class ThreadInteractions
extends NoMessageInteractions {
    public static final int CATEGORY_THREAD = 0;
    private static LifelineCategories[] traceCategories = new LifelineCategories[1];

    protected void createFrame() {
        super.createFrame();
        this.frame.setLifelineCategories(traceCategories);
    }

    public void setFrameName() {
        if (this.currentProcesses != null && this.currentProcesses.size() == 1) {
            TRCProcess tRCProcess = ((TraceProcess)this.currentProcesses.get(0)).getProcess();
            this.frame.setName(tRCProcess.getAgent().getAgentProxy().getProcessProxy().getName() + " [Pid " + tRCProcess.getPid() + "]");
        } else {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_SEVERAL_PROCESSES"));
        }
    }

    protected EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation tRCFullMethodInvocation) {
        return tRCFullMethodInvocation.getThread();
    }

    protected int getLifeLineCategory(EObject eObject) {
        return 0;
    }

    protected String getLifeLineTitle(EObject eObject, boolean bl) {
        TRCThread tRCThread = (TRCThread)eObject;
        return tRCThread.getName() + (bl ? " " + TraceSDPlugin.getResourceString("STR_PROCESS") + " " + tRCThread.getProcess().getAgent().getAgentProxy().getProcessProxy().getName() + " [Pid " + tRCThread.getProcess().getPid() + "]" : "");
    }

    public String getTitleString() {
        return TraceSDPlugin.getResourceString("STR_UML2SD_THREAD_INTERACTION");
    }

    protected double getEntryTime(TRCFullMethodInvocation tRCFullMethodInvocation) {
        if (tRCFullMethodInvocation == tRCFullMethodInvocation.getProcess().getInvocations().get(0)) {
            return TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation.getThread());
        }
        return TraceInteractionUtils.getAbsoluteEntryTime(tRCFullMethodInvocation);
    }

    static {
        ThreadInteractions.traceCategories[0] = new LifelineCategories();
        traceCategories[0].setName(TraceSDPlugin.getResourceString("STR_THREAD"));
        traceCategories[0].setImage((IImage)new ImageImpl(TraceSDPlugin.getResourceImage("thread_obj.gif")));
    }
}

