/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

public class TraceInteractionUtils {
    public static void searchTRCProcesses(EObject eObject, TraceProcesses traceProcesses, IProgressMonitor iProgressMonitor) {
        TRCAgent tRCAgent;
        TRCProcess tRCProcess;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (eObject instanceof TRCMonitor) {
            TRCMonitor tRCMonitor = (TRCMonitor)eObject;
            if (tRCMonitor.getNodes() == null || tRCMonitor.getNodes().isEmpty()) {
                return;
            }
            Iterator iterator = tRCMonitor.getNodes().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCNode) {
            TRCNode tRCNode = (TRCNode)eObject;
            if (tRCNode.getProcessProxies() == null || tRCNode.getProcessProxies().isEmpty()) {
                return;
            }
            Iterator iterator = tRCNode.getProcessProxies().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCProcessProxy) {
            TRCProcessProxy tRCProcessProxy = (TRCProcessProxy)eObject;
            if (tRCProcessProxy.getAgentProxies() == null || tRCProcessProxy.getAgentProxies().isEmpty()) {
                return;
            }
            Iterator iterator = tRCProcessProxy.getAgentProxies().iterator();
            while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
                TraceInteractionUtils.searchTRCProcesses((EObject)iterator.next(), traceProcesses, iProgressMonitor);
            }
        } else if (eObject instanceof TRCAgentProxy && ((TRCAgentProxy)eObject).getType().equals("Profiler") && (tRCProcess = TraceUtils.getProcess((TRCAgent)(tRCAgent = ((TRCAgentProxy)eObject).getAgent()))) != null && tRCProcess.getInvocations() != null) {
            traceProcesses.add(new TraceProcess(tRCProcess));
        }
    }

    public static double getAbsoluteEntryTime(TRCFullMethodInvocation tRCFullMethodInvocation) {
        return tRCFullMethodInvocation.getProcess().getAgent().getStartTime() + tRCFullMethodInvocation.getProcess().getStartTime() + tRCFullMethodInvocation.getEntryTime();
    }

    public static double getAbsoluteEntryTime(TRCAgent tRCAgent) {
        return tRCAgent.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCProcess tRCProcess) {
        return tRCProcess.getAgent().getStartTime() + tRCProcess.getStartTime();
    }

    public static double getAbsoluteEntryTime(TRCThread tRCThread) {
        return tRCThread.getProcess().getAgent().getStartTime() + tRCThread.getProcess().getStartTime() + tRCThread.getStartTime();
    }

    public static double getAbsoluteExitTime(TRCFullMethodInvocation tRCFullMethodInvocation) {
        return tRCFullMethodInvocation.getProcess().getAgent().getStartTime() + tRCFullMethodInvocation.getProcess().getStartTime() + tRCFullMethodInvocation.getExitTime();
    }

    public static double getAbsoluteExitTime(TRCAgent tRCAgent) {
        return tRCAgent.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCProcess tRCProcess) {
        return tRCProcess.getAgent().getStartTime() + tRCProcess.getStopTime();
    }

    public static double getAbsoluteExitTime(TRCThread tRCThread) {
        return tRCThread.getProcess().getAgent().getStartTime() + tRCThread.getProcess().getStartTime() + tRCThread.getStopTime();
    }

    public static boolean matchCharacter(char c, char c2, boolean bl) {
        return c == c2 || !bl && Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean matchCriteria(String string, Criteria criteria) {
        String string2 = criteria.getExpression();
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            block8: {
                char c = string.charAt(n);
                char c2 = string2.charAt(n2);
                if (c2 == '*') {
                    if (n2 + 1 >= string2.length()) return true;
                    if (TraceInteractionUtils.matchCharacter(c, string2.charAt(n2 + 1), criteria.isCaseSenstiveSelected())) {
                        n2 += 2;
                    }
                } else {
                    if (c2 == '?') {
                        if (n2 + 1 < string2.length()) {
                            if (!TraceInteractionUtils.matchCharacter(string.charAt(n + 1), string2.charAt(n2 + 1), criteria.isCaseSenstiveSelected())) return false;
                            ++n2;
                            break block8;
                        } else {
                            if (n + 1 != string.length()) return false;
                            return true;
                        }
                    }
                    if (!TraceInteractionUtils.matchCharacter(c, c2, criteria.isCaseSenstiveSelected())) {
                        return false;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (n != string.length()) return false;
        if (n2 == string2.length()) return true;
        if (n2 + 1 != string2.length()) return false;
        if (string2.charAt(n2) == '*') return true;
        if (string2.charAt(n2) != '?') return false;
        return true;
    }
}

