/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;

public class TraceProcesses
extends ArrayList {
    private ArrayList sortedProcesses;

    public TRCFullMethodInvocation consumeMethodInvocation() {
        if (this.sortedProcesses.isEmpty()) {
            return null;
        }
        TraceProcess traceProcess = (TraceProcess)this.sortedProcesses.get(0);
        TRCFullMethodInvocation tRCFullMethodInvocation = traceProcess.nextInvocation();
        if (traceProcess.hasNext()) {
            if (traceProcess.getCurrentTime() > ((TraceProcess)this.sortedProcesses.get(0)).getCurrentTime()) {
                this.sortedProcesses.remove(traceProcess);
                this.sortProcess(traceProcess);
            }
        } else {
            this.sortedProcesses.remove(traceProcess);
        }
        return tRCFullMethodInvocation;
    }

    public double getStartTime() {
        if (this.sortedProcesses.isEmpty()) {
            return 0.0;
        }
        return ((TraceProcess)this.sortedProcesses.get(0)).getStartTime();
    }

    public void init() {
        this.sortedProcesses = new ArrayList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            TraceProcess traceProcess = (TraceProcess)iterator.next();
            traceProcess.init();
            this.sortProcess(traceProcess);
        }
    }

    private void sortProcess(TraceProcess traceProcess) {
        double d = traceProcess.getCurrentTime();
        int n = 0;
        while (n < this.sortedProcesses.size()) {
            if (((TraceProcess)this.sortedProcesses.get(n)).getCurrentTime() > d) {
                this.sortedProcesses.add(n, traceProcess);
                return;
            }
            ++n;
        }
        this.sortedProcesses.add(traceProcess);
    }

    public boolean contains(TRCProcess tRCProcess) {
        int n = 0;
        while (n < this.size()) {
            TraceProcess traceProcess = (TraceProcess)this.get(n);
            if (traceProcess.getProcess() == tRCProcess) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static TraceProcesses getTraceProcesses(EObject eObject, IProgressMonitor iProgressMonitor) {
        TraceProcesses traceProcesses = new TraceProcesses();
        TraceInteractionUtils.searchTRCProcesses(eObject, traceProcesses, iProgressMonitor);
        if (traceProcesses.isEmpty()) {
            return null;
        }
        return traceProcesses;
    }
}

