/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionResultDetailPage
extends DetailSection.DetailPage
implements IHyperlinkListener {
    private SelectableFormLabel testLink;
    private Label imageLabel;
    private StyledText typeText;
    private StyledText fileText;
    private StyledText verdictText;
    private StyledText startText;
    private StyledText stopText;
    private TPFExecutionResult executionResult;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public void dispose() {
        if (this.testLink != null && !this.testLink.isDisposed()) {
            this.testLink.setData(null);
        }
        this.executionResult = null;
    }

    public Control createControl(Composite composite, FormWidgetFactory formWidgetFactory) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.createTestLink(composite2);
        widgetFactory.createLabel(composite2, "").setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, TestUIPlugin.getString("LBL_VERD"));
        this.verdictText = widgetFactory.createStyledText(composite2, 65540);
        this.verdictText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.verdictText.setEditable(false);
        widgetFactory.createLabel(composite2, TestUIPlugin.getString("LBL_START"));
        this.startText = widgetFactory.createStyledText(composite2, 65540);
        this.startText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.startText.setEditable(false);
        widgetFactory.createLabel(composite2, TestUIPlugin.getString("LBL_STOP"));
        this.stopText = widgetFactory.createStyledText(composite2, 65540);
        this.stopText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.stopText.setEditable(false);
        widgetFactory.paintBordersFor(composite2);
        return composite2;
    }

    protected void createTestLink(Composite composite) {
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.imageLabel = widgetFactory.createLabel(composite2, "");
        this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
        this.testLink = widgetFactory.createSelectableLabel(composite2, "");
        this.testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
        this.testLink.setToolTipText(TestUIPlugin.getString("TIP_EXE_TEST"));
        widgetFactory.turnIntoHyperlink((Control)this.testLink, this);
        Composite composite3 = widgetFactory.createComposite(composite);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite3, TestUIPlugin.getString("L_TYPE"));
        this.typeText = widgetFactory.createStyledText(composite3, 65540);
        this.typeText.setEnabled(false);
        this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite3, TestUIPlugin.getString("L_FILE"));
        this.fileText = widgetFactory.createStyledText(composite3, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    public void setInput(Object object) {
        IStructuredSelection iStructuredSelection;
        this.executionResult = null;
        if (object instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)object).size() == 1) {
            object = iStructuredSelection.getFirstElement();
        }
        boolean bl = false;
        boolean bl2 = false;
        if (object instanceof TPFExecutionResult) {
            this.executionResult = (TPFExecutionResult)object;
            TPFTest tPFTest = this.executionResult.getTest();
            bl = true;
            if (tPFTest != null) {
                String string;
                IWorkbenchAdapter iWorkbenchAdapter;
                bl2 = true;
                ImageDescriptor imageDescriptor = null;
                if (tPFTest instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)tPFTest.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ExecutionResultDetailPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                    imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)tPFTest);
                }
                if (imageDescriptor == null) {
                    imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
                }
                this.imageLabel.setImage(imageDescriptor.createImage());
                if (tPFTest.getName() != null) {
                    this.testLink.setText(tPFTest.getName());
                } else {
                    this.testLink.setText(TestUIPlugin.getString("W_TEST"));
                }
                this.testLink.setData(tPFTest);
                iWorkbenchAdapter = null;
                iWorkbenchAdapter = tPFTest instanceof TPFTestSuite ? (TPFTestSuite)tPFTest : ((TPFTestCase)tPFTest).getTestSuite();
                if (iWorkbenchAdapter != null && (string = iWorkbenchAdapter.getType()) != null) {
                    IAssociationDescriptor iAssociationDescriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(string);
                    if (iAssociationDescriptor != null && iAssociationDescriptor.getName() != null) {
                        string = iAssociationDescriptor.getName();
                    }
                    this.typeText.setText(string);
                }
                if ((string = EMFUtil.getWorkspaceFile((EObject)iWorkbenchAdapter)) != null) {
                    this.fileText.setText(string.getFullPath().toString());
                }
                if (this.executionResult.getVerdict() != null) {
                    this.verdictText.setText(this.executionResult.getVerdict().getLabel());
                } else {
                    this.verdictText.setText("");
                }
                long l = 0L;
                long l2 = 0L;
                Iterator iterator = this.executionResult.getExecutionHistory().getExecutionEvents().iterator();
                while (iterator.hasNext()) {
                    TPFExecutionType tPFExecutionType;
                    TPFExecutionEvent tPFExecutionEvent = (TPFExecutionEvent)iterator.next();
                    if (!(tPFExecutionEvent instanceof TPFTypedEvent) || (tPFExecutionType = ((TPFTypedEvent)tPFExecutionEvent).getType()) == null) continue;
                    switch (tPFExecutionType.getValue()) {
                        case 0: {
                            l = tPFExecutionEvent.getTimestamp();
                            break;
                        }
                        case 1: {
                            l2 = tPFExecutionEvent.getTimestamp();
                        }
                    }
                    if (l != 0L && l2 != 0L) break;
                }
                this.startText.setText(EventUtil.getTime(l));
                this.stopText.setText(EventUtil.getTime(l2));
            }
        } else {
            this.verdictText.setText("");
            this.startText.setText("");
            this.stopText.setText("");
        }
        if (!bl2) {
            bl = true;
            this.imageLabel.setImage(TestUIImages.INSTANCE.getImage("error_obj.gif"));
            this.testLink.setText(TestUIPlugin.getString("NO_TST_TO_INV"));
            this.testLink.setData(null);
            this.fileText.setText("");
            this.typeText.setText("");
        }
        if (bl) {
            this.imageLabel.pack(true);
            this.imageLabel.redraw();
            this.testLink.pack(true);
            this.testLink.redraw();
        }
    }

    public Object getInput() {
        return this.executionResult;
    }

    public void linkActivated(Control control) {
        EObject eObject;
        IFile iFile;
        Object object = control.getData();
        if (object != null && (iFile = EMFUtil.getWorkspaceFile(eObject = (EObject)object)) != null) {
            IEditorPart iEditorPart = UIUtil.openEditor((IFile)iFile, null, (boolean)false);
            if (iEditorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)iEditorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        eObject = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        iFile = eObject.getStatusLineManager();
        if (iFile != null) {
            iFile.setErrorMessage(TestUIPlugin.getString("MSG_UN_OPEN_OBJ"));
        }
    }

    public void linkEntered(Control control) {
        IActionBars iActionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
        if (iStatusLineManager != null) {
            iStatusLineManager.setMessage(((SelectableFormLabel)control).getText());
        }
    }

    public void linkExited(Control control) {
        IActionBars iActionBars = this.getEditorForm().getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager iStatusLineManager = iActionBars.getStatusLineManager();
        if (iStatusLineManager != null) {
            iStatusLineManager.setMessage("");
            iStatusLineManager.setErrorMessage("");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

