/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class HyperlinkHandler
extends HyperlinkSettings
implements MouseListener,
MouseTrackListener,
SelectionListener,
PaintListener {
    private Hashtable hyperlinkListeners = new Hashtable();
    private Control lastActivated;
    private Control lastEntered;

    public Control getLastLink() {
        return this.lastActivated;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            return;
        }
        this.lastActivated = (Control)mouseEvent.widget;
    }

    public void mouseEnter(MouseEvent mouseEvent) {
        Control control = (Control)mouseEvent.widget;
        this.linkEntered(control);
    }

    public void mouseExit(MouseEvent mouseEvent) {
        Control control = (Control)mouseEvent.widget;
        this.linkExited(control);
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (mouseEvent.button != 1) {
            return;
        }
        Control control = (Control)mouseEvent.widget;
        Point point = control.getSize();
        if (mouseEvent.x < 0) {
            return;
        }
        if (mouseEvent.y < 0) {
            return;
        }
        if (mouseEvent.x >= point.x) {
            return;
        }
        if (mouseEvent.y >= point.y) {
            return;
        }
        this.linkActivated(control);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        Control control = (Control)selectionEvent.widget;
        this.linkActivated(control);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Control control = (Control)selectionEvent.widget;
        SelectableFormLabel selectableFormLabel = (SelectableFormLabel)control;
        if (selectableFormLabel.getSelection()) {
            this.linkEntered(control);
        } else {
            this.linkExited(control);
        }
    }

    private void linkActivated(Control control) {
        IHyperlinkListener iHyperlinkListener = (IHyperlinkListener)this.hyperlinkListeners.get(control);
        if (iHyperlinkListener != null) {
            control.setCursor(this.getBusyCursor());
            iHyperlinkListener.linkActivated(control);
            if (!control.isDisposed()) {
                control.setCursor(this.isHyperlinkCursorUsed() ? this.getHyperlinkCursor() : null);
            }
        }
    }

    private void linkEntered(Control control) {
        Object object;
        if (this.lastEntered != null && this.lastEntered instanceof SelectableFormLabel) {
            object = (SelectableFormLabel)this.lastEntered;
            this.linkExited((Control)object);
        }
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(this.getHyperlinkCursor());
        }
        if (this.activeBackground != null) {
            control.setBackground(this.activeBackground);
        }
        if (this.activeForeground != null) {
            control.setForeground(this.activeForeground);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, true);
        }
        if ((object = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            object.linkEntered(control);
        }
        this.lastEntered = control;
    }

    private void linkExited(Control control) {
        IHyperlinkListener iHyperlinkListener;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(null);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, false);
        }
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        if ((iHyperlinkListener = (IHyperlinkListener)this.hyperlinkListeners.get(control)) != null) {
            iHyperlinkListener.linkExited(control);
        }
        if (this.lastEntered == control) {
            this.lastEntered = null;
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        Control control = (Control)paintEvent.widget;
        if (this.hyperlinkUnderlineMode == 3) {
            HyperlinkHandler.underline(control, true);
        }
    }

    public void registerHyperlink(Control control, IHyperlinkListener iHyperlinkListener) {
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        control.addMouseListener((MouseListener)this);
        control.addMouseTrackListener((MouseTrackListener)this);
        if (this.hyperlinkUnderlineMode == 3 && control instanceof Label) {
            control.addPaintListener((PaintListener)this);
        }
        if (control instanceof SelectableFormLabel) {
            SelectableFormLabel selectableFormLabel = (SelectableFormLabel)control;
            selectableFormLabel.addSelectionListener(this);
            if (this.hyperlinkUnderlineMode == 3) {
                selectableFormLabel.setUnderlined(true);
            }
        }
        this.hyperlinkListeners.put(control, iHyperlinkListener);
        this.removeDisposedLinks();
    }

    private void removeDisposedLinks() {
        Enumeration enumeration = this.hyperlinkListeners.keys();
        while (enumeration.hasMoreElements()) {
            Control control = (Control)enumeration.nextElement();
            if (!control.isDisposed()) continue;
            this.hyperlinkListeners.remove(control);
        }
    }

    public void reset() {
        this.hyperlinkListeners.clear();
    }

    public static void underline(Control control, boolean bl) {
        if (control instanceof SelectableFormLabel) {
            SelectableFormLabel selectableFormLabel = (SelectableFormLabel)control;
            selectableFormLabel.setUnderlined(bl);
            selectableFormLabel.redraw();
            return;
        }
        if (!(control instanceof Label)) {
            return;
        }
        Composite composite = control.getParent();
        Rectangle rectangle = control.getBounds();
        GC gC = new GC((Drawable)composite);
        Color color = bl ? control.getForeground() : control.getBackground();
        gC.setForeground(color);
        int n = rectangle.y + rectangle.height;
        gC.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
        gC.dispose();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.removeDisposedLinks();
        Enumeration enumeration = this.hyperlinkListeners.keys();
        while (enumeration.hasMoreElements()) {
            Control control = (Control)enumeration.nextElement();
            control.setForeground(color);
        }
    }
}

