/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TextSegment;
import org.eclipse.swt.graphics.GC;

public class Paragraph
implements IParagraph {
    public static final String HTTP = "http://";
    private Vector segments;
    private boolean addVerticalSpace = true;

    public Paragraph(boolean bl) {
        this.addVerticalSpace = bl;
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public IParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new IParagraphSegment[0];
        }
        return this.segments.toArray(new IParagraphSegment[this.segments.size()]);
    }

    public void addSegment(IParagraphSegment iParagraphSegment) {
        if (this.segments == null) {
            this.segments = new Vector();
        }
        this.segments.add(iParagraphSegment);
    }

    public void parseRegularText(String string, boolean bl, HyperlinkSettings hyperlinkSettings, String string2) {
        if (string.length() == 0) {
            return;
        }
        if (bl) {
            int n = string.indexOf(HTTP);
            if (n == -1) {
                this.addSegment(new TextSegment(string, string2));
            } else {
                int n2 = 0;
                while (n != -1) {
                    this.addSegment(new TextSegment(string.substring(n2, n), string2));
                    boolean bl2 = false;
                    n2 = n;
                    while (n2 < string.length()) {
                        char c = string.charAt(n2);
                        if (Character.isSpaceChar(c)) {
                            this.addHyperlinkSegment(string.substring(n, n2), hyperlinkSettings, string2);
                            bl2 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl2) {
                        this.addHyperlinkSegment(string.substring(n), hyperlinkSettings, string2);
                        break;
                    }
                    n = string.indexOf(HTTP, n2);
                }
                if (n2 < string.length()) {
                    this.addSegment(new TextSegment(string.substring(n2), string2));
                }
            }
        } else {
            this.addSegment(new TextSegment(string, string2));
        }
    }

    private void addHyperlinkSegment(String string, HyperlinkSettings hyperlinkSettings, String string2) {
        HyperlinkSegment hyperlinkSegment = new HyperlinkSegment(string, hyperlinkSettings, string2);
        hyperlinkSegment.setWordWrapAllowed(false);
        hyperlinkSegment.setActionId("urlHandler");
        this.addSegment(hyperlinkSegment);
    }

    public void paint(GC gC, int n, Locator locator, int n2, Hashtable hashtable, IHyperlinkSegment iHyperlinkSegment) {
        IParagraphSegment[] iParagraphSegmentArray = this.getSegments();
        if (iParagraphSegmentArray.length > 0) {
            if (iParagraphSegmentArray[0] instanceof ITextSegment && ((ITextSegment)iParagraphSegmentArray[0]).isSelectable()) {
                ++locator.x;
            }
            int n3 = 0;
            while (n3 < iParagraphSegmentArray.length) {
                IParagraphSegment iParagraphSegment = iParagraphSegmentArray[n3];
                boolean bl = false;
                if (iHyperlinkSegment != null && iParagraphSegment.equals(iHyperlinkSegment)) {
                    bl = true;
                }
                iParagraphSegment.paint(gC, n, locator, hashtable, bl);
                ++n3;
            }
            locator.y += locator.rowHeight;
        } else {
            locator.y += n2;
        }
    }

    public String getAccessibleText() {
        IParagraphSegment[] iParagraphSegmentArray = this.getSegments();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        while (n < iParagraphSegmentArray.length) {
            IParagraphSegment iParagraphSegment = iParagraphSegmentArray[n];
            if (iParagraphSegment instanceof ITextSegment) {
                String string = ((ITextSegment)iParagraphSegment).getText();
                printWriter.print(string);
            }
            ++n;
        }
        printWriter.println();
        stringWriter.flush();
        return stringWriter.toString();
    }

    public ITextSegment findSegmentAt(int n, int n2) {
        if (this.segments != null) {
            int n3 = 0;
            while (n3 < this.segments.size()) {
                ITextSegment iTextSegment;
                IParagraphSegment iParagraphSegment = (IParagraphSegment)this.segments.get(n3);
                if (iParagraphSegment instanceof ITextSegment && (iTextSegment = (ITextSegment)iParagraphSegment).contains(n, n2)) {
                    return iTextSegment;
                }
                ++n3;
            }
        }
        return null;
    }
}

