/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class EMFContentProvider
implements ITreeContentProvider,
IDisposable {
    private TreeViewer treeViewer;
    private ResourceSet resourceSet;
    private Map elementDescriptionByFileExtension;
    private Map enabledChildrenByParentEClassifier;
    private boolean showEMFResource;
    private boolean showEnabledChildren;

    public EMFContentProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.elementDescriptionByFileExtension = new HashMap();
        this.enabledChildrenByParentEClassifier = new HashMap();
        this.showEMFResource = false;
    }

    public void dispose() {
        this.treeViewer = null;
        this.elementDescriptionByFileExtension.clear();
        this.enabledChildrenByParentEClassifier.clear();
    }

    public void addElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.put(elementDescription.getFileExtension(), elementDescription);
    }

    public void removeElementDescription(ElementDescription elementDescription) {
        this.elementDescriptionByFileExtension.remove(elementDescription.getFileExtension());
    }

    public void addEnabledChildren(EnabledChildren enabledChildren) {
        this.enabledChildrenByParentEClassifier.put(enabledChildren.getParentEClassifier(), enabledChildren);
    }

    public void removeEnabledChildren(EnabledChildren enabledChildren) {
        this.enabledChildrenByParentEClassifier.remove(enabledChildren.getParentEClassifier());
    }

    public boolean isShowEMFResource() {
        return this.showEMFResource;
    }

    public void setShowEMFResource(boolean bl) {
        this.showEMFResource = bl;
    }

    public boolean isShowEnabledChildren() {
        return this.showEnabledChildren;
    }

    public void setShowEnabledChildren(boolean bl) {
        this.showEnabledChildren = bl;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.treeViewer = (TreeViewer)viewer;
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof Resource) {
            IFile iFile = EMFUtil.getWorkspaceFile((Resource)object);
            if (iFile != null) {
                return iFile.getParent();
            }
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (eObject.eContainer() != null) {
                return eObject.eContainer();
            }
            if (this.isShowEMFResource()) {
                return eObject.eResource();
            }
            IFile iFile = EMFUtil.getWorkspaceFile(eObject);
            if (iFile != null) {
                return iFile.getParent();
            }
        }
        return null;
    }

    public Object[] getElements(Object object) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        if (object instanceof IWorkspaceRoot) {
            arrayList.addAll(Arrays.asList(((IWorkspaceRoot)object).getProjects()));
        }
        arrayList.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        block12: {
            EObject eObject;
            EnabledChildren enabledChildren;
            block11: {
                if (NavigatorExtensionUtil.hasChildren((Object)object, (String)"org.eclipse.hyades.test.ui.TestNavigator")) {
                    return true;
                }
                if (!(object instanceof IContainer)) break block11;
                IContainer iContainer = (IContainer)object;
                if (!iContainer.exists()) {
                    return false;
                }
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = iContainer.members();
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError(coreException);
                    return false;
                }
                int n = 0;
                int n2 = iResourceArray.length;
                while (n < n2) {
                    ElementDescription elementDescription;
                    if (iResourceArray[n].getType() != 1) {
                        return true;
                    }
                    String string = iResourceArray[n].getFileExtension();
                    if (string != null && (elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(string)) != null) {
                        EObject[] eObjectArray = EMFUtil.load(this.resourceSet, (IFile)iResourceArray[n]);
                        Iterator iterator = elementDescription.getEClassifiers().iterator();
                        while (iterator.hasNext()) {
                            if (EcoreUtil.getObjectByType(Arrays.asList(eObjectArray), (EClassifier)((EClassifier)iterator.next())) == null) continue;
                            return true;
                        }
                    }
                    ++n;
                }
                break block12;
            }
            if (object instanceof Resource) {
                return !((Resource)object).getContents().isEmpty();
            }
            if (!(object instanceof EObject) || !this.isShowEnabledChildren() || (enabledChildren = (EnabledChildren)this.enabledChildrenByParentEClassifier.get((eObject = (EObject)object).eClass())) == null) break block12;
            Iterator iterator = enabledChildren.getChildrenEStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object2 = eObject.eGet((EStructuralFeature)iterator.next(), true);
                if (object2 == null) continue;
                if (object2 instanceof Collection) {
                    return !((Collection)object2).isEmpty();
                }
                return true;
            }
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        EObject eObject;
        EnabledChildren enabledChildren;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object instanceof IContainer) {
            IResource[] iResourceArray = null;
            try {
                iResourceArray = ((IContainer)object).members();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                arrayList.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
                return arrayList.toArray();
            }
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                if (iResourceArray[n].getType() != 1) {
                    arrayList.add(iResourceArray[n]);
                } else {
                    ElementDescription elementDescription;
                    String string = iResourceArray[n].getFileExtension();
                    if (string != null && (elementDescription = (ElementDescription)this.elementDescriptionByFileExtension.get(string)) != null) {
                        EObject[] eObjectArray = EMFUtil.load(this.resourceSet, (IFile)iResourceArray[n]);
                        Iterator iterator = elementDescription.getEClassifiers().iterator();
                        while (iterator.hasNext()) {
                            Collection collection = EcoreUtil.getObjectsByType(Arrays.asList(eObjectArray), (EClassifier)((EClassifier)iterator.next()));
                            if (this.isShowEMFResource()) {
                                Iterator iterator2 = collection.iterator();
                                while (iterator2.hasNext()) {
                                    arrayList.add(((EObject)iterator2.next()).eResource());
                                }
                                continue;
                            }
                            arrayList.addAll(collection);
                        }
                    }
                }
                ++n;
            }
        } else if (object instanceof Resource) {
            arrayList.addAll((Collection<Object>)((Resource)object).getContents());
        } else if (object instanceof EObject && this.isShowEnabledChildren() && (enabledChildren = (EnabledChildren)this.enabledChildrenByParentEClassifier.get((eObject = (EObject)object).eClass())) != null) {
            Iterator iterator = enabledChildren.getChildrenEStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object2 = eObject.eGet((EStructuralFeature)iterator.next(), true);
                if (object2 == null) continue;
                if (object2 instanceof Collection) {
                    arrayList.addAll((Collection)object2);
                    continue;
                }
                arrayList.add(object2);
            }
        }
        arrayList.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)"org.eclipse.hyades.test.ui.TestNavigator"));
        return arrayList.toArray();
    }

    public static class EnabledChildren {
        private EClassifier parentEClassifier;
        private List childrenEStructuralFeatures;

        public EnabledChildren(EClassifier eClassifier) {
            this.parentEClassifier = eClassifier;
        }

        public EClassifier getParentEClassifier() {
            return this.parentEClassifier;
        }

        public List getChildrenEStructuralFeatures() {
            if (this.childrenEStructuralFeatures == null) {
                this.childrenEStructuralFeatures = new UniqueEList();
            }
            return this.childrenEStructuralFeatures;
        }
    }

    public static class ElementDescription {
        private String fileExtension;
        private List eClassifiers;

        public ElementDescription(String string) {
            this.fileExtension = string;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public List getEClassifiers() {
            if (this.eClassifiers == null) {
                this.eClassifiers = new UniqueEList();
            }
            return this.eClassifiers;
        }
    }
}

