/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorFilter;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestNavigatorProvider
implements ITreeContentProvider,
ILabelProvider,
ILabelProviderListener {
    private Map visibleElementFromFile = new HashMap();
    private Map visibleElementFromObject = new HashMap();
    private List filters;
    private List listeners = new LinkedList();
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public TestNavigatorProvider() {
        this.filters = new LinkedList();
    }

    public void addVisibleFile(String string, IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider, IHyadesTestNavigatorConverter iHyadesTestNavigatorConverter) {
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if (this.visibleElementFromFile.containsKey(string)) {
            TestUIPlugin.logInfo("Extension file: '." + string + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");
            return;
        }
        if (iHyadesTestNavigatorProvider != null) {
            iHyadesTestNavigatorProvider.addListener(this);
        }
        this.visibleElementFromFile.put(string, new fileExtensionElement(iHyadesTestNavigatorProvider, iHyadesTestNavigatorConverter));
    }

    public void addVisibleObject(String string, IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider) {
        if (this.visibleElementFromObject.containsKey(string)) {
            TestUIPlugin.logInfo("Extension file: '." + string + "' can't be registered as a visible element in the Test Navigator due to a previous registration by another plug-in");
            return;
        }
        this.visibleElementFromObject.put(string, iHyadesTestNavigatorProvider);
        iHyadesTestNavigatorProvider.addListener(this);
    }

    public void addFilter(IHyadesTestNavigatorFilter iHyadesTestNavigatorFilter) {
        this.filters.add(iHyadesTestNavigatorFilter);
    }

    public Object getParent(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private IHyadesTestNavigatorProvider getProviderFromFile(IFile iFile) {
        fileExtensionElement fileExtensionElement2;
        String string = iFile.getFileExtension();
        if (string != null && (fileExtensionElement2 = (fileExtensionElement)this.visibleElementFromFile.get(string)) != null) {
            return fileExtensionElement2.getProvider();
        }
        return null;
    }

    private IHyadesTestNavigatorConverter getConverterFromFile(IFile iFile) {
        fileExtensionElement fileExtensionElement2;
        String string = iFile.getFileExtension();
        if (string != null && (fileExtensionElement2 = (fileExtensionElement)this.visibleElementFromFile.get(string)) != null) {
            return fileExtensionElement2.getConverter();
        }
        return null;
    }

    private IHyadesTestNavigatorProvider getProviderFromObject(Object object) {
        return (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object);
    }

    private boolean filter(Object object) {
        Iterator iterator = this.filters.iterator();
        while (iterator.hasNext()) {
            IHyadesTestNavigatorFilter iHyadesTestNavigatorFilter = (IHyadesTestNavigatorFilter)iterator.next();
            if (!iHyadesTestNavigatorFilter.isFiltered(object)) continue;
            return true;
        }
        return false;
    }

    private Object[] filterChildren(Object[] objectArray) {
        if (objectArray == null) {
            return new Object[0];
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            if (!this.filter(objectArray[n])) {
                linkedList.add(objectArray[n]);
            }
            ++n;
        }
        return linkedList.toArray();
    }

    public boolean hasChildren(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            if (!iContainer.exists()) {
                return false;
            }
            IResource[] iResourceArray = null;
            try {
                iResourceArray = iContainer.members();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return false;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                String string;
                if (iResourceArray[n].getType() != 1 ? !this.filter(iResourceArray[n]) : (string = iResourceArray[n].getFileExtension()) != null && this.isVisibleFile((IFile)iResourceArray[n]) && !this.filter(iResourceArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.getProviderFromFile(iFile);
            if (iHyadesTestNavigatorProvider != null) {
                return this.filterChildren(iHyadesTestNavigatorProvider.getChildren(iFile)).length > 0;
            }
        } else {
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object.getClass().getName());
            if (iHyadesTestNavigatorProvider != null) {
                return this.filterChildren(iHyadesTestNavigatorProvider.getChildren(object)).length > 0;
            }
        }
        return false;
    }

    private boolean isVisibleFile(IFile iFile) {
        String string = iFile.getFileExtension();
        if (string != null) {
            return this.visibleElementFromFile.containsKey(string);
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        block13: {
            if (!(object instanceof IContainer)) break block13;
            UniqueEList uniqueEList = new UniqueEList();
            IResource[] iResourceArray = null;
            try {
                iResourceArray = ((IContainer)object).members();
            }
            catch (CoreException coreException) {
                TestUIPlugin.logError(coreException);
                return new Object[0];
            }
            int n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                block15: {
                    Object object2;
                    block17: {
                        block16: {
                            block14: {
                                if (iResourceArray[n].getType() == 1) break block14;
                                if (!this.filter(iResourceArray[n])) {
                                    uniqueEList.add(iResourceArray[n]);
                                }
                                break block15;
                            }
                            if (this.filter(iResourceArray[n])) break block15;
                            object2 = null;
                            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.getProviderFromFile((IFile)iResourceArray[n]);
                            if (iHyadesTestNavigatorProvider == null) break block16;
                            object2 = (IFile)iResourceArray[n];
                            break block17;
                        }
                        IHyadesTestNavigatorConverter iHyadesTestNavigatorConverter = this.getConverterFromFile((IFile)iResourceArray[n]);
                        if (iHyadesTestNavigatorConverter != null && this.filter(object2 = iHyadesTestNavigatorConverter.getObjectFromResource(iResourceArray[n]))) break block15;
                    }
                    if (object2 != null && !this.filter(object2)) {
                        uniqueEList.add(object2);
                    }
                }
                ++n;
            }
            return uniqueEList.toArray();
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = this.getProviderFromFile(iFile);
            if (iHyadesTestNavigatorProvider != null) {
                return this.filterChildren(iHyadesTestNavigatorProvider.getChildren(iFile));
            }
        } else {
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object.getClass().getName());
            if (iHyadesTestNavigatorProvider != null) {
                return this.filterChildren(iHyadesTestNavigatorProvider.getChildren(object));
            }
        }
        return new Object[0];
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TestNavigatorProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
        if (iWorkbenchAdapter == this) {
            return null;
        }
        return iWorkbenchAdapter;
    }

    public Image getImage(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IContainer) {
            ImageDescriptor imageDescriptor;
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor(object)) != null) {
                return imageDescriptor.createImage();
            }
        } else {
            if (object instanceof IFile) {
                return this.getProviderFromFile((IFile)object).getImage(object);
            }
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object.getClass().getName());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getImage(object);
            }
        }
        return null;
    }

    public String getText(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof IContainer) {
            IWorkbenchAdapter iWorkbenchAdapter = this.getWorkbenchAdapter(object);
            if (iWorkbenchAdapter != null) {
                return iWorkbenchAdapter.getLabel(object);
            }
        } else {
            if (object instanceof IFile) {
                return this.getProviderFromFile((IFile)object).getText(object);
            }
            IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider = (IHyadesTestNavigatorProvider)this.visibleElementFromObject.get(object.getClass().getName());
            if (iHyadesTestNavigatorProvider != null) {
                return iHyadesTestNavigatorProvider.getText(object);
            }
        }
        return "";
    }

    public Object[] getElements(Object object) {
        if (object instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)object).getProjects();
        }
        return this.getChildren(object);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.add(iLabelProviderListener);
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        if (!this.listeners.remove(iLabelProviderListener)) {
            TestUIPlugin.logInfo("Unable to remove listener '" + iLabelProviderListener.toString());
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ILabelProviderListener iLabelProviderListener = (ILabelProviderListener)iterator.next();
            iLabelProviderListener.labelProviderChanged(labelProviderChangedEvent);
        }
    }

    public String[] getVisibleFiles() {
        Set set = this.visibleElementFromFile.keySet();
        String[] stringArray = new String[set.size()];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringArray[0] = (String)iterator.next();
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class fileExtensionElement {
        private IHyadesTestNavigatorProvider provider;
        private IHyadesTestNavigatorConverter converter;

        public fileExtensionElement(IHyadesTestNavigatorProvider iHyadesTestNavigatorProvider, IHyadesTestNavigatorConverter iHyadesTestNavigatorConverter) {
            this.provider = iHyadesTestNavigatorProvider;
            this.converter = iHyadesTestNavigatorConverter;
        }

        public IHyadesTestNavigatorConverter getConverter() {
            return this.converter;
        }

        public IHyadesTestNavigatorProvider getProvider() {
            return this.provider;
        }
    }
}

