/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.PartInitException;

public class ArtifactNewWizard
extends HyadesNewWizard {
    private CFGArtifact newArtifact;

    public ArtifactNewWizard() {
        this.setWindowTitle(TestUIPlugin.getString("WIZ_ARTIFACT_TTL"));
        this.setDefaultPageImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("newartifact_wiz.gif"));
        IDialogSettings iDialogSettings = TestUIPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("AritfactNewWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("ArtifactNewWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected String getType() {
        return "org.eclipse.hyades.artifact.generic";
    }

    public String getFileExtension() {
        return "artifact";
    }

    public void addPages() {
        this.getLocationPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
        this.getLocationPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_LOC_DSC"));
        this.addPage((IWizardPage)this.getLocationPage());
        this.getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_TTL"));
        this.getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_ARTIFACT_GEN_PG_ATT_DSC"));
        this.addPage((IWizardPage)this.getAttributeWizardPage());
    }

    protected boolean createObject(IFile iFile) throws Exception {
        Resource resource = this.createResource(iFile);
        resource.getContents().add((Object)this.createEObject());
        EMFUtil.save(resource);
        return true;
    }

    protected EObject createEObject() {
        this.newArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
        this.newArtifact.setName(this.getAttributeWizardPage().getItemName());
        String string = this.getAttributeWizardPage().getItemDescription();
        if (string != null && string.trim().length() > 0) {
            this.newArtifact.setDescription(string);
        }
        return this.newArtifact;
    }

    protected Resource createResource(IFile iFile) {
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString());
        Resource.Factory factory = EMFUtil.getResourceFactory("artifact");
        return factory.createResource(uRI);
    }

    protected void openEditor(IFile iFile) throws PartInitException {
        if (TestUIPlugin.getInstance().getPreferenceStore().getBoolean("openEditor")) {
            UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.ArtifactEditorPart", (boolean)false);
        }
    }

    public CFGArtifact getNewArtifact() {
        return this.newArtifact;
    }
}

