/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

class ReportWizardPage
extends WizardPage
implements Listener {
    private IReportGenerator reportGenerator;
    private IStructuredSelection selection;
    private Table reportTable;
    private Button openEditorCheckBox;

    public ReportWizardPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.selection = iStructuredSelection;
        this.setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL"));
        this.setDescription(TestUIPlugin.getString("wizard.Report.NoDataPoolDefinition.Page"));
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        IPreferenceStore iPreferenceStore = TestUIPlugin.getInstance().getPreferenceStore();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.reportTable = new Table(composite2, 2308);
        this.reportTable.setLayoutData((Object)GridDataUtil.createFill());
        this.openEditorCheckBox = new Button(composite2, 32);
        this.openEditorCheckBox.setText(TestUIPlugin.getString("REPORT_OPEN_EDITOR"));
        this.openEditorCheckBox.setSelection(iPreferenceStore.getBoolean("OpenReportEditor"));
        this.openEditorCheckBox.setSelection(true);
        this.populateReportsTable();
        this.reportTable.addListener(13, (Listener)this);
        if (this.reportTable.getItemCount() > 0) {
            Event event;
            String string = this.getDialogSettings().get("LAST_REPORT");
            if (string != null) {
                event = this.reportTable.getItems();
                int n = 0;
                int n2 = ((TableItem[])event).length;
                while (n < n2) {
                    if (string.equals(event[n].getText())) {
                        this.reportTable.select(n);
                        break;
                    }
                    ++n;
                }
            }
            if (this.reportTable.getSelectionIndex() < 0) {
                this.reportTable.select(0);
            }
            event = new Event();
            event.widget = this.reportTable;
            event.item = this.reportTable.getSelection()[0];
            event.type = 13;
            this.handleEvent(event);
        }
        this.reportTable.setFocus();
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestUIPlugin.getID() + ".rwiz0001"));
        WorkbenchHelp.setHelp((Control)this.openEditorCheckBox, (String)(TestUIPlugin.getID() + ".rwiz0002"));
        WorkbenchHelp.setHelp((Control)this.reportTable, (String)(TestUIPlugin.getID() + ".rwiz0003"));
    }

    public IReportGenerator getReportGenerator() {
        return this.reportGenerator;
    }

    public boolean openEditor() {
        return this.openEditorCheckBox.getSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleEvent(Event var1_1) {
        this.setErrorMessage(null);
        switch (var1_1.type) {
            case 13: {
                var2_2 = this.getReportDescription();
                v0 = var3_3 = var2_2 != null;
                if (!var3_3) ** GOTO lbl21
                try {
                    this.reportGenerator = var2_2.getReportGenerator();
                }
                catch (Exception var4_4) {
                    this.reportGenerator = null;
                    TestUIPlugin.logError(var4_4);
                }
                finally {
                    if (this.reportGenerator == null) {
                        this.setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_"));
                        var3_3 = false;
                    }
                }
                this.setMessage(null);
                ** GOTO lbl22
lbl21:
                // 1 sources

                this.setMessage(TestUIPlugin.getString("NO_REPORT_SEL"));
lbl22:
                // 2 sources

                this.setPageComplete(var3_3);
            }
        }
    }

    public static boolean isInternalWebBrowserAvailable() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IEditorDescriptor[] iEditorDescriptorArray = iWorkbench.getEditorRegistry().getEditors("foo.html");
        int n = 0;
        while (n < iEditorDescriptorArray.length) {
            if ("com.ibm.etools.webbrowser".equals(iEditorDescriptorArray[n].getId())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected ReportDescription getReportDescription() {
        int n = this.reportTable.getSelectionIndex();
        if (n == -1) {
            return null;
        }
        Object object = this.reportTable.getItem(n).getData();
        if (object instanceof ReportDescription) {
            return (ReportDescription)object;
        }
        return null;
    }

    private void populateReportsTable() {
        this.reportTable.removeAll();
        ReportManager reportManager = TestUI.getReportManager();
        IReportDescription[] iReportDescriptionArray = reportManager.getReportDescriptions();
        int n = 0;
        while (n < iReportDescriptionArray.length) {
            ReportDescription reportDescription = (ReportDescription)iReportDescriptionArray[n];
            IReportGenerator iReportGenerator = null;
            try {
                iReportGenerator = reportDescription.getReportGenerator();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iReportGenerator != null && iReportGenerator.isAvailable((ISelection)this.selection)) {
                TableItem tableItem = new TableItem(this.reportTable, 0);
                tableItem.setText(reportDescription.getName());
                tableItem.setData((Object)reportDescription);
                tableItem.setImage(TestUIImages.INSTANCE.getImage("report_obj.gif"));
            }
            ++n;
        }
    }
}

