/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import org.eclipse.hyades.logging.adapter.ICBEGraphInfo;
import org.eclipse.hyades.logging.adapter.MessageGraph;
import org.eclipse.hyades.logging.adapter.impl.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;

public class AdapterGraphLogger
extends Sensor
implements ICBEGraphInfo {
    public static final short OFF_LEVEL = -1;
    public static final short UNKNOWN_LEVEL = 0;
    public static final short INFO_LEVEL = 10;
    public static final short HARMLESS_LEVEL = 20;
    public static final short WARN_LEVEL = 30;
    public static final short MINOR_LEVEL = 40;
    public static final short CRITICAL_LEVEL = 50;
    public static final short FATAL_LEVEL = 60;
    public static final short TRACE_LEVEL = 70;
    public static final short FINE_LEVEL = 72;
    public static final short FINER_LEVEL = 74;
    public static final short FINEST_LEVEL = 76;
    public static final short ALL_LEVEL = 99;
    private int arraySize = 256;
    private MessageGraph[] events = new MessageGraph[this.arraySize];
    private int lastAddedEvent = -1;
    private int lastRemovedEvent = -1;
    private static AdapterGraphLogger instance = null;
    private boolean availableToRead = true;

    public AdapterGraphLogger() {
        instance = this;
    }

    public static synchronized AdapterGraphLogger getInstance() {
        if (instance == null) {
            instance = new AdapterGraphLogger();
        }
        return instance;
    }

    public synchronized Object[] testGetNext() {
        return this.testGetNextEvent();
    }

    public synchronized MessageGraph[] testGetNextEvent() {
        MessageGraph[] messageGraphArray = new MessageGraph[]{new MessageGraph()};
        return messageGraphArray;
    }

    public Object[] getNext() {
        return this.getNextEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageGraph[] getNextEvent() {
        AdapterGraphLogger adapterGraphLogger = this;
        synchronized (adapterGraphLogger) {
            if (this.lastAddedEvent == -1 || this.lastRemovedEvent == this.lastAddedEvent) {
                return null;
            }
            MessageGraph[] messageGraphArray = new MessageGraph[this.lastAddedEvent - this.lastRemovedEvent];
            System.arraycopy(this.events, this.lastRemovedEvent + 1, messageGraphArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
            this.lastRemovedEvent = this.lastAddedEvent;
            return messageGraphArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(ICommonBaseEvent iCommonBaseEvent) {
        AdapterGraphLogger adapterGraphLogger = this;
        synchronized (adapterGraphLogger) {
            MessageGraph messageGraph = new MessageGraph();
            int[] nArray = new int[1];
            DirectedGraphImpl directedGraphImpl = new DirectedGraphImpl();
            nArray[0] = -4;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iCommonBaseEvent.getCreationTime());
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[0] = -5;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(String.valueOf(iCommonBaseEvent.getSeverity()));
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[0] = -7;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iCommonBaseEvent.getMsg());
            messageGraph.addNode(directedGraphImpl);
            nArray = new int[2];
            IComponentIdentification iComponentIdentification = iCommonBaseEvent.getSourceComponentId();
            directedGraphImpl = new DirectedGraphImpl();
            nArray[0] = -16;
            nArray[1] = -30;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iComponentIdentification.getLocation());
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[1] = -31;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iComponentIdentification.getLocationType());
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[1] = -34;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iComponentIdentification.getComponent());
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[1] = -36;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iComponentIdentification.getComponentIdType());
            messageGraph.addNode(directedGraphImpl);
            directedGraphImpl = new DirectedGraphImpl();
            nArray[1] = -35;
            directedGraphImpl.setPath(nArray);
            directedGraphImpl.setValue(iComponentIdentification.getSubComponent());
            messageGraph.addNode(directedGraphImpl);
            if (this.lastAddedEvent + 1 == this.events.length) {
                this.increaseArraySize();
            }
            this.events[++this.lastAddedEvent] = messageGraph;
        }
    }

    private synchronized void increaseArraySize() {
        MessageGraph[] messageGraphArray = new MessageGraph[this.arraySize * 2];
        this.arraySize *= 2;
        this.compressArrayInto(messageGraphArray);
        this.events = messageGraphArray;
    }

    private synchronized void compressArrayInto(MessageGraph[] messageGraphArray) {
        System.arraycopy(this.events, this.lastRemovedEvent + 1, messageGraphArray, 0, this.lastAddedEvent - this.lastRemovedEvent);
        this.lastAddedEvent -= this.lastRemovedEvent;
        this.lastRemovedEvent = -1;
    }
}

