/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;

public class AdapterSensor
extends Sensor {
    public static final short OFF_LEVEL = -1;
    public static final short UNKNOWN_LEVEL = 0;
    public static final short INFO_LEVEL = 10;
    public static final short HARMLESS_LEVEL = 20;
    public static final short WARN_LEVEL = 30;
    public static final short MINOR_LEVEL = 40;
    public static final short CRITICAL_LEVEL = 50;
    public static final short FATAL_LEVEL = 60;
    public static final short TRACE_LEVEL = 70;
    public static final short FINE_LEVEL = 72;
    public static final short FINER_LEVEL = 74;
    public static final short FINEST_LEVEL = 76;
    public static final short ALL_LEVEL = 99;
    private int arraySize = 256;
    private ICommonBaseEvent[] events = new ICommonBaseEvent[this.arraySize];
    private int eventOffset = 0;
    private static AdapterSensor instance = null;

    public AdapterSensor() {
        instance = this;
    }

    public static synchronized AdapterSensor getInstance() {
        if (instance == null) {
            instance = new AdapterSensor();
        }
        return instance;
    }

    public synchronized Object[] testGetNext() {
        return this.testGetNextEvent();
    }

    public synchronized ICommonBaseEvent[] testGetNextEvent() {
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[]{SimpleEventFactoryImpl.getInstance().createCommonBaseEvent()};
        return iCommonBaseEventArray;
    }

    public Object[] flush() {
        return this.getNext();
    }

    public Object[] getNext() {
        return this.getNextEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonBaseEvent[] getNextEvent() {
        if (this.eventOffset == 0) {
            return null;
        }
        AdapterSensor adapterSensor = this;
        synchronized (adapterSensor) {
            ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[this.eventOffset];
            System.arraycopy(this.events, 0, iCommonBaseEventArray, 0, this.eventOffset);
            int n = 0;
            while (n < this.eventOffset) {
                this.events[n] = null;
                ++n;
            }
            this.eventOffset = 0;
            return iCommonBaseEventArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(ICommonBaseEvent iCommonBaseEvent) {
        AdapterSensor adapterSensor = this;
        synchronized (adapterSensor) {
            if (this.eventOffset == this.events.length) {
                ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[this.arraySize * 2];
                this.arraySize *= 2;
                System.arraycopy(this.events, 0, iCommonBaseEventArray, 0, this.eventOffset);
                this.events = iCommonBaseEventArray;
            }
            this.events[this.eventOffset++] = iCommonBaseEvent;
        }
    }
}

