/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.hyades.logging.adapter.util.AdapterMigrationException;
import org.eclipse.hyades.logging.adapter.util.IComponentMigrator;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.adapter.util.OutputterMigrator;
import org.eclipse.hyades.logging.adapter.util.SensorMigrator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdapterMigrator {
    private boolean migrated = false;

    public static void main(String[] stringArray) {
        AdapterMigrator adapterMigrator = new AdapterMigrator();
        if (stringArray != null && stringArray.length >= 1) {
            String string = stringArray[0];
            String string2 = stringArray.length >= 2 ? stringArray[1] : string;
            try {
                adapterMigrator.migrate(string, string2);
                if (!adapterMigrator.isMigrated()) {
                    System.out.println(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_Migration_Required_Information", string));
                }
            }
            catch (AdapterMigrationException adapterMigrationException) {
                System.err.println(adapterMigrationException.getLocalizedMessage());
            }
        } else {
            System.out.println(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_Specified_Error"));
        }
    }

    public boolean migrate(String string) throws AdapterMigrationException {
        return this.migrate(string, string);
    }

    public boolean migrate(String string, String string2) throws AdapterMigrationException {
        Element element;
        Element element2;
        Object object;
        FileInputStream fileInputStream = null;
        String string3 = string;
        this.migrated = false;
        try {
            object = System.getProperty("file.separator");
            if (string3.indexOf(47) != -1 && object != "/") {
                string3 = string3.replace('/', ((String)object).charAt(0));
            }
            if (string3.startsWith("." + (String)object)) {
                string3 = string3.substring(2);
            }
            fileInputStream = new FileInputStream(string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_No_Config_File_Error", string));
        }
        catch (SecurityException securityException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_Error", string));
        }
        object = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object = documentBuilderFactory.newDocumentBuilder().parse(fileInputStream);
        }
        catch (SAXException sAXException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_Error", string), sAXException);
        }
        catch (IOException iOException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_Error", string), iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_Error", string), parserConfigurationException);
        }
        catch (Exception exception) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_Error", string), exception);
        }
        NodeList nodeList = object.getElementsByTagName(Messages.getString("HyadesGASensorTagName"));
        int n = nodeList.getLength();
        IComponentMigrator iComponentMigrator = new SensorMigrator();
        int n2 = 0;
        while (n2 < n) {
            element2 = (Element)nodeList.item(n2);
            element = iComponentMigrator.migrate(element2);
            if (element != null) {
                element2.getParentNode().replaceChild(element, element2);
                this.migrated = true;
            }
            ++n2;
        }
        nodeList = object.getElementsByTagName(Messages.getString("HyadesGAOutputterTagName"));
        n = nodeList.getLength();
        iComponentMigrator = new OutputterMigrator();
        int n3 = 0;
        while (n3 < n) {
            element2 = (Element)nodeList.item(n3);
            element = iComponentMigrator.migrate(element2);
            if (element != null) {
                element2.getParentNode().replaceChild(element, element2);
                this.migrated = true;
            }
            ++n3;
        }
        if (this.isMigrated()) {
            nodeList = object.getElementsByTagName(Messages.getString("HyadesGAAdapterElementTagName"));
            if (nodeList.getLength() == 0) {
                throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Missing_Element_Error", string, Messages.getString("HyadesGAAdapterElementTagName")));
            }
            Element element3 = (Element)nodeList.item(0);
            if (!element3.hasAttribute(Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeTagName"))) {
                element3.setAttribute(Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeTagName"), Messages.getString("HyadesGAAdapterProcessUnitNamespaceAttributeValue"));
            }
            this.saveConfigFile((Document)object, string2);
        }
        return this.isMigrated();
    }

    private void saveConfigFile(Document document, String string) throws AdapterMigrationException {
        String string2 = System.getProperty("os.name", null);
        File file = new File(string);
        OutputFormat outputFormat = new OutputFormat(document);
        if (string2.startsWith("Windows")) {
            outputFormat.setLineSeparator("\r\n");
        } else if (string2.equals("z/OS") || string2.equals("OS/390")) {
            outputFormat.setEncoding("IBM-1047");
        }
        outputFormat.setIndenting(true);
        outputFormat.setLineWidth(0);
        outputFormat.setPreserveSpace(true);
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)new FileWriter(file), outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            throw new AdapterMigrationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Save_Error", string), iOException);
        }
    }

    public boolean isMigrated() {
        return this.migrated;
    }
}

