/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class EnvironmentVariableViewer
implements SelectionListener,
IDisposable {
    private static final String CLASSPATH = "CLASSPATH";
    private static final String[] COLUMNS = new String[]{"STRING", "STRING"};
    private TableViewer tableViewer;
    private Button btnAdd;
    private Button btnRename;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private TPFTestSuite testSuite;
    private CFGArtifact testSuiteArtifact;
    private boolean calculatedClasspath = false;
    private static final int CALC_CP_ABORT = 0;
    private static final int CALC_CP_OVERWRITE = 1;

    public EnvironmentVariableViewer(TPFTest tPFTest) {
        if (tPFTest instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)tPFTest;
        } else if (tPFTest instanceof TPFTestCase) {
            this.testSuite = ((TPFTestCase)tPFTest).getTestSuite();
        }
    }

    public void dispose() {
        this.testSuite = null;
        this.testSuiteArtifact = null;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.createTable(composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestCommonPlugin.getID() + ".envt0001"));
        WorkbenchHelp.setHelp((Control)this.btnAdd, (String)(TestCommonPlugin.getID() + ".envt0002"));
        WorkbenchHelp.setHelp((Control)this.btnDown, (String)(TestCommonPlugin.getID() + ".envt0005"));
        WorkbenchHelp.setHelp((Control)this.btnRemove, (String)(TestCommonPlugin.getID() + ".envt0003"));
        WorkbenchHelp.setHelp((Control)this.btnRename, (String)(TestCommonPlugin.getID() + ".envt0013"));
        WorkbenchHelp.setHelp((Control)this.btnUp, (String)(TestCommonPlugin.getID() + ".envt0004"));
        WorkbenchHelp.setHelp((Control)this.tableViewer.getControl(), (String)(TestCommonPlugin.getID() + ".envt0014"));
    }

    private void createButtons(Composite composite) {
        this.btnAdd = new Button(composite, 8);
        this.btnAdd.setText(TestUIPlugin.getString((String)"label.Add"));
        GridData gridData = GridDataUtil.createHorizontalFill();
        this.btnAdd.setLayoutData((Object)gridData);
        this.btnAdd.setEnabled(false);
        this.btnRename = new Button(composite, 8);
        this.btnRename.setText(TestUIPlugin.getString((String)"label.Update"));
        gridData = GridDataUtil.createHorizontalFill();
        this.btnRename.setLayoutData((Object)gridData);
        this.btnRename.setEnabled(false);
        this.btnRemove = new Button(composite, 8);
        this.btnRemove.setText(TestUIPlugin.getString((String)"label.Remove"));
        gridData = GridDataUtil.createHorizontalFill();
        this.btnRemove.setLayoutData((Object)gridData);
        this.btnRemove.setEnabled(false);
        this.btnUp = new Button(composite, 8);
        this.btnUp.setText(TestUIPlugin.getString((String)"LBL_UP"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.btnUp.setLayoutData((Object)gridData);
        this.btnUp.setEnabled(false);
        this.btnDown = new Button(composite, 8);
        this.btnDown.setText(TestUIPlugin.getString((String)"LBL_DOWN"));
        gridData = GridDataUtil.createHorizontalFill();
        gridData.verticalAlignment = 8;
        this.btnDown.setLayoutData((Object)gridData);
        this.btnDown.setEnabled(false);
    }

    private Control createTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.createTableViewer(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData = new GridData(1040);
        composite3.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.createButtons(composite3);
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnRename.addSelectionListener((SelectionListener)this);
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnUp.addSelectionListener((SelectionListener)this);
        this.btnDown.addSelectionListener((SelectionListener)this);
        return composite2;
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 67588);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = GridDataUtil.createFill();
        table.setLayoutData((Object)gridData);
        table.computeSize(-1, -1);
        TableLayout tableLayout = new TableLayout();
        CellEditor[] cellEditorArray = new CellEditor[COLUMNS.length];
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(TestUIPlugin.getString((String)"ENV_NAME"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(TestUIPlugin.getString((String)"ENV_VALUE"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(230));
        cellEditorArray[1] = new TextCellEditor((Composite)table);
        table.setLayout((Layout)tableLayout);
        this.tableViewer.setColumnProperties(COLUMNS);
        this.tableViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        this.tableViewer.getTable().addSelectionListener((SelectionListener)this);
    }

    public boolean isCalculatedClasspath() {
        return this.calculatedClasspath;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.widgetSelected(selectionEvent);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        CFGPropertyGroup cFGPropertyGroup = (CFGPropertyGroup)this.testSuiteArtifact.getPropertyGroups().get(0);
        EList eList = cFGPropertyGroup.getProperties();
        if (selectionEvent.widget == this.btnAdd) {
            EnvironmentDialog environmentDialog = new EnvironmentDialog(this.btnAdd.getShell(), null);
            if (environmentDialog.open() == 0) {
                BVRProperty bVRProperty = environmentDialog.getEnvironmentElement();
                CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
                cFGComparableProperty.setName(bVRProperty.getName());
                cFGComparableProperty.setValue(bVRProperty.getValue());
                cFGComparableProperty.setDescription(bVRProperty.getDescription());
                eList.add((Object)cFGComparableProperty);
                this.tableViewer.add((Object)bVRProperty);
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)bVRProperty));
                this.calculatedClasspath = false;
            }
        } else if (selectionEvent.widget == this.btnRemove) {
            int n2 = this.tableViewer.getTable().getSelectionIndex();
            if (n2 >= 0 && eList.remove(n2) != null) {
                this.tableViewer.getTable().remove(n2);
                int n3 = n2 = n2 < eList.size() ? n2 : eList.size() - 1;
                if (n2 >= 0) {
                    this.tableViewer.getTable().select(n2);
                }
                this.calculatedClasspath = false;
            }
        } else if (selectionEvent.widget == this.btnRename) {
            Object object;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
            if (iStructuredSelection.size() > 0 && (object = iStructuredSelection.getFirstElement()) instanceof BVRProperty) {
                EnvironmentDialog environmentDialog = new EnvironmentDialog(this.btnRename.getShell(), (BVRProperty)object);
                environmentDialog.open();
                if (environmentDialog.getReturnCode() == 0) {
                    this.tableViewer.update(object, null);
                }
                this.calculatedClasspath = false;
            }
        } else if (selectionEvent.widget == this.btnUp) {
            int n4 = this.tableViewer.getTable().getSelectionIndex();
            if (n4 > 0) {
                CoreUtil.swap((List)eList, (int)n4, (int)(n4 - 1));
                this.tableViewer.refresh();
                this.tableViewer.getTable().select(n4 - 1);
                this.calculatedClasspath = false;
            }
        } else if (selectionEvent.widget == this.btnDown && (n = this.tableViewer.getTable().getSelectionIndex()) < eList.size() - 1) {
            CoreUtil.swap((List)eList, (int)n, (int)(n + 1));
            this.tableViewer.refresh();
            this.tableViewer.getTable().select(n + 1);
            this.calculatedClasspath = false;
        }
        this.btnAdd.setEnabled(this.testSuiteArtifact != null);
        boolean bl = this.testSuiteArtifact != null && !this.tableViewer.getSelection().isEmpty();
        this.btnRemove.setEnabled(bl);
        this.btnRename.setEnabled(bl);
        this.btnUp.setEnabled(bl && this.tableViewer.getTable().getSelectionIndex() > 0);
        this.btnDown.setEnabled(bl && this.tableViewer.getTable().getSelectionIndex() < eList.size() - 1);
    }

    public void setInput(TPFDeployment tPFDeployment) {
        if (this.calculatedClasspath && this.testSuiteArtifact != null) {
            CFGPropertyGroup cFGPropertyGroup = (CFGPropertyGroup)this.testSuiteArtifact.getPropertyGroups().get(0);
            int n = 0;
            while (n < cFGPropertyGroup.getProperties().size()) {
                cFGPropertyGroup.getProperties().remove(0);
                ++n;
            }
        }
        this.testSuiteArtifact = this.calculateTestSuiteArtifact(tPFDeployment);
        this.calculateClasspath(0);
        this.tableViewer.setInput((Object)this.testSuiteArtifact);
        this.btnAdd.setEnabled(this.testSuiteArtifact != null);
        boolean bl = this.testSuiteArtifact != null && !this.tableViewer.getSelection().isEmpty();
        this.btnDown.setEnabled(bl);
        this.btnRemove.setEnabled(bl);
        this.btnRename.setEnabled(bl);
        this.btnUp.setEnabled(bl);
    }

    public CFGArtifact calculateTestSuiteArtifact(TPFDeployment tPFDeployment) {
        CFGLocation cFGLocation;
        if (tPFDeployment == null) {
            return null;
        }
        if (this.testSuite == null) {
            return null;
        }
        if (this.testSuite.eResource().getResourceSet() != tPFDeployment.eResource().getResourceSet()) {
            return null;
        }
        CFGArtifact cFGArtifact = this.testSuiteArtifact;
        CFGArtifactLocationPair cFGArtifactLocationPair = (CFGArtifactLocationPair)tPFDeployment.getArtifactLocations().get(0);
        if (cFGArtifact != null && cFGArtifactLocationPair != null && cFGArtifactLocationPair.getArtifact().equals(cFGArtifact)) {
            return cFGArtifact;
        }
        cFGArtifact = null;
        if (cFGArtifactLocationPair == null) {
            cFGArtifactLocationPair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
        }
        if (cFGArtifactLocationPair.getArtifact() == null) {
            cFGArtifact = (CFGArtifact)tPFDeployment.getArtifacts().get(0);
            if (cFGArtifact == null) {
                cFGArtifact = Common_ConfigurationFactory.eINSTANCE.createCFGArtifact();
                cFGLocation = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
                cFGArtifact.getPropertyGroups().add((Object)cFGLocation);
                tPFDeployment.getArtifacts().add((Object)cFGArtifact);
            }
            cFGArtifactLocationPair.setArtifact(cFGArtifact);
        } else {
            cFGArtifact = cFGArtifactLocationPair.getArtifact();
        }
        if (cFGArtifactLocationPair.getLocation() == null) {
            cFGLocation = (CFGLocation)tPFDeployment.getRefLocations().get(0);
            if (cFGLocation == null) {
                cFGLocation = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
                ((CFGMachineConstraint)cFGLocation).setHostname("localhost");
                tPFDeployment.getRefLocations().add((Object)cFGLocation);
            }
            cFGArtifactLocationPair.setLocation(cFGLocation);
        }
        cFGLocation = null;
        if (this.testSuite.getInstances().size() == 0) {
            cFGLocation = Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
            this.testSuite.getInstances().add((Object)cFGLocation);
        } else {
            boolean bl = false;
            int n = 0;
            while (n < this.testSuite.getInstances().size()) {
                cFGLocation = (CFGInstance)this.testSuite.getInstances().get(n);
                if (cFGArtifact.getInstances().contains((Object)cFGLocation)) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                cFGLocation = Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
                this.testSuite.getInstances().add((Object)cFGLocation);
            }
        }
        cFGArtifact.getInstances().add((Object)cFGLocation);
        this.testSuite.getArtifacts().add((Object)cFGArtifact);
        return cFGArtifact;
    }

    protected void calculateClasspath(int n) {
        if (this.testSuite == null || this.testSuiteArtifact == null) {
            return;
        }
        this.calculatedClasspath = true;
        CFGPropertyGroup cFGPropertyGroup = (CFGPropertyGroup)this.testSuiteArtifact.getPropertyGroups().get(0);
        BVRProperty[] bVRPropertyArray = this.findPropertiesByName((List)cFGPropertyGroup.getProperties(), CLASSPATH, false);
        if (bVRPropertyArray.length > 0) {
            switch (n) {
                case 0: {
                    this.calculatedClasspath = false;
                    return;
                }
                case 1: {
                    this.calculatedClasspath = true;
                    int n2 = 0;
                    int n3 = bVRPropertyArray.length;
                    while (n2 < n3) {
                        cFGPropertyGroup.getProperties().remove((Object)bVRPropertyArray[n2]);
                        ++n2;
                    }
                    break;
                }
            }
        }
        if (this.testSuite.getBehavior() == null || this.testSuite.getBehavior().getLocation() == null) {
            return;
        }
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.testSuite.getBehavior().getLocation());
        if (iResource == null || !iResource.exists()) {
            return;
        }
        String[] stringArray = JavaUtil.getProjectClasspath((IProject)iResource.getProject(), (boolean)false);
        int n4 = 0;
        int n5 = stringArray.length;
        while (n4 < n5) {
            if (this.addClasspathEntry(stringArray[n4])) {
                CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
                cFGComparableProperty.setName(CLASSPATH);
                cFGComparableProperty.setValue(stringArray[n4]);
                cFGPropertyGroup.getProperties().add((Object)cFGComparableProperty);
            }
            ++n4;
        }
    }

    protected boolean addClasspathEntry(String string) {
        if (string.indexOf("junit.jar") > 0) {
            return false;
        }
        if (string.indexOf("xercesImpl.jar") > 0) {
            return false;
        }
        if (string.indexOf("xmlParserAPIs.jar") > 0) {
            return false;
        }
        if (string.indexOf("hexr.jar") > 0) {
            return false;
        }
        if (string.indexOf("hexcore.jar") > 0) {
            return false;
        }
        if (string.indexOf("common.runner.jar") > 0) {
            return false;
        }
        if (string.indexOf("java.runner.jar") > 0) {
            return false;
        }
        if (string.indexOf("http.runner.jar") > 0) {
            return false;
        }
        return string.indexOf("manual.runner.jar") <= 0;
    }

    protected BVRProperty[] findPropertiesByName(List list, String string, boolean bl) {
        if (list != null && !list.isEmpty() && string != null) {
            ArrayList<BVRProperty> arrayList = new ArrayList<BVRProperty>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BVRProperty bVRProperty = (BVRProperty)iterator.next();
                if (bl) {
                    if (!string.equals(bVRProperty.getName())) continue;
                    arrayList.add(bVRProperty);
                    continue;
                }
                if (!string.equalsIgnoreCase(bVRProperty.getName())) continue;
                arrayList.add(bVRProperty);
            }
            return arrayList.toArray(new BVRProperty[arrayList.size()]);
        }
        return new BVRProperty[0];
    }

    private static class EnvironmentUI
    implements SelectionListener,
    ModifyListener {
        private Text _name;
        private Text _classpath;
        private Text _description;
        private Button _browseClass;
        private Button _browseDirPath;
        private Button _browseJarPath;
        private Shell shell;
        private Listener _listener;

        public EnvironmentUI(Shell shell) {
            this.shell = shell;
        }

        public Composite createArgumentsControl(Composite composite) {
            Label label = new Label(composite, 0);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 1;
            label.setText(TestUIPlugin.getString((String)"ENV_VALUE"));
            label.setLayoutData((Object)gridData);
            this._classpath = new Text(composite, 2882);
            gridData = GridDataUtil.createFill();
            gridData.heightHint = 100;
            gridData.widthHint = 250;
            this._classpath.setLayoutData((Object)gridData);
            Composite composite2 = new Composite(composite, 0);
            gridData = GridDataUtil.createVerticalFill();
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            composite2.setLayoutData((Object)gridData);
            composite2.setLayout((Layout)gridLayout);
            this._browseDirPath = new Button(composite2, 0x1000008);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this._browseDirPath.setLayoutData((Object)gridData);
            this._browseDirPath.setText(TestUIPlugin.getString((String)"ADD_DIRECTORY"));
            this._browseJarPath = new Button(composite2, 0x1000008);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 2;
            this._browseJarPath.setLayoutData((Object)gridData);
            this._browseJarPath.setText(TestUIPlugin.getString((String)"ADD_JAR"));
            this._browseDirPath.addSelectionListener((SelectionListener)this);
            this._browseJarPath.addSelectionListener((SelectionListener)this);
            WorkbenchHelp.setHelp((Control)this._classpath, (String)(TestCommonPlugin.getID() + ".envt0011"));
            WorkbenchHelp.setHelp((Control)this._browseDirPath, (String)(TestCommonPlugin.getID() + ".envt0008"));
            WorkbenchHelp.setHelp((Control)this._browseJarPath, (String)(TestCommonPlugin.getID() + ".envt0009"));
            return composite;
        }

        public Composite createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 5;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = GridDataUtil.createFill();
            gridData.horizontalIndent = 5;
            composite2.setLayoutData((Object)gridData);
            Label label = new Label(composite2, 0);
            label.setText(TestUIPlugin.getString((String)"ENV_NAME"));
            this._name = new Text(composite2, 2052);
            gridData = GridDataUtil.createHorizontalFill();
            gridData.horizontalSpan = 2;
            this._name.setLayoutData((Object)gridData);
            this._name.setFocus();
            this._name.selectAll();
            this._name.addModifyListener((ModifyListener)this);
            this.createArgumentsControl(composite2);
            this._classpath.addModifyListener((ModifyListener)this);
            label = new Label(composite2, 0);
            label.setText(TestUIPlugin.getString((String)"ENV_DESCRIPTION"));
            gridData = new GridData();
            gridData.verticalAlignment = 1;
            label.setLayoutData((Object)gridData);
            this._description = new Text(composite2, 2882);
            gridData = GridDataUtil.createHorizontalFill();
            gridData.heightHint = 100;
            this._description.setLayoutData((Object)gridData);
            WorkbenchHelp.setHelp((Control)this._description, (String)(TestCommonPlugin.getID() + ".envt0012"));
            WorkbenchHelp.setHelp((Control)this._name, (String)(TestCommonPlugin.getID() + ".envt0010"));
            return composite2;
        }

        public String getValue() {
            return this._classpath.getText().trim();
        }

        public Control getBrowseJarButton() {
            return this._browseJarPath;
        }

        public Control getBrowseDirButton() {
            return this._browseDirPath;
        }

        public String getName() {
            return this._name.getText().trim();
        }

        public String getDescription() {
            return this._description.getText().trim();
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = System.getProperty("os.name");
            if (selectionEvent.widget == this._browseClass) {
                FileDialog fileDialog = new FileDialog(this.shell);
                fileDialog.setFilterExtensions(new String[]{"*.class"});
                fileDialog.open();
                String string2 = fileDialog.getFileName();
                if (string2 != null && !string2.equals("")) {
                    String string3;
                    if (string2.endsWith(".class")) {
                        string2 = string2.substring(0, string2.length() - 6);
                    }
                    String string4 = fileDialog.getFilterPath();
                    if (string != null && string.startsWith("Windows") && string4.endsWith(":")) {
                        string4 = string4 + "\\";
                    }
                    string3 = (string3 = this._classpath.getText().trim()).equals("") || string3.endsWith(File.pathSeparator) ? string3 : string3 + File.pathSeparator;
                    this._classpath.setText(string3 + string4);
                }
            } else if (selectionEvent.widget == this._browseDirPath) {
                DirectoryDialog directoryDialog = new DirectoryDialog(this.shell);
                String string5 = directoryDialog.open();
                if (string5 != null && !string5.equals("")) {
                    String string6;
                    if (string != null && string.startsWith("Windows") && string5.endsWith(":")) {
                        string5 = string5 + "\\";
                    }
                    string6 = (string6 = this._classpath.getText().trim()).equals("") || string6.endsWith(File.pathSeparator) ? string6 : string6 + File.pathSeparator;
                    string5 = string6 + string5;
                    this._classpath.setText(string5);
                    this._classpath.setFocus();
                }
            } else if (selectionEvent.widget == this._browseJarPath) {
                FileDialog fileDialog = new FileDialog(this.shell);
                fileDialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
                fileDialog.open();
                String string7 = fileDialog.getFileName();
                if (string7 != null && !string7.equals("")) {
                    string7 = fileDialog.getFilterPath() + File.separator + string7;
                    String string8 = this._classpath.getText().trim();
                    string8 = string8.equals("") || string8.endsWith(File.pathSeparator) ? string8 : string8 + File.pathSeparator;
                    string7 = string8 + string7;
                    this._classpath.setText(string7);
                }
            }
        }

        public void modifyText(ModifyEvent modifyEvent) {
            this.notifyListener();
        }

        public void setValue(String string) {
            if (string != null) {
                this._classpath.setText(string);
            } else {
                this._classpath.setText("");
            }
        }

        public void setName(String string) {
            if (string != null) {
                this._name.setText(string);
            } else {
                this._name.setText("");
            }
        }

        public void setDescription(String string) {
            if (string != null) {
                this._description.setText(string);
            } else {
                this._description.setText("");
            }
        }

        public void registerListener(Listener listener) {
            this._listener = listener;
        }

        public void notifyListener() {
            if (this._listener != null) {
                this._listener.handleEvent(null);
            }
        }
    }

    public static class EnvironmentDialog
    extends Dialog
    implements Listener {
        private BVRProperty element;
        private EnvironmentUI environmentUI;

        public EnvironmentDialog(Shell shell, BVRProperty bVRProperty) {
            super(shell);
            this.element = bVRProperty;
        }

        protected Control createDialogArea(Composite composite) {
            if (this.element == null) {
                this.getShell().setText(TestUIPlugin.getString((String)"ADD_ENV_DESC_DLG"));
            } else {
                this.getShell().setText(TestUIPlugin.getString((String)"EDIT_ENV_DESC_DLG"));
            }
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)GridDataUtil.createFill());
            composite2.setLayout((Layout)new GridLayout());
            this.environmentUI = new EnvironmentUI(this.getShell());
            Composite composite3 = this.environmentUI.createControl(composite2);
            if (this.element != null) {
                this.environmentUI.setName(this.element.getName());
                this.environmentUI.setValue(this.element.getValue());
                this.environmentUI.setDescription(this.element.getDescription());
            }
            WorkbenchHelp.setHelp((Control)composite3, (String)(TestCommonPlugin.getID() + ".envt0006"));
            return composite3;
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.environmentUI.registerListener(this);
            if (this.element == null) {
                this.getButton(0).setEnabled(false);
            }
            return control;
        }

        protected void okPressed() {
            if (this.element == null) {
                this.element = Common_Behavior_InteractionsFactory.eINSTANCE.createBVRProperty();
            }
            this.element.setName(this.environmentUI.getName());
            this.element.setValue(this.environmentUI.getValue());
            this.element.setDescription(this.environmentUI.getDescription());
            super.okPressed();
        }

        public BVRProperty getEnvironmentElement() {
            return this.element;
        }

        public void handleEvent(Event event) {
            this.getButton(0).setEnabled(!this.environmentUI.getName().equals("") && !this.environmentUI.getValue().equals(""));
        }
    }

    private static class PreferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferenceLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof BVRProperty) {
                BVRProperty bVRProperty = (BVRProperty)object;
                if (n == 0) {
                    return bVRProperty.getName();
                }
                if (n == 1) {
                    return bVRProperty.getValue();
                }
            }
            return "";
        }
    }

    private static class PreferenceContentProvider
    implements IStructuredContentProvider {
        private PreferenceContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof CFGArtifact) {
                CFGPropertyGroup cFGPropertyGroup = (CFGPropertyGroup)((CFGArtifact)object).getPropertyGroups().get(0);
                return cFGPropertyGroup.getProperties().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

