/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogContentProvider
implements ITreeContentProvider,
IDisposable {
    public static final String SD_FILE_EXTENSION = "trcdbxmi";
    private TreeViewer treeViewer;
    private LogicalFolder logFolder;
    private LogicalFolder sdFolder;
    private LogicalFolder corrFolder;
    private boolean filesLoaded = false;
    private LogNavigator navigator;

    public LogContentProvider() {
    }

    public LogContentProvider(LogNavigator logNavigator) {
        this.navigator = logNavigator;
    }

    public void dispose() {
        if (this.logFolder != null) {
            this.logFolder.dispose();
        }
        if (this.sdFolder != null) {
            this.sdFolder.dispose();
        }
        this.treeViewer = null;
    }

    public ResourceSet getResourceSet() {
        return HierarchyResourceSetImpl.getInstance();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void loadFiles() {
        String[] stringArray = new String[]{SD_FILE_EXTENSION, "trcmxmi"};
        Map map = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])stringArray, null);
        this.getSDFolder().getChildren().addAll((List)map.get(SD_FILE_EXTENSION));
        EObject[] eObjectArray = EMFUtil.loadMonitorsFromResourceSet(this.getResourceSet());
        this.loadIntoFolders(eObjectArray);
        Iterator iterator = ((List)map.get("trcmxmi")).iterator();
        while (iterator.hasNext()) {
            EObject[] eObjectArray2 = EMFUtil.load(this.getResourceSet(), (IFile)iterator.next());
            this.loadIntoFolders(eObjectArray2);
        }
        this.filesLoaded = true;
    }

    private void loadIntoFolders(EObject[] eObjectArray) {
        int n = 0;
        int n2 = eObjectArray.length;
        while (n < n2) {
            if (eObjectArray[n] instanceof TRCMonitor) {
                this.getCorrelationFolder().getChildren().addAll(((TRCMonitor)eObjectArray[n]).getCorrelationContainerProxies());
                Iterator iterator = ((TRCMonitor)eObjectArray[n]).getNodes().iterator();
                while (iterator.hasNext()) {
                    TRCNode tRCNode = (TRCNode)iterator.next();
                    this.getLogFolder().getChildren().add(tRCNode);
                }
            }
            ++n;
        }
    }

    public void refreshFromLocal() {
        this.filesLoaded = false;
        this.clearFolders();
        this.getTreeViewer().refresh();
    }

    public LogicalFolder getLogFolder() {
        if (this.logFolder == null) {
            this.logFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_LOGFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.logFolder;
    }

    public LogicalFolder getSDFolder() {
        if (this.sdFolder == null) {
            this.sdFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_SDFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.sdFolder;
    }

    public LogicalFolder getCorrelationFolder() {
        if (this.corrFolder == null) {
            this.corrFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_CORRFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.corrFolder;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearFolders();
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Object getParent(Object object) {
        if (object instanceof TRCAgentProxy) {
            return this.getLogFolder();
        }
        if (object instanceof CorrelationContainerProxy) {
            return this.getCorrelationFolder();
        }
        if (object instanceof IFile && SD_FILE_EXTENSION.equals(((IFile)object).getFileExtension())) {
            return this.getSDFolder();
        }
        if (object instanceof LogicalFolder) {
            return ((LogicalFolder)object).getParent();
        }
        return null;
    }

    public Object[] getElements(Object object) {
        ArrayList<LogicalFolder> arrayList = new ArrayList<LogicalFolder>();
        arrayList.add(this.getLogFolder());
        arrayList.add(this.getSDFolder());
        arrayList.add(this.getCorrelationFolder());
        arrayList.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)this.navigator.getID()));
        return arrayList.toArray();
    }

    public boolean hasChildren(Object object) {
        if (NavigatorExtensionUtil.hasChildren((Object)object, (String)this.navigator.getID())) {
            return true;
        }
        if (object instanceof LogicalFolder) {
            if (!this.filesLoaded) {
                this.loadFiles();
            }
            return !((LogicalFolder)object).getChildren().isEmpty();
        }
        if (object instanceof CorrelationContainerProxy) {
            return ((CorrelationContainerProxy)object).getCorrelatedAgents().size() > 0;
        }
        if (object instanceof TRCNode) {
            return EMFUtil.getLogAgentsFromNode((TRCNode)object).size() > 0;
        }
        return false;
    }

    public Object[] getChildren(Object object) {
        ArrayList arrayList = new ArrayList();
        if (object == this.getLogFolder()) {
            this.getLogFolder().getChildren().clear();
            this.getLogFolder().getChildren().addAll(this.getNodesFromResourceSet());
            arrayList.addAll(this.getLogFolder().getChildren());
        } else if (object instanceof LogicalFolder) {
            arrayList.addAll(((LogicalFolder)object).getChildren());
        } else if (object instanceof CorrelationContainerProxy) {
            arrayList.addAll(((CorrelationContainerProxy)object).getCorrelatedAgents());
        }
        if (object instanceof TRCNode) {
            arrayList.addAll(EMFUtil.getLogAgentsFromNode((TRCNode)object));
        }
        arrayList.addAll(NavigatorExtensionUtil.getAllChildren((Object)object, (String)this.navigator.getID()));
        return arrayList.toArray();
    }

    private void clearFolders() {
        if (this.logFolder != null) {
            this.logFolder.getChildren().clear();
        }
        if (this.sdFolder != null) {
            this.sdFolder.getChildren().clear();
        }
        if (this.corrFolder != null) {
            this.corrFolder.getChildren().clear();
        }
    }

    private List getNodesFromResourceSet() {
        EList eList = this.getResourceSet().getResources();
        int n = eList.size();
        ArrayList<TRCNode> arrayList = new ArrayList<TRCNode>();
        int n2 = 0;
        while (n2 < n) {
            Resource resource = (Resource)eList.get(n2);
            EList eList2 = resource.getContents();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TRCMonitor)) continue;
                Iterator iterator2 = ((TRCMonitor)e).getNodes().iterator();
                while (iterator2.hasNext()) {
                    TRCNode tRCNode = (TRCNode)iterator2.next();
                    if (EMFUtil.getLogAgentsFromNode(tRCNode).size() <= 0 || arrayList.contains(tRCNode)) continue;
                    arrayList.add(tRCNode);
                }
            }
            ++n2;
        }
        return arrayList;
    }
}

