/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.actions.provider.ILogFilterProvider;
import org.eclipse.hyades.log.ui.internal.actions.provider.LogFilterCriteria;
import org.eclipse.hyades.log.ui.internal.util.CBEAdvFilterUI;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.FilterOptionsUI;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class FiltersDialog
extends Dialog {
    private CBEAdvFilterUI _filters;
    private FilterOptionsUI _options;
    private static final int _restoreDefaultsButtonId = 1025;
    private Composite optionsComposite;
    private boolean showOptions = false;
    private ILogFilterProvider logFilterProvider = null;
    private LogFilterCriteria criteria = null;
    private String _title;

    public FiltersDialog(Shell shell, String string, Image image, ILogFilterProvider iLogFilterProvider, boolean bl) {
        super(shell);
        this._title = string;
        Window.setDefaultImage((Image)image);
        this.logFilterProvider = iLogFilterProvider;
        this.showOptions = bl;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 500;
        composite2.setLayoutData((Object)gridData);
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        this._filters = new CBEAdvFilterUI();
        this._filters.createControl(composite2);
        this._filters.initializeValues(false);
        this._options = new FilterOptionsUI();
        this.optionsComposite = this._options.createControl(composite2);
        this.initializeOptionsComposite();
        WorkbenchHelp.setHelp((Control)composite2, (String)ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
        return composite2;
    }

    private void initializeOptionsComposite() {
        this.optionsComposite.setVisible(this.showOptions);
        if (this.showOptions) {
            this._options.initializeValues(false);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1025, LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"), false);
        super.createButtonsForButtonBar(composite);
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            this._filters.initializeValues(true);
            this._options.initializeValues(true);
        } else {
            super.buttonPressed(n);
        }
    }

    protected void okPressed() {
        this._filters.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
        if (this.showOptions) {
            this._options.storeValues();
        }
        this.criteria = new LogFilterCriteria();
        this.criteria.setFilters(this._filters.getFilterList().getFilters());
        this.criteria.setShowCorrelationOnly(this._options.getShowCorrelationButton().getSelection());
        if (this.logFilterProvider != null) {
            this.logFilterProvider.filterRecord(this.criteria);
        }
        super.okPressed();
    }
}

