/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;

public class Splitter
extends Composite {
    protected SplitterLayout fLayout;
    protected int fDirection;
    protected int fGap = 3;
    protected boolean fResizable;

    public Splitter(Composite composite, int n, boolean bl) {
        super(composite, 0);
        this.fDirection = n;
        this.fResizable = bl;
        this.fLayout = new SplitterLayout();
        this.setLayout(this.fLayout);
    }

    public Sash addSash() {
        final Sash sash = new Sash((Composite)this, this.fDirection == 256 ? 512 : 256);
        if (this.fResizable) {
            sash.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Splitter.this.dragSash(sash, event);
                }
            });
        }
        return sash;
    }

    void dragSash(Sash sash, Event event) {
        Control control;
        Rectangle rectangle = this.getClientArea();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        if (event.detail == 1) {
            int n2 = 20;
            if (this.fDirection == 256) {
                event.x = Math.min(Math.max(n2, event.x), rectangle.width - n2);
            } else {
                event.y = Math.min(Math.max(n2, event.y), rectangle.height - n2);
            }
            return;
        }
        Rectangle rectangle2 = event.getBounds();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            control = controlArray[n4];
            if (control == sash) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        control = controlArray[n3 - 1];
        Rectangle rectangle3 = control.getBounds();
        Rectangle rectangle4 = sash.getBounds();
        Control control2 = controlArray[n3 + 1];
        Rectangle rectangle5 = control2.getBounds();
        if (this.fDirection == 256) {
            int n5 = rectangle2.x - rectangle4.x;
            rectangle3.width += n5;
            rectangle5.x += n5;
            rectangle5.width -= n5;
            if (rectangle3.width < 20 || rectangle5.width < 20) {
                return;
            }
        } else {
            int n6 = rectangle2.y - rectangle4.y;
            rectangle3.height += n6;
            rectangle5.y += n6;
            rectangle5.height -= n6;
            if (rectangle3.height < 20 || rectangle5.height < 20) {
                return;
            }
        }
        control.setBounds(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        sash.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        control2.setBounds(rectangle5.x, rectangle5.y, rectangle5.width, rectangle5.height);
    }

    public void flipDirection() {
        this.fDirection = this.fDirection == 256 ? 512 : 256;
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Sash sash;
            Control control = controlArray[n];
            if (control instanceof Sash) {
                sash = this.addSash();
                sash.moveAbove(control);
                control.dispose();
            } else {
                sash = control.getSize();
                control.setSize(sash.y, sash.x);
            }
            ++n;
        }
    }

    public Point[] getSizes() {
        Control[] controlArray = this.getChildren();
        Point[] pointArray = new Point[controlArray.length];
        int n = 0;
        while (n < controlArray.length) {
            pointArray[n] = controlArray[n].getSize();
            ++n;
        }
        return pointArray;
    }

    Weight getWeight(Control control) {
        Object object = control.getLayoutData();
        if (object instanceof Weight) {
            return (Weight)object;
        }
        Weight weight = null;
        if (control instanceof Sash) {
            Point point = control.computeSize(-1, -1, true);
            int n = this.fDirection == 256 ? point.x : point.y;
            weight = new Weight(n, 0);
        } else {
            weight = object instanceof Integer ? new Weight((Integer)object) : new Weight(50);
        }
        control.setLayoutData((Object)weight);
        return weight;
    }

    int getWindowSize(Control control, boolean bl) {
        int n;
        Point point = control.getSize();
        int n2 = n = this.fDirection == 256 ? point.x : point.y;
        if (n == 0) {
            n = this.getWeight((Control)control).fSize;
        }
        return n;
    }

    void internalMaximize(Control control) {
        Layout layout = this.getLayout();
        boolean bl = layout instanceof MaximizeLayout;
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] != control) {
                controlArray[n].setVisible(bl);
            }
            ++n;
        }
        if (bl) {
            control.setSize(((MaximizeLayout)layout).fOldSize);
            this.setLayout(this.fLayout);
        } else {
            this.setLayout(new MaximizeLayout(control));
        }
        control = this.getParent();
        if (control instanceof Splitter) {
            ((Splitter)control).internalMaximize((Control)this);
        } else {
            this.layout(true);
        }
    }

    boolean isFixed(Control control) {
        if (control instanceof Sash) {
            return true;
        }
        return this.getWeight((Control)control).fGrow <= 0;
    }

    public void maximize(Control control) {
        this.setRedraw(false);
        this.internalMaximize(control);
        this.setRedraw(true);
    }

    public void setSizes(Point[] pointArray) {
        this.setRedraw(false);
        Control[] controlArray = this.getChildren();
        int n = 0;
        while (n < pointArray.length) {
            controlArray[n].setSize(pointArray[n]);
            ++n;
        }
        this.layout(true);
        this.setRedraw(true);
    }

    public class SplitterLayout
    extends Layout {
        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            int n3 = 0;
            int n4 = 0;
            if (Splitter.this.fDirection == 256) {
                int n5 = 0;
                while (n5 < controlArray.length) {
                    Point point = controlArray[n5].computeSize(-1, -1, bl);
                    n4 += point.x;
                    n3 = Math.max(n3, point.y);
                    ++n5;
                }
                return new Point(n4, n3);
            }
            int n6 = 0;
            while (n6 < controlArray.length) {
                Point point = controlArray[n6].computeSize(-1, -1, bl);
                n4 += point.y;
                n3 = Math.max(n3, point.x);
                ++n6;
            }
            return new Point(n3, n4);
        }

        protected void layout(Composite composite, boolean bl) {
            int n;
            int n2;
            Rectangle rectangle = composite.getClientArea();
            Control[] controlArray = composite.getChildren();
            int n3 = controlArray.length;
            int n4 = Splitter.this.fDirection == 256 ? rectangle.width : rectangle.height;
            int n5 = 0;
            int[] nArray = new int[n3];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                n2 = Splitter.this.getWindowSize(controlArray[n8], bl);
                n5 += n2;
                nArray[n8] = n2;
                Weight weight = Splitter.this.getWeight(controlArray[n8]);
                n6 += weight.fGrow;
                n7 += weight.fShrink;
                ++n8;
            }
            n2 = n4 - n5;
            boolean bl2 = true;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                Weight weight = Splitter.this.getWeight(controlArray[n10]);
                if (n2 > 0) {
                    if (weight.fGrow > 0) {
                        n = n2 * weight.fGrow / n6;
                        int n11 = n10;
                        nArray[n11] = nArray[n11] + n;
                        bl2 = false;
                    }
                } else if (weight.fShrink > 0) {
                    n = n2 * weight.fShrink / n7;
                    int n12 = n10;
                    nArray[n12] = nArray[n12] + n;
                    bl2 = false;
                }
                n9 += nArray[n10];
                ++n10;
            }
            if (!bl2) {
                int n13 = 0;
                while (n9 < n4) {
                    if (!Splitter.this.isFixed(controlArray[n13 % n3])) {
                        int n14 = n13 % n3;
                        nArray[n14] = nArray[n14] + 1;
                        ++n9;
                    }
                    ++n13;
                }
            }
            if (Splitter.this.fDirection == 256) {
                int n15 = rectangle.x;
                n = 0;
                while (n < n3) {
                    controlArray[n].setBounds(n15, rectangle.y, nArray[n], rectangle.height);
                    n15 += nArray[n];
                    ++n;
                }
            } else {
                int n16 = rectangle.y;
                n = 0;
                while (n < n3) {
                    controlArray[n].setBounds(rectangle.x, n16, rectangle.width, nArray[n]);
                    n16 += nArray[n];
                    ++n;
                }
            }
        }
    }

    public static class MaximizeLayout
    extends Layout {
        Control fChild;
        Point fOldSize;

        MaximizeLayout(Control control) {
            this.fChild = control;
            this.fOldSize = control.getSize();
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return this.fChild.getSize();
        }

        protected void layout(Composite composite, boolean bl) {
            this.fChild.setBounds(composite.getClientArea());
        }
    }

    public static class Weight {
        public int fSize;
        public int fGrow;
        public int fShrink;

        public Weight(int n) {
            this.fSize = n;
            this.fGrow = 50;
            this.fShrink = 50;
        }

        public Weight(int n, int n2) {
            this.fSize = n;
            this.fGrow = n2;
            this.fShrink = n2;
        }

        public Weight(int n, int n2, int n3) {
            this.fSize = n;
            this.fGrow = n2;
            this.fShrink = n3;
        }
    }
}

