/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.FeatureNode;
import org.eclipse.hyades.log.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.log.ui.internal.util.RecordFilterSearchUtil;
import org.eclipse.hyades.log.ui.internal.util.Sorter;
import org.eclipse.hyades.log.ui.internal.util.TerminalNode;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;

public class LogContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private int _visible = 0;
    private int _total = 0;
    private ViewForm _viewer;
    private String _title = LogUIPlugin.getResourceString("STR_LOG_PANE_TITLE");
    private Sorter sorter;
    private RecordFilterSearchUtil recordFilterSearch = null;
    private int _currentPage = 0;
    private int _totalPages = 0;
    private int PAGE_SIZE = 500;
    private LogViewer _logViewer;
    private List sortAttributes;
    private String filters;
    private ArrayList filterTableElements;
    private int _visible_roots;
    private int _total_roots;
    private List allElements;
    private boolean filterSevOne;
    private boolean filterSevTwo;
    private boolean filterSevThree;
    private boolean pageActionCalled = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent;

    public LogContentProvider(ViewForm viewForm, LogViewer logViewer) {
        this._viewer = viewForm;
        this._logViewer = logViewer;
        this.recordFilterSearch = new RecordFilterSearchUtil();
    }

    public void dispose() {
        this.reset();
        this.recordFilterSearch = null;
        this._viewer = null;
        this._logViewer = null;
    }

    public Object[] getChildren(Object object) {
        return this.getElementsAll(object).toArray();
    }

    public Object[] getElements(Object object) {
        ArrayList arrayList = new ArrayList();
        String string = HierarchyPlugin.getPlugin().getPluginPreferences().getString("VIEW_PAGE_SIZE");
        if (string != null) {
            try {
                this.PAGE_SIZE = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isModelChanged() || this.prepareFiltersAndSortAttributes()) {
            this.allElements = this.getElementsAll(object);
            ((ArrayList)this.allElements).trimToSize();
            this._visible_roots = this._visible;
            this._total_roots = this._total;
            this._totalPages = this._visible / this.PAGE_SIZE;
            this._totalPages = this._visible % this.PAGE_SIZE > 0 && this._visible > 0 ? this._totalPages + 1 : this._totalPages;
            this._currentPage = Math.max(1, this._currentPage);
            this._currentPage = Math.min(this._totalPages, this._currentPage);
            this.setTitle();
            this.updatePageActions();
            if (this._visible < this.PAGE_SIZE || this._visible == 0) {
                return this.allElements.toArray();
            }
            int n = (this._currentPage - 1) * this.PAGE_SIZE;
            int n2 = Math.min(this._currentPage * this.PAGE_SIZE, this._visible);
            int n3 = n;
            while (n3 < n2) {
                Object e = this.allElements.get(n3);
                arrayList.add(e);
                ++n3;
            }
        } else {
            this._visible = this._visible_roots;
            this._total = this._total_roots;
            this._totalPages = this._visible / this.PAGE_SIZE;
            this._totalPages = this._visible % this.PAGE_SIZE > 0 && this._visible > 0 ? this._totalPages + 1 : this._totalPages;
            this._currentPage = Math.max(1, this._currentPage);
            this._currentPage = Math.min(this._totalPages, this._currentPage);
            this.setTitle();
            this.updatePageActions();
            if (this._visible < this.PAGE_SIZE || this._visible == 0) {
                return this.allElements.toArray();
            }
            int n = (this._currentPage - 1) * this.PAGE_SIZE;
            int n4 = Math.min(this._currentPage * this.PAGE_SIZE, this._visible);
            int n5 = n;
            while (n5 < n4) {
                Object e = this.allElements.get(n5);
                arrayList.add(e);
                ++n5;
            }
        }
        return arrayList.toArray();
    }

    private boolean isModelChanged() {
        if (this.allElements == null || this._logViewer.handleRefreshEvent) {
            this.prepareFiltersAndSortAttributes();
            return true;
        }
        return false;
    }

    private void updatePageActions() {
        try {
            this.pageActionCalled = false;
            this._logViewer.getPageUpAction().setEnabled(this._currentPage - 1 > 0);
            this._logViewer.getPageDownAction().setEnabled(this._totalPages - this._currentPage > 0);
            this._logViewer.getGotPageAction().setEnabled(this._totalPages > 1);
        }
        catch (Exception exception) {}
    }

    public List getElementsAll(Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this._visible = 0;
        this._total = 0;
        if (object instanceof TRCMonitor) {
            this.getMonitorRecords((TRCMonitor)object, arrayList2, arrayList);
        }
        if (object instanceof TRCNode) {
            this.getNodeRecords((TRCNode)object, arrayList2, arrayList, false);
        }
        if (object instanceof TRCAgentProxy) {
            this.getAgentRecords((TRCAgentProxy)object, arrayList2, arrayList, false);
        }
        if (object instanceof TRCProcessProxy) {
            this.getProcessRecords((TRCProcessProxy)object, arrayList2, arrayList, false);
        } else if (object instanceof CorrelationContainerProxy) {
            Iterator iterator = ((CorrelationContainerProxy)object).getCorrelatedAgents().iterator();
            while (iterator.hasNext()) {
                TRCAgentProxy tRCAgentProxy = (TRCAgentProxy)iterator.next();
                this.getAgentRecords(tRCAgentProxy, arrayList2, arrayList, true);
            }
            arrayList.addAll(this.getFilteredRecords(arrayList2));
        } else if (object instanceof EObject && ((EObject)object).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            this.getFeatureNodes((EObject)object, arrayList);
        } else if (object instanceof FeatureNode) {
            this.getFeatureNodeElements((FeatureNode)object, arrayList);
        }
        return arrayList;
    }

    public boolean hasChildren(Object object) {
        boolean bl = false;
        if (object instanceof EObject && ((EObject)object).eClass().getEPackage() == CBEPackage.eINSTANCE) {
            EClass eClass = ((EObject)object).eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object2;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if ((!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 3) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (object2 = ((EObject)object).eGet(eStructuralFeature, true)) == null) continue;
                if (object2 instanceof EList) {
                    if (((EList)object2).size() <= 0) continue;
                    bl = true;
                } else {
                    bl = true;
                }
                break;
            }
        } else if (object instanceof FeatureNode) {
            EStructuralFeature eStructuralFeature = ((FeatureNode)object).getFeature();
            EObject eObject = ((FeatureNode)object).getElement();
            if (eStructuralFeature instanceof EReference) {
                Object object3;
                EList eList;
                bl = eStructuralFeature.isMany() ? (eList = (EList)eObject.eGet(eStructuralFeature, true)).size() > 0 : (object3 = eObject.eGet(eStructuralFeature, true)) != null;
            }
        } else if (object instanceof TerminalNode) {
            bl = false;
        }
        return bl;
    }

    public Object getParent(Object object) {
        return null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.reset();
    }

    private void reset() {
        this.filters = null;
        this.sortAttributes = null;
        this.filterTableElements = null;
        this.allElements = null;
        this._currentPage = 0;
        this._totalPages = 0;
        this.pageActionCalled = false;
    }

    public boolean isDeleted(Object object) {
        return false;
    }

    private void updateSeverity() {
        if (this.filters == null) {
            return;
        }
        this.filterSevOne = true;
        this.filterSevTwo = true;
        this.filterSevThree = true;
        int n = this.filters.indexOf(32);
        if (n == -1) {
            return;
        }
        this.filterSevOne = this.filters.charAt(n - 1) == '1';
        if ((n = this.filters.indexOf(32, n + 1)) == -1) {
            return;
        }
        this.filterSevTwo = this.filters.charAt(n - 1) == '1';
        if ((n = this.filters.indexOf(32, n + 1)) == -1) {
            return;
        }
        this.filterSevThree = this.filters.charAt(n - 1) == '1';
    }

    private ArrayList getFilteredRecords(List list) {
        if (this.sortAttributes != null && this.sortAttributes.size() > 0) {
            Collections.sort(list, this.getLogSorter(this.sortAttributes));
        }
        ArrayList arrayList = new ArrayList();
        if ((this.filters == null || this.filters.equals("")) && this.filterTableElements == null) {
            int n = 0;
            while (n < list.size()) {
                arrayList.add(list.get(n));
                ++n;
            }
            this._total += list.size();
            this._visible += list.size();
            return arrayList;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            try {
                short s = ((CBECommonBaseEvent)e).getSeverity();
                if ((s >= 50 && s <= 70 && this.filterSevOne || s >= 30 && s < 50 && this.filterSevTwo || s >= 0 && s < 30 && this.filterSevThree) && this.recordFilterSearch.isAdvFilterApply((EObject)e, this.filterTableElements)) {
                    arrayList.add(e);
                    ++this._visible;
                }
            }
            catch (ClassCastException classCastException) {
                arrayList.add(e);
                ++this._visible;
            }
            ++this._total;
            ++n;
        }
        return arrayList;
    }

    private boolean prepareFiltersAndSortAttributes() {
        List list = this.parsePreferenceString("pd_sort_log_options");
        String string = LogUIPlugin.getDefault().getPreferenceStore().getString("pd_sev_options");
        ArrayList arrayList = FilterTableElement.createFilterTableElementFromString(LogUIPlugin.getDefault().getPreferenceStore().getString("pd_adv_filter_options"));
        if (this.sortAttributes != null && !this.sortAttributes.equals(list) || list != null && !list.equals(this.sortAttributes)) {
            return this.swapFiltersAndSortAttributes(list, string, arrayList);
        }
        if (this.filters != null && !this.filters.equals(string) || string != null && !string.equals(this.filters)) {
            return this.swapFiltersAndSortAttributes(list, string, arrayList);
        }
        if (this.filterTableElements != null && !this.filterTableElements.equals(arrayList) || arrayList != null && !arrayList.equals(this.filterTableElements)) {
            return this.swapFiltersAndSortAttributes(list, string, arrayList);
        }
        return false;
    }

    private boolean swapFiltersAndSortAttributes(List list, String string, ArrayList arrayList) {
        this.sortAttributes = list;
        this.filters = string;
        this.filterTableElements = arrayList;
        this.updateSeverity();
        return true;
    }

    private void setTitle() {
        String[] stringArray = new String[]{"" + this._visible, "" + this._total, "" + this._currentPage, "" + this._totalPages};
        String string = this._title + " " + LogUIPlugin.getResourceString("STR_SHOW_INFO", stringArray);
        ((CLabel)this._viewer.getTopLeft()).setText(string);
    }

    private List parsePreferenceString(String string) {
        ArrayList<String> arrayList = null;
        String string2 = "";
        IPreferenceStore iPreferenceStore = LogUIPlugin.getDefault().getPreferenceStore();
        String string3 = LogUIPlugin.getDefault().getPreferenceStore().getString(string);
        if (string3 != null) {
            int n = string3.indexOf(" ");
            String string4 = "";
            int n2 = 0;
            arrayList = new ArrayList<String>();
            while (n != -1) {
                string4 = string3.substring(0, n);
                n2 = string4.indexOf(":");
                if (n2 > -1 && string4.substring(n2 + 1).equals("1")) {
                    arrayList.add(this.firstCharToUpperCase(string4.substring(0, n2)));
                }
                string3 = string3.substring(n + 1);
                n = string3.indexOf(" ");
            }
            int n3 = string3.indexOf(":");
            if (n3 > -1 && string3.substring(n3 + 1).equals("1")) {
                arrayList.add(this.firstCharToUpperCase(string3.substring(0, n3)));
            }
        }
        return arrayList;
    }

    private String firstCharToUpperCase(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private Sorter getLogSorter(List list) {
        if (this.sorter == null) {
            this.sorter = new Sorter(list);
        }
        this.sorter.setAttributes(list);
        return this.sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMonitorRecords(TRCMonitor tRCMonitor, List list, List list2) {
        try {
            try {
                Object[] objectArray = tRCMonitor.getNodes().toArray();
                int n = 0;
                while (n < objectArray.length) {
                    TRCNode tRCNode = (TRCNode)objectArray[n];
                    this.getNodeRecords(tRCNode, list, list2, true);
                    ++n;
                }
                list2.addAll(this.getFilteredRecords(list));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                list2.clear();
                Object var8_9 = null;
                list.clear();
            }
            Object var8_8 = null;
            list.clear();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            list.clear();
            throw throwable;
        }
    }

    private void getNodeRecords(TRCNode tRCNode, List list, List list2, boolean bl) {
        Object[] objectArray = tRCNode.getProcessProxies().toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.getProcessRecords((TRCProcessProxy)objectArray[n], list, list2, true);
            ++n;
        }
        if (!bl) {
            list2.addAll(this.getFilteredRecords(list));
            list.clear();
        }
    }

    private void getAgentRecords(TRCAgentProxy tRCAgentProxy, List list, List list2, boolean bl) {
        if (tRCAgentProxy != null && tRCAgentProxy.getAgent() != null) {
            EList eList = tRCAgentProxy.getAgent().getDefaultEvents();
            int n = 0;
            while (n < eList.size()) {
                list.add(eList.get(n));
                ++n;
            }
        }
        if (!bl) {
            list2.addAll(this.getFilteredRecords(list));
            list.clear();
        }
    }

    private void getProcessRecords(TRCProcessProxy tRCProcessProxy, List list, List list2, boolean bl) {
        try {
            EList eList = tRCProcessProxy.getAgentProxies();
            int n = 0;
            while (n < eList.size()) {
                this.getAgentRecords((TRCAgentProxy)eList.get(n), list, list2, true);
                ++n;
            }
            if (!bl) {
                list2.addAll(this.getFilteredRecords(list));
                list.clear();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list2.clear();
            list.clear();
        }
    }

    private void getFeatureNodes(EObject eObject, List list) {
        try {
            EClass eClass = eObject.eClass();
            Iterator iterator = eClass.getEAllStructuralFeatures().iterator();
            while (iterator.hasNext()) {
                Object object;
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                if (eStructuralFeature.getContainerClass().equals(class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent == null ? LogContentProvider.class$("org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent") : class$org$eclipse$hyades$models$hierarchy$AbstractDefaultEvent) || (!(eStructuralFeature instanceof EReference) || eStructuralFeature.getFeatureID() == 3) && (!(eStructuralFeature instanceof EAttribute) || !eStructuralFeature.isMany() || eStructuralFeature.getEType().getInstanceClass() == (class$java$lang$String == null ? LogContentProvider.class$("java.lang.String") : class$java$lang$String)) || (object = eObject.eGet(eStructuralFeature, true)) == null) continue;
                if (object instanceof EList) {
                    if (((EList)object).size() <= 0) continue;
                    list.add(new FeatureNode(eObject, eStructuralFeature));
                    continue;
                }
                list.add(new FeatureNode(eObject, eStructuralFeature));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            list.clear();
        }
    }

    private void getFeatureNodeElements(FeatureNode featureNode, List list) {
        block9: {
            try {
                EStructuralFeature eStructuralFeature = featureNode.getFeature();
                EObject eObject = featureNode.getElement();
                if (!(eStructuralFeature instanceof EReference)) break block9;
                if (eStructuralFeature.isMany()) {
                    EList eList = (EList)eObject.eGet(eStructuralFeature, true);
                    if (((EReference)eStructuralFeature).isContainment()) {
                        list.addAll(eList);
                    } else {
                        int n = 0;
                        EObject eObject2 = null;
                        String string = "";
                        Iterator iterator = eList.iterator();
                        while (iterator.hasNext()) {
                            eObject2 = (EObject)iterator.next();
                            EStructuralFeature eStructuralFeature2 = eObject2.eClass().getEStructuralFeature(11);
                            string = eStructuralFeature2 == CBEPackage.eINSTANCE.getCBECommonBaseEvent_Msg() ? (String)eObject2.eGet(eStructuralFeature2) : ((eStructuralFeature2 = eObject2.eClass().getEStructuralFeature(2)) == CBEPackage.eINSTANCE.getCBEDefaultEvent_ExtensionName() ? (String)eObject2.eGet(eStructuralFeature2) : eObject2.eClass().getName());
                            list.add(new TerminalNode(featureNode.getElement(), eObject2, string));
                            ++n;
                        }
                    }
                } else {
                    EObject eObject3 = (EObject)eObject.eGet(eStructuralFeature);
                    if (((EReference)eStructuralFeature).isContainment()) {
                        list.add(eObject3);
                    } else {
                        list.add(new TerminalNode(featureNode.getElement(), eObject3, eObject3.eClass().getName()));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean pageUp() {
        if (this._currentPage > 1) {
            --this._currentPage;
        }
        this.pageActionCalled = true;
        return this._currentPage != 1;
    }

    public boolean pageDown() {
        if (this._currentPage < this._totalPages) {
            ++this._currentPage;
        }
        this.pageActionCalled = true;
        return this._currentPage != this._totalPages;
    }

    public boolean goToPage(int n) {
        if (n > 0 && n <= this._totalPages) {
            this._currentPage = n;
        }
        this.pageActionCalled = true;
        return this._currentPage != this._totalPages;
    }

    public int getTotalPages() {
        return this._totalPages;
    }

    public boolean revealObject(EObject eObject) {
        if (this.allElements == null) {
            return false;
        }
        int n = this.allElements.indexOf(eObject);
        if (n == -1) {
            return false;
        }
        int n2 = this._currentPage;
        int n3 = ++n / this.PAGE_SIZE;
        n3 = n % this.PAGE_SIZE > 0 && n > 0 ? n3 + 1 : n3;
        this.goToPage(n3);
        return n3 != n2;
    }

    public List getCachedElements() {
        return this.allElements;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ReferenceList
    extends AbstractList {
        ArrayList agentURIs = new ArrayList();
        ArrayList references = new ArrayList();

        public int size() {
            return this.references.size();
        }

        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }

        private Object getRealObject(int n) {
            try {
                Object object = this.references.get(n);
                if (object != null && object instanceof ReferenceInfo) {
                    ReferenceInfo referenceInfo = (ReferenceInfo)this.references.get(n);
                    TRCAgent tRCAgent = (TRCAgent)HierarchyResourceSetImpl.getInstance().getEObject((URI)this.agentURIs.get(referenceInfo.agentIndex), true);
                    object = tRCAgent.getDefaultEvents().get(referenceInfo.defaultEventIndex);
                }
                return object;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void clear() {
            int n = this.modCount;
            this.agentURIs.clear();
            this.references.clear();
            if (n != this.modCount) {
                throw new ConcurrentModificationException();
            }
            ++this.modCount;
        }

        public Object get(int n) {
            return this.getRealObject(n);
        }

        public void add(int n, Object object) {
            try {
                int n2 = this.modCount;
                if (object instanceof CBEDefaultEvent) {
                    CBEDefaultEvent cBEDefaultEvent = (CBEDefaultEvent)object;
                    int n3 = ((EList)cBEDefaultEvent.eContainer().eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_DefaultEvents())).indexOf((Object)cBEDefaultEvent);
                    URI uRI = EcoreUtil.getURI((EObject)cBEDefaultEvent.eContainer());
                    int n4 = this.agentURIs.indexOf(uRI);
                    if (n4 == -1) {
                        this.agentURIs.add(uRI);
                        n4 = this.agentURIs.size() - 1;
                    }
                    ReferenceInfo referenceInfo = new ReferenceInfo(n4, n3);
                    this.references.add(n, referenceInfo);
                } else {
                    this.references.add(n, object);
                }
                if (n2 != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error " + exception.getLocalizedMessage() + " when adding object:" + object);
            }
        }

        public Object set(int n, Object object) {
            Object object2 = this.getRealObject(n);
            try {
                int n2 = this.modCount;
                if (object instanceof CBEDefaultEvent) {
                    CBEDefaultEvent cBEDefaultEvent = (CBEDefaultEvent)object;
                    int n3 = ((EList)cBEDefaultEvent.eContainer().eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgent_DefaultEvents())).indexOf((Object)cBEDefaultEvent);
                    URI uRI = EcoreUtil.getURI((EObject)cBEDefaultEvent.eContainer());
                    int n4 = this.agentURIs.indexOf(uRI);
                    if (n4 == -1) {
                        this.agentURIs.add(uRI);
                        n4 = this.agentURIs.size() - 1;
                    }
                    ReferenceInfo referenceInfo = new ReferenceInfo(n4, n3);
                    this.references.set(n, referenceInfo);
                } else {
                    this.references.set(n, object);
                }
                if (n2 != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Error " + exception.getLocalizedMessage() + " when adding object:" + object);
            }
            return object2;
        }

        public Object remove(int n) {
            int n2 = this.modCount;
            Object object = this.getRealObject(n);
            this.references.remove(n);
            if (n2 != this.modCount) {
                throw new ConcurrentModificationException();
            }
            return object;
        }

        public int indexOf(Object object) {
            int n = this.modCount;
            int n2 = 0;
            while (n2 < this.references.size()) {
                if (object == this.getRealObject(n2)) {
                    if (n != this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public void trimToSize() {
            this.agentURIs.trimToSize();
            this.references.trimToSize();
        }

        static class ReferenceInfo {
            protected byte agentIndex;
            protected int defaultEventIndex;

            public ReferenceInfo(int n, int n2) {
                this.agentIndex = (byte)n;
                this.defaultEventIndex = n2;
            }
        }
    }
}

