/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.views;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.analysis.engine.IAnalysisMonitor;
import org.eclipse.hyades.analysis.engine.ILogAnalyzer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.ProgressMonitorAdapter;
import org.eclipse.hyades.log.ui.internal.util.SymptomDBDialog;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogViewerUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogPaneTreeViewer
extends TreeViewer {
    private LogViewerUI _logViewUI = null;
    private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
    protected Action _updateAction;

    public LogPaneTreeViewer(LogViewerUI logViewerUI, Composite composite, String string) {
        super(composite);
        this._logViewUI = logViewerUI;
        this._updateAction = new UpdateAction(LogUIPlugin.getResourceString("REFRESH_VIEWS"));
    }

    public void setMenuListener(IMenuListener iMenuListener) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        ((Tree)this.getControl()).addSelectionListener(selectionListener);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            this.updateMenu(iMenuManager, ((IStructuredSelection)iSelection).getFirstElement());
        }
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this._updateAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    public void updateMenu(IMenuManager iMenuManager, Object object) {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            MenuManager menuManager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ACT"));
            iMenuManager.add((IContributionItem)menuManager);
            this.fillMenu((IContributionManager)menuManager, object);
            iMenuManager.add((IContributionItem)new Separator());
            menuManager = new MenuManager(LogUIPlugin.getResourceString("STR_ANALYZE_ALL_ACT"));
            iMenuManager.add((IContributionItem)menuManager);
            this.fillMenu((IContributionManager)menuManager);
        }
    }

    public void dispose() {
        List list = this.eph.getLogAnalyzers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ILogAnalyzer iLogAnalyzer = ((ExtensionPointHandler.ConfigurationElement)iterator.next()).getAnalyzer();
            iLogAnalyzer.unloadDatabase();
        }
    }

    private void fillMenu(IContributionManager iContributionManager) {
        iContributionManager.removeAll();
        List list = this.eph.getLogAnalyzers();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensionPointHandler.ConfigurationElement configurationElement = (ExtensionPointHandler.ConfigurationElement)iterator.next();
                AnalyzeAction analyzeAction = new AnalyzeAction(configurationElement.getName(), configurationElement.getAnalyzer(), true);
                iContributionManager.add((IAction)analyzeAction);
            }
        }
    }

    private void fillMenu(IContributionManager iContributionManager, Object object) {
        iContributionManager.removeAll();
        List list = this.eph.getLogAnalyzer(object);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensionPointHandler.ConfigurationElement configurationElement = (ExtensionPointHandler.ConfigurationElement)iterator.next();
                AnalyzeAction analyzeAction = new AnalyzeAction(configurationElement.getName(), configurationElement.getAnalyzer(), false);
                iContributionManager.add((IAction)analyzeAction);
            }
        }
    }

    class AnalyzeAction
    extends LoadAction {
        boolean analyzeAll = false;
        private IStructuredSelection sel;
        private ILogAnalyzer aLogAnalyzer;

        public AnalyzeAction(String string, ILogAnalyzer iLogAnalyzer) {
            super(string, iLogAnalyzer);
        }

        public AnalyzeAction(String string, ILogAnalyzer iLogAnalyzer, boolean bl) {
            super(string, iLogAnalyzer);
            this.analyzeAll = bl;
        }

        public IStructuredSelection getSelection() {
            Display.getDefault().syncExec(new Runnable(this){
                private final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = analyzeAction;
                }

                public void run() {
                    if (this.this$1.analyzeAll) {
                        AnalyzeAction.access$302(this.this$1, (IStructuredSelection)new StructuredSelection(((LogContentProvider)AnalyzeAction.access$400(this.this$1).getContentProvider()).getChildren(AnalyzeAction.access$400(this.this$1).getInput())));
                    } else {
                        AnalyzeAction.access$302(this.this$1, (IStructuredSelection)AnalyzeAction.access$400(this.this$1).getSelection());
                    }
                }
            });
            return this.sel;
        }

        public void run() {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(this){
                private final /* synthetic */ AnalyzeAction this$1;
                {
                    this.this$1 = analyzeAction;
                }

                public void run(IProgressMonitor iProgressMonitor) {
                    ProgressMonitorAdapter progressMonitorAdapter = new ProgressMonitorAdapter(iProgressMonitor);
                    progressMonitorAdapter.beginTask(LogUIPlugin.getResourceString("STR_ANALYZE_PROGRESS"), this.this$1.getSelection().size());
                    progressMonitorAdapter.subTask(LogUIPlugin.getResourceString("STR_ANALYZE_LOAD_DB"));
                    this.this$1.getLogAnalyzer().loadDatabase();
                    if (this.this$1.getLogAnalyzer().errorMsg() == null) {
                        this.this$1.getLogAnalyzer().analyze((Object)this.this$1.getSelection(), (IAnalysisMonitor)progressMonitorAdapter);
                    }
                    progressMonitorAdapter.done();
                }
            };
            try {
                LogUIPlugin.getActiveWorkbenchWindow().run(true, true, iRunnableWithProgress);
            }
            catch (Exception exception) {
                LogUIPlugin.log(exception);
            }
            if (this.getLogAnalyzer().errorMsg() != null && this.getLogAnalyzer().errorMsg().equals(LogUIPlugin.getResourceString("STR_NO_SYMPTOM_DB_ERROR"))) {
                if (MessageDialog.openQuestion((Shell)LogPaneTreeViewer.this.getControl().getShell(), (String)LogUIPlugin.getResourceString("STR_LOG_MSG"), (String)this.getLogAnalyzer().errorMsg())) {
                    super.run();
                    if (this.getReload()) {
                        try {
                            LogUIPlugin.getActiveWorkbenchWindow().run(true, true, iRunnableWithProgress);
                        }
                        catch (Exception exception) {
                            LogUIPlugin.log(exception);
                        }
                    }
                } else {
                    return;
                }
            }
            LogPaneTreeViewer.this.refresh();
            Event event = new Event();
            event.item = ((Tree)LogPaneTreeViewer.this.getControl()).getSelection()[0];
            LogPaneTreeViewer.this.getControl().notifyListeners(13, event);
        }

        static /* synthetic */ IStructuredSelection access$302(AnalyzeAction analyzeAction, IStructuredSelection iStructuredSelection) {
            analyzeAction.sel = iStructuredSelection;
            return analyzeAction.sel;
        }

        static /* synthetic */ LogPaneTreeViewer access$400(AnalyzeAction analyzeAction) {
            return analyzeAction.LogPaneTreeViewer.this;
        }
    }

    class LoadAction
    extends BasicLoadAction {
        public LoadAction(String string, ILogAnalyzer iLogAnalyzer) {
            super(string, iLogAnalyzer);
        }

        public void run() {
            SymptomDBDialog symptomDBDialog = new SymptomDBDialog(LogPaneTreeViewer.this.getControl().getShell(), LogUIPlugin.getResourceString("STR_SYMPTOM_DB_DLG_TITLE"), null);
            this.setReload(false);
            symptomDBDialog.open();
            if (symptomDBDialog.getReturnCode() == 0) {
                this.setReload(true);
            }
        }
    }

    class BasicLoadAction
    extends Action {
        private ILogAnalyzer logAnalyzer = null;
        private boolean reload = false;

        public BasicLoadAction(String string, ILogAnalyzer iLogAnalyzer) {
            super(string);
            this.logAnalyzer = iLogAnalyzer;
        }

        public ILogAnalyzer getLogAnalyzer() {
            return this.logAnalyzer;
        }

        public boolean getReload() {
            return this.reload;
        }

        public void setReload(boolean bl) {
            this.reload = bl;
        }

        public void run() {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(this){
                private final /* synthetic */ BasicLoadAction this$1;
                {
                    this.this$1 = basicLoadAction;
                }

                public void run() {
                    BasicLoadAction.access$100(this.this$1).loadDatabase();
                    if (BasicLoadAction.access$100(this.this$1).errorMsg() != null) {
                        MessageDialog.openError((Shell)BasicLoadAction.access$200(this.this$1).getControl().getShell(), (String)LogUIPlugin.getResourceString("STR_LOG_MSG"), (String)BasicLoadAction.access$100(this.this$1).errorMsg());
                        return;
                    }
                }
            });
        }

        public boolean isEnabled() {
            return true;
        }

        static /* synthetic */ ILogAnalyzer access$100(BasicLoadAction basicLoadAction) {
            return basicLoadAction.logAnalyzer;
        }

        static /* synthetic */ LogPaneTreeViewer access$200(BasicLoadAction basicLoadAction) {
            return basicLoadAction.LogPaneTreeViewer.this;
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)ContextIds.ACTLOG_VIEW_POPUP_REFRESH);
        }

        public void run() {
            LogPaneTreeViewer.this._logViewUI.update();
        }
    }
}

