/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.classloader;

import java.util.Hashtable;

public abstract class AbstractClassLoader
extends ClassLoader {
    private Hashtable classByClassName;
    private boolean prepend;
    private char classNameReplacementChar;

    protected AbstractClassLoader() {
        this.initialize();
    }

    protected AbstractClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.initialize();
    }

    private void initialize() {
        this.prepend = true;
        this.classByClassName = new Hashtable();
    }

    public void setPrepend(boolean bl) {
        this.prepend = bl;
    }

    public boolean getPrepend() {
        return this.prepend;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        block9: {
            clazz = (Class)this.classByClassName.get(string);
            if (clazz != null) {
                return clazz;
            }
            if (this.prepend) {
                try {
                    clazz = this.loadFromExtensions(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz == null) {
                    return super.loadClass(string, bl);
                }
            } else {
                try {
                    return super.loadClass(string, bl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = this.loadFromExtensions(string);
                    if (clazz != null) break block9;
                    throw new ClassFormatError();
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        this.classByClassName.put(string, clazz);
        return clazz;
    }

    protected abstract byte[] loadClassBytes(String var1);

    private Class loadFromExtensions(String string) throws ClassNotFoundException {
        byte[] byArray = null;
        byArray = this.loadClassBytes(string);
        if (byArray == null) {
            throw new ClassNotFoundException("className: " + string);
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    public void setClassNameReplacementChar(char c) {
        this.classNameReplacementChar = c;
    }

    protected String formatClassName(String string) {
        if (this.classNameReplacementChar == '\u0000') {
            return string.replace('.', '/') + ".class";
        }
        return string.replace('.', this.classNameReplacementChar) + ".class";
    }
}

