/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorSynchronizer
implements IDisposable {
    private AllInOneListener listener;
    private IEditorPart editorPart;
    private ISynchronizedEditorAdapter synchronizedEditorAdapter;
    private IFile editorFile;
    private OSFile editorOSFile;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter;

    public static boolean isReadOnly(IFile iFile) {
        if (iFile == null) {
            return false;
        }
        IPath iPath = iFile.getLocation();
        if (iPath == null) {
            return iFile.isReadOnly();
        }
        File file = new File(iPath.toString());
        if (file.exists()) {
            return !file.canWrite();
        }
        return false;
    }

    public static boolean exists(IFile iFile) {
        if (iFile == null) {
            return false;
        }
        IPath iPath = iFile.getLocation();
        if (iPath == null) {
            return iFile.exists();
        }
        return new File(iPath.toString()).exists();
    }

    public static IFile getEditorFile(IEditorInput iEditorInput) {
        if (iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)iEditorInput).getFile();
        }
        return null;
    }

    public EditorSynchronizer(IEditorPart iEditorPart) throws IllegalArgumentException {
        this.editorPart = iEditorPart;
        if (iEditorPart == null || iEditorPart.getSite() == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_INV"));
        }
        this.synchronizedEditorAdapter = (ISynchronizedEditorAdapter)iEditorPart.getAdapter(class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter == null ? (class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter = EditorSynchronizer.class$("org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter")) : class$org$eclipse$hyades$ui$adapter$ISynchronizedEditorAdapter);
        this.listener = new AllInOneListener();
        this.editorFile = EditorSynchronizer.getEditorFile(iEditorPart.getEditorInput());
        if (this.editorFile != null) {
            this.editorFile.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
            this.editorOSFile = new OSFile(this.editorFile);
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.listener);
        iEditorPart.getSite().getPage().addPartListener((IPartListener2)this.listener);
    }

    public void dispose() {
        if (this.listener == null) {
            return;
        }
        if (this.editorFile != null) {
            this.editorFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
            this.editorFile = null;
        }
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.listener);
        this.editorPart.getSite().getPage().removePartListener((IPartListener2)this.listener);
        this.listener = null;
        this.editorPart = null;
        this.synchronizedEditorAdapter = null;
        this.editorOSFile = null;
    }

    public IFile getEditorFile() {
        return this.editorFile;
    }

    protected OSFile getEditorOSFile() {
        return this.editorOSFile;
    }

    protected IEditorPart getEditorPart() {
        return this.editorPart;
    }

    protected ISynchronizedEditorAdapter getSynchronizedEditorAdapter() {
        return this.synchronizedEditorAdapter;
    }

    public void setResourceChangeListenerEnabled(boolean bl) {
        this.listener.setResourceChangeListenerEnabled(bl);
    }

    public boolean isResourceChangeListenerEnabled() {
        return this.listener.isResourceChangeListenerEnabled();
    }

    public synchronized void editorSaved() {
        if (this.getEditorOSFile() != null) {
            this.getEditorOSFile().wasChanged();
        }
    }

    public boolean validateEdit() {
        IStatus iStatus;
        return this.editorFile == null || !EditorSynchronizer.isReadOnly(this.editorFile) || (iStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.editorFile}, (Object)this.editorPart.getSite().getShell())).getCode() == 0;
    }

    public boolean validateEdit(IFile[] iFileArray) {
        IStatus iStatus;
        return this.editorFile == null || !EditorSynchronizer.isReadOnly(this.editorFile) || (iStatus = ResourcesPlugin.getWorkspace().validateEdit(iFileArray, (Object)this.editorPart.getSite().getShell())).getCode() == 0;
    }

    protected void checkOSFiles() {
        if (this.getEditorOSFile() != null && (this.getEditorOSFile().wasDeleted() ? this.editorFileDeleted() : (this.getEditorOSFile().wasChanged() ? this.editorFileChanged() : this.getEditorOSFile().writeAccessChanged() && this.editorFileWriteAccessChanged(this.getEditorOSFile().isReadOnly())))) {
            return;
        }
    }

    protected boolean editorFileDeleted() {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl;
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null && EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileDeleted()) {
                    return;
                }
                boolean bl2 = bl = !EditorSynchronizer.this.getEditorPart().isDirty();
                if (EditorSynchronizer.this.getEditorPart().isDirty()) {
                    if (EditorSynchronizer.this.isActiveEditor(EditorSynchronizer.this.getEditorPart())) {
                        MessageDialog messageDialog = new MessageDialog(EditorSynchronizer.this.getEditorPart().getSite().getShell(), HyadesUIPlugin.getString("Q_FILE_DELETED_TTL"), null, HyadesUIPlugin.getString("Q_FILE_DELETED"), 3, new String[]{HyadesUIPlugin.getString("LBL_SAVE"), HyadesUIPlugin.getString("LBL_CLOSE")}, 0);
                        bl = messageDialog.open() == 1;
                    } else if (EditorSynchronizer.this.getEditorOSFile() != null) {
                        EditorSynchronizer.this.getEditorOSFile().setIsDeleted();
                    }
                }
                if (bl) {
                    EditorSynchronizer.this.getEditorPart().getSite().getPage().closeEditor(EditorSynchronizer.this.getEditorPart(), false);
                } else if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().doSaveEditorFile(true);
                }
            }
        };
        return this.execute(runnable);
    }

    protected boolean editorFileChanged() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null && EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileChanged()) {
                    return;
                }
                if (EditorSynchronizer.this.getEditorFile() == null) {
                    return;
                }
                try {
                    EditorSynchronizer.this.getEditorFile().refreshLocal(1, null);
                }
                catch (CoreException coreException) {
                    HyadesUIPlugin.logError(coreException);
                }
                if (EditorSynchronizer.this.isActiveEditor(EditorSynchronizer.this.getEditorPart())) {
                    if (MessageDialog.openQuestion((Shell)EditorSynchronizer.this.getEditorPart().getSite().getShell(), (String)HyadesUIPlugin.getString("Q_FILE_CHANGED_TTL"), (String)HyadesUIPlugin.getString("Q_FILE_CHANGED")) && EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                        EditorSynchronizer.this.getSynchronizedEditorAdapter().reload();
                    }
                } else if (EditorSynchronizer.this.getEditorOSFile() != null) {
                    EditorSynchronizer.this.getEditorOSFile().setIsChanged();
                }
            }
        };
        return this.execute(runnable);
    }

    protected boolean editorFileWriteAccessChanged(final boolean bl) {
        final AllInOneListener allInOneListener = this.listener;
        Runnable runnable = new Runnable(){

            public void run() {
                if (allInOneListener.isResourceChangeListenerEnabled()) {
                    return;
                }
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().editorFileWriteAccessChanged(bl);
                }
            }
        };
        return this.execute(runnable);
    }

    protected void handle(final List list, final List list2) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (EditorSynchronizer.this.getSynchronizedEditorAdapter() != null) {
                    EditorSynchronizer.this.getSynchronizedEditorAdapter().handle(list, list2);
                }
            }
        };
        this.execute(runnable);
    }

    protected boolean execute(Runnable runnable) {
        this.getEditorPart().getSite().getShell().getDisplay().asyncExec((Runnable)new SynchronizedRunnable(this.listener, runnable));
        return false;
    }

    protected boolean isActiveEditor(IEditorPart iEditorPart) {
        try {
            return iEditorPart.getSite().getPage().getActiveEditor() == iEditorPart;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AllInOneListener
    implements IPartListener,
    IPartListener2,
    IWindowListener,
    IResourceChangeListener {
        private boolean resourceChangeListenerEnabled = true;

        private AllInOneListener() {
        }

        public void setResourceChangeListenerEnabled(boolean bl) {
            this.resourceChangeListenerEnabled = bl;
        }

        public boolean isResourceChangeListenerEnabled() {
            return this.resourceChangeListenerEnabled;
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (iWorkbenchPart == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (iWorkbenchPartReference.getPart(false) == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            if (iWorkbenchWindow == PlatformUI.getWorkbench().getActiveWorkbenchWindow() && iWorkbenchWindow.getActivePage() != null && iWorkbenchWindow.getActivePage().getActivePart() == EditorSynchronizer.this.getEditorPart()) {
                EditorSynchronizer.this.checkOSFiles();
            }
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (!this.resourceChangeListenerEnabled) {
                return;
            }
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
            try {
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                if (!resourceDeltaVisitor.getChangedFiles().isEmpty() && !resourceDeltaVisitor.getRemovedFiles().isEmpty()) {
                    EditorSynchronizer.this.handle(resourceDeltaVisitor.getChangedFiles(), resourceDeltaVisitor.getRemovedFiles());
                    resourceDeltaVisitor.dispose();
                }
            }
            catch (CoreException coreException) {
                HyadesUIPlugin.logError(coreException);
            }
        }
    }

    private class ResourceDeltaVisitor
    implements IDisposable,
    IResourceDeltaVisitor {
        private List changedFiles = new ArrayList();
        private List removedFiles = new ArrayList();

        private ResourceDeltaVisitor() {
        }

        public void dispose() {
            this.changedFiles.clear();
            this.removedFiles.clear();
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            if (iResourceDelta.getResource().getType() == 1 && (iResourceDelta.getKind() & 6) != 0) {
                IFile iFile = (IFile)iResourceDelta.getResource();
                if ((iResourceDelta.getKind() & 2) != 0) {
                    if (iFile.equals((Object)EditorSynchronizer.this.getEditorFile())) {
                        if (EditorSynchronizer.this.getEditorOSFile() != null) {
                            EditorSynchronizer.this.getEditorOSFile().wasDeleted();
                        }
                        if (EditorSynchronizer.this.editorFileDeleted()) {
                            this.dispose();
                            return false;
                        }
                    }
                } else if (iFile.equals((Object)EditorSynchronizer.this.getEditorFile())) {
                    if (EditorSynchronizer.this.getEditorOSFile() != null) {
                        EditorSynchronizer.this.getEditorOSFile().wasChanged();
                    }
                    if (EditorSynchronizer.this.editorFileChanged()) {
                        this.dispose();
                        return false;
                    }
                }
            }
            return true;
        }

        public List getChangedFiles() {
            return this.changedFiles;
        }

        public List getRemovedFiles() {
            return this.removedFiles;
        }
    }

    private static class OSFile {
        private File file;
        private long lastModified;
        private boolean writable = false;
        private boolean exists = false;

        public OSFile(IFile iFile) {
            IPath iPath = iFile.getLocation();
            if (iPath == null) {
                return;
            }
            this.file = new File(iPath.toOSString());
            if (this.file.exists()) {
                this.lastModified = this.file.lastModified();
                this.writable = this.file.canWrite();
                this.exists = this.file.exists();
            }
        }

        public boolean writeAccessChanged() {
            if (this.file != null) {
                if (!this.file.exists()) {
                    return false;
                }
                boolean bl = this.file.canWrite();
                if (bl != this.writable) {
                    this.writable = bl;
                    return true;
                }
            }
            return false;
        }

        public boolean wasDeleted() {
            if (this.file != null && this.exists && !this.file.exists()) {
                this.exists = false;
                return true;
            }
            return false;
        }

        public boolean wasChanged() {
            if (this.file != null) {
                if (!this.file.exists()) {
                    return false;
                }
                long l = this.file.lastModified();
                if (l != this.lastModified) {
                    this.lastModified = l;
                    return true;
                }
            }
            return false;
        }

        public void setIsChanged() {
            --this.lastModified;
        }

        public void setIsDeleted() {
            this.exists = true;
        }

        public boolean isReadOnly() {
            if (this.file != null && this.file.exists()) {
                return !this.file.canWrite();
            }
            return false;
        }

        public boolean exists() {
            if (this.file != null) {
                return this.file.exists();
            }
            return true;
        }
    }

    private static class SynchronizedRunnable
    implements Runnable {
        private AllInOneListener listener;
        private Runnable runnable;

        public SynchronizedRunnable(AllInOneListener allInOneListener, Runnable runnable) {
            this.listener = allInOneListener;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AllInOneListener allInOneListener = this.listener;
            synchronized (allInOneListener) {
                boolean bl = this.listener.isResourceChangeListenerEnabled();
                try {
                    this.listener.setResourceChangeListenerEnabled(false);
                    this.runnable.run();
                    Object var4_3 = null;
                    if (this.listener != null) {
                        this.listener.setResourceChangeListenerEnabled(bl);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.listener != null) {
                        this.listener.setResourceChangeListenerEnabled(bl);
                    }
                    throw throwable;
                }
                this.listener = null;
                this.runnable = null;
            }
        }
    }
}

