/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMapping;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.XMLUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.IPropertyListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AssociationMappingRegistry
implements IAssociationMappingRegistry {
    private static final String PREFERENCE_PREFIX_KEY = HyadesUIPlugin.getID() + ".AssociationMappingRegistry.";
    private Map associationMappingByExtensionPoint;
    private IAssociationDescriptorFilter filter;
    private String objectCategory;
    private IPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry;
    private ListenerList commitChangeListeners;
    private String xmlBuffer;

    public void initialize(String string, IAssociationDescriptorFilter iAssociationDescriptorFilter, IPreferenceStore iPreferenceStore) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_NULL", "objectCategory"));
        }
        this.objectCategory = string;
        this.filter = iAssociationDescriptorFilter;
        this.preferenceStore = iPreferenceStore;
        this.load(iPreferenceStore);
    }

    public void dispose() {
        CoreUtil.dispose(this.associationMappingByExtensionPoint);
        if (this.commitChangeListeners != null) {
            this.commitChangeListeners.clear();
        }
        this.filter = null;
        this.preferenceStore = null;
        this.xmlBuffer = null;
        this.imageRegistry = null;
    }

    public ImageRegistry getImageRegistry() {
        block2: {
            if (this.imageRegistry != null) break block2;
            try {
                this.imageRegistry = new ImageRegistry();
            }
            catch (RuntimeException runtimeException) {
                HyadesUIPlugin.logError(runtimeException);
            }
        }
        return this.imageRegistry;
    }

    public void setImageRegistry(ImageRegistry imageRegistry) {
        this.imageRegistry = imageRegistry;
    }

    public String getObjectCategory() {
        return this.objectCategory;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public IAssociationDescriptorFilter getFilter() {
        return this.filter;
    }

    public synchronized IAssociationMapping retrieveAssociationMapping(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_NULL", "extensionPoint"));
        }
        AssociationMapping associationMapping = null;
        if (this.associationMappingByExtensionPoint == null) {
            this.associationMappingByExtensionPoint = new TreeMap();
        } else {
            associationMapping = (AssociationMapping)this.associationMappingByExtensionPoint.get(string);
        }
        if (associationMapping == null) {
            associationMapping = new AssociationMapping(this, string, string2);
            this.associationMappingByExtensionPoint.put(string, associationMapping);
        }
        return associationMapping;
    }

    public IAssociationMapping getAssociationMapping(String string) {
        if (string == null || this.associationMappingByExtensionPoint == null) {
            return null;
        }
        return (AssociationMapping)this.associationMappingByExtensionPoint.get(string);
    }

    public IAssociationMapping[] getAssociationMappings() {
        if (this.associationMappingByExtensionPoint == null) {
            return new IAssociationMapping[0];
        }
        return this.associationMappingByExtensionPoint.values().toArray(new AssociationMapping[this.associationMappingByExtensionPoint.values().size()]);
    }

    public synchronized boolean checkpoint() {
        this.xmlBuffer = this.write();
        return true;
    }

    public synchronized void clearCheckpoint() {
        this.xmlBuffer = null;
    }

    public synchronized boolean commit() {
        this.checkpoint();
        if (this.write(this.preferenceStore)) {
            this.notifyCommitChangeListeners();
        }
        return true;
    }

    public synchronized boolean rollback() {
        if (this.xmlBuffer != null) {
            this.load(this.xmlBuffer);
        }
        return true;
    }

    public void addCommitChangeListener(IPropertyListener iPropertyListener) {
        if (this.commitChangeListeners == null) {
            this.commitChangeListeners = new ListenerList();
        }
        this.commitChangeListeners.add((Object)iPropertyListener);
    }

    public void removeCommitChangeListener(IPropertyListener iPropertyListener) {
        if (this.commitChangeListeners != null) {
            this.commitChangeListeners.remove((Object)iPropertyListener);
        }
    }

    protected void notifyCommitChangeListeners() {
        if (this.commitChangeListeners == null) {
            return;
        }
        Object[] objectArray = this.commitChangeListeners.getListeners();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            IPropertyListener iPropertyListener = (IPropertyListener)objectArray[n];
            try {
                iPropertyListener.propertyChanged((Object)this, 1);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n;
        }
    }

    protected String getPreferenceKey() {
        StringBuffer stringBuffer = new StringBuffer(PREFERENCE_PREFIX_KEY);
        stringBuffer.append(this.objectCategory);
        return stringBuffer.toString();
    }

    protected boolean load(IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore == null) {
            return false;
        }
        String string = iPreferenceStore.getString(this.getPreferenceKey());
        if (string == null || string.length() == 0) {
            return false;
        }
        return this.load(string);
    }

    protected boolean load(String string) {
        XMLUtil.setLogger(HyadesUIPlugin.getLogger());
        Element element = XMLUtil.loadDom(string, "AssociationMappingRegistry");
        if (element == null) {
            return false;
        }
        NodeList nodeList = XMLUtil.getChildrenByName(element, "AssociationMapping");
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            if (nodeList.item(n) instanceof Element) {
                this.loadMapping((Element)nodeList.item(n));
            }
            ++n;
        }
        return true;
    }

    protected boolean write(IPreferenceStore iPreferenceStore) {
        if (iPreferenceStore == null) {
            return false;
        }
        String string = this.write();
        if (string.equals(iPreferenceStore.getString(this.getPreferenceKey()))) {
            return false;
        }
        iPreferenceStore.setValue(this.getPreferenceKey(), string);
        return true;
    }

    protected String write() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml");
        stringBuffer.append(XMLUtil.createXMLAttribute("version", "1.0", false)).append(XMLUtil.createXMLAttribute("encoding", "UTF-8", false));
        stringBuffer.append("?>");
        stringBuffer.append("<AssociationMappingRegistry>");
        IAssociationMapping[] iAssociationMappingArray = this.getAssociationMappings();
        int n = 0;
        int n2 = iAssociationMappingArray.length;
        while (n < n2) {
            this.writeMapping(stringBuffer, iAssociationMappingArray[n]);
            ++n;
        }
        stringBuffer.append("</AssociationMappingRegistry>");
        return stringBuffer.toString();
    }

    protected void loadMapping(Element element) {
        String string = XMLUtil.getValue(element, "extensionPoint");
        if (string == null) {
            return;
        }
        String string2 = XMLUtil.getValue(element, "pluginId");
        IAssociationMapping iAssociationMapping = this.retrieveAssociationMapping(string, string2);
        String string3 = XMLUtil.getValue(element, "defaultId");
        if (string3 != null) {
            iAssociationMapping.setDefaultAssociationDescriptor(iAssociationMapping.getAssociationDescriptor(string3));
        }
        NodeList nodeList = XMLUtil.getChildrenByName(element, "TypeDetail");
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Element element2;
            String string4;
            if (nodeList.item(n) instanceof Element && (string4 = XMLUtil.getValue(element2 = (Element)nodeList.item(n), "type")) != null) {
                string3 = XMLUtil.getValue(element2, "defaultId");
                if (string3 != null) {
                    iAssociationMapping.setDefaultAssociationDescriptor(string4, iAssociationMapping.getAssociationDescriptor(string4, string3));
                }
                iAssociationMapping.removeAllFromAvoidSet(string4);
                NodeList nodeList2 = XMLUtil.getChildrenByName(element2, "AvoidedDescriptor");
                int n3 = 0;
                int n4 = nodeList2.getLength();
                while (n3 < n4) {
                    Element element3;
                    String string5;
                    if (nodeList2.item(n3) instanceof Element && (string5 = XMLUtil.getValue(element3 = (Element)nodeList2.item(n3), "id")) != null) {
                        iAssociationMapping.addToAvoidedSet(string4, iAssociationMapping.getAssociationDescriptor(string4, string5));
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected void writeMapping(StringBuffer stringBuffer, IAssociationMapping iAssociationMapping) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<AssociationMapping");
        stringBuffer2.append(XMLUtil.createXMLAttribute("extensionPoint", iAssociationMapping.getExtensionPoint(), false));
        stringBuffer2.append(XMLUtil.createXMLAttribute("pluginId", iAssociationMapping.getPluginId(), false));
        IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.getDefaultAssociationDescriptor();
        if (iAssociationDescriptor != null) {
            stringBuffer2.append(XMLUtil.createXMLAttribute("defaultId", iAssociationDescriptor.getId(), false));
        }
        stringBuffer2.append(">");
        boolean bl = false;
        String[] stringArray = iAssociationMapping.getTypes();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            iAssociationDescriptor = iAssociationMapping.getDefaultAssociationDescriptor(stringArray[n]);
            IAssociationDescriptor[] iAssociationDescriptorArray = iAssociationMapping.getAvoidedAssociationDescriptors(stringArray[n]);
            if (iAssociationDescriptor != null && iAssociationDescriptor.getId() != null || iAssociationDescriptorArray.length != 0) {
                bl = true;
                stringBuffer2.append("<TypeDetail");
                stringBuffer2.append(XMLUtil.createXMLAttribute("type", stringArray[n], false));
                if (iAssociationDescriptor != null) {
                    stringBuffer2.append(XMLUtil.createXMLAttribute("defaultId", iAssociationDescriptor.getId(), false));
                }
                stringBuffer2.append(">");
                int n3 = 0;
                int n4 = iAssociationDescriptorArray.length;
                while (n3 < n4) {
                    if (iAssociationDescriptorArray[n3].getId() != null) {
                        stringBuffer2.append("<AvoidedDescriptor");
                        stringBuffer2.append(XMLUtil.createXMLAttribute("id", iAssociationDescriptorArray[n3].getId(), false));
                        stringBuffer2.append("/>");
                    }
                    ++n3;
                }
                stringBuffer2.append("</TypeDetail>");
            }
            ++n;
        }
        stringBuffer2.append("</AssociationMapping>");
        if (bl) {
            stringBuffer.append(stringBuffer2);
        }
    }
}

