/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class NavigatorExtensionUtil {
    private static final String ALL = "all";
    private static final Map _contributions = new HashMap();
    private static final Map _filterSets = new HashMap();

    public static void fillContextMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection, String string) {
        INavigatorContribution[] iNavigatorContributionArray = NavigatorExtensionUtil.getContributions(string);
        int n = 0;
        while (n < iNavigatorContributionArray.length) {
            iNavigatorContributionArray[n].fillContextMenu(iMenuManager, iStructuredSelection);
            ++n;
        }
    }

    public static boolean select(Viewer viewer, Object object, Object object2, String string) {
        return NavigatorExtensionUtil.select(viewer, object, object2, string, false) || NavigatorExtensionUtil.select(viewer, object, object2, string, true);
    }

    public static boolean select(Viewer viewer, Object object, Object object2, String string, boolean bl) {
        NavigatorFilterSet[] navigatorFilterSetArray = NavigatorExtensionUtil.getFilterSetElements(string);
        int n = 0;
        while (n < navigatorFilterSetArray.length) {
            if (navigatorFilterSetArray[n].isEnabled() && navigatorFilterSetArray[n].isRecursive() == bl && navigatorFilterSetArray[n].getViewerFilter().select(viewer, object, object2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static INavigatorContribution[] getContributions(String string) {
        INavigatorContribution[] iNavigatorContributionArray = (INavigatorContribution[])_contributions.get(string == null ? ALL : string);
        if (iNavigatorContributionArray == null) {
            IExtension[] iExtensionArray = HyadesUIPlugin.getInstance().getDescriptor().getExtensionPoint("navigatorExtensions").getExtensions();
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if ("navigatorContribution".equals(iConfigurationElementArray[n2].getName())) {
                        String string2 = iConfigurationElementArray[n2].getAttribute("navigatorID");
                        if (string == null || string.equals(string2)) {
                            try {
                                String string3 = iConfigurationElementArray[n2].getAttribute("class");
                                Class<?> clazz = iExtensionArray[n].getDeclaringPluginDescriptor().getPluginClassLoader().loadClass(string3);
                                arrayList.add(clazz.newInstance());
                            }
                            catch (Exception exception) {
                                HyadesUIPlugin.logError(exception);
                            }
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            iNavigatorContributionArray = new INavigatorContribution[arrayList.size()];
            arrayList.toArray(iNavigatorContributionArray);
            _contributions.put(string == null ? ALL : string, iNavigatorContributionArray);
        }
        return iNavigatorContributionArray;
    }

    public static NavigatorFilterSet getFilterSetElement(String string) {
        if (string == null) {
            return null;
        }
        NavigatorFilterSet[] navigatorFilterSetArray = NavigatorExtensionUtil.getFilterSetElements(null);
        int n = 0;
        while (n < navigatorFilterSetArray.length) {
            if (string.equals(navigatorFilterSetArray[n].getID())) {
                return navigatorFilterSetArray[n];
            }
            ++n;
        }
        return null;
    }

    public static NavigatorFilterSet[] getFilterSetElements(String string) {
        NavigatorFilterSet[] navigatorFilterSetArray = (NavigatorFilterSet[])_filterSets.get(string == null ? ALL : string);
        if (navigatorFilterSetArray == null) {
            IExtension[] iExtensionArray = HyadesUIPlugin.getInstance().getDescriptor().getExtensionPoint("navigatorExtensions").getExtensions();
            ArrayList<NavigatorFilterSet> arrayList = new ArrayList<NavigatorFilterSet>();
            int n = 0;
            while (n < iExtensionArray.length) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if ("navigatorFilterSet".equals(iConfigurationElementArray[n2].getName())) {
                        String string2 = iConfigurationElementArray[n2].getAttribute("navigatorID");
                        if (string == null || string.equals(string2)) {
                            try {
                                arrayList.add(new NavigatorFilterSet(iConfigurationElementArray[n2]));
                            }
                            catch (Exception exception) {
                                HyadesUIPlugin.logError(exception);
                            }
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            navigatorFilterSetArray = new NavigatorFilterSet[arrayList.size()];
            arrayList.toArray(navigatorFilterSetArray);
            _filterSets.put(string == null ? ALL : string, navigatorFilterSetArray);
        }
        return navigatorFilterSetArray;
    }

    public static boolean hasChildren(Object object, String string) {
        INavigatorContribution[] iNavigatorContributionArray = NavigatorExtensionUtil.getContributions(string);
        int n = 0;
        while (n < iNavigatorContributionArray.length) {
            if (iNavigatorContributionArray[n].hasChildren(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static List getAllChildren(Object object, String string) {
        INavigatorContribution[] iNavigatorContributionArray = NavigatorExtensionUtil.getContributions(string);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < iNavigatorContributionArray.length) {
            arrayList.addAll(iNavigatorContributionArray[n].getChildren(object));
            ++n;
        }
        return arrayList;
    }

    public static Collection getAllModifiedItems(String string) {
        INavigatorContribution[] iNavigatorContributionArray = NavigatorExtensionUtil.getContributions(string);
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iNavigatorContributionArray.length) {
            hashSet.addAll(iNavigatorContributionArray[n].getModifiedItems());
            ++n;
        }
        return hashSet;
    }

    public static void disposeAll() {
        Iterator iterator = _contributions.values().iterator();
        while (iterator.hasNext()) {
            INavigatorContribution[] iNavigatorContributionArray = (INavigatorContribution[])iterator.next();
            int n = 0;
            while (n < iNavigatorContributionArray.length) {
                iNavigatorContributionArray[n].dispose();
                iNavigatorContributionArray[n] = null;
                ++n;
            }
        }
        _contributions.clear();
    }
}

