/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FilteredContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private ITreeContentProvider _tree;
    private IStructuredContentProvider _structured;
    private IContentProvider _provider;
    private String _navigatorID;
    private Viewer _viewer;

    public FilteredContentProvider(IContentProvider iContentProvider, String string, Viewer viewer) {
        this._provider = iContentProvider;
        if (iContentProvider instanceof IStructuredContentProvider) {
            this._structured = (IStructuredContentProvider)iContentProvider;
        }
        if (iContentProvider instanceof ITreeContentProvider) {
            this._tree = (ITreeContentProvider)iContentProvider;
        }
        this._navigatorID = string;
        this._viewer = viewer;
    }

    public Object[] getChildren(Object object) {
        if (this._tree != null) {
            Object[] objectArray = this._tree.getChildren(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (NavigatorExtensionUtil.select(this._viewer, object, objectArray[n], this._navigatorID, false)) {
                    arrayList.addAll(Arrays.asList(this.getChildren(objectArray[n])));
                } else if (!NavigatorExtensionUtil.select(this._viewer, object, objectArray[n], this._navigatorID, true)) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return EMPTY;
    }

    public Object getParent(Object object) {
        Object object2;
        if (this._tree != null && (object2 = this._tree.getParent(object)) != null) {
            Object object3 = this._tree.getParent(object2);
            if (NavigatorExtensionUtil.select(this._viewer, object3, object2, this._navigatorID)) {
                return this.getParent(object2);
            }
            return object2;
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (this._tree != null) {
            if (!this._tree.hasChildren(object)) {
                return false;
            }
            return this.getChildren(object).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        if (this._structured != null) {
            Object[] objectArray = this._structured.getElements(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                if (NavigatorExtensionUtil.select(this._viewer, object, objectArray[n], this._navigatorID, false)) {
                    arrayList.addAll(Arrays.asList(this.getChildren(objectArray[n])));
                } else if (!NavigatorExtensionUtil.select(this._viewer, object, objectArray[n], this._navigatorID, true)) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return EMPTY;
    }

    public void dispose() {
        this._provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this._provider.inputChanged(viewer, object, object2);
    }
}

