/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.TreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;

public class FrameListActionGroup
extends NavigatorActionGroup {
    private BackAction backAction;
    private ForwardAction forwardAction;
    private GoIntoAction goIntoAction;
    private UpAction upAction;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            FrameListActionGroup.this.updateActionBars();
        }
    };

    public FrameListActionGroup(ITreeNavigator iTreeNavigator) {
        super(iTreeNavigator);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.resourceChangeListener = null;
        super.dispose();
    }

    protected void createActions() {
        FrameList frameList = ((TreeNavigator)this.getNavigator()).getFrameList();
        this.goIntoAction = new GoIntoAction(frameList);
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (iStructuredSelection.size() == 1 && this.canBeFrameRoot(iStructuredSelection.getFirstElement())) {
            iMenuManager.add((IAction)this.goIntoAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.goIntoAction);
        iActionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        iActionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.upAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.backAction);
        iToolBarManager.add((IAction)this.forwardAction);
        iToolBarManager.add((IAction)this.upAction);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection;
        ActionContext actionContext = this.getContext();
        boolean bl = false;
        if (actionContext != null && (iStructuredSelection = (IStructuredSelection)actionContext.getSelection()).size() == 1) {
            bl = this.canBeFrameRoot(iStructuredSelection.getFirstElement());
        }
        this.goIntoAction.setEnabled(bl);
    }

    protected boolean canBeFrameRoot(Object object) {
        StructuredViewer structuredViewer = this.getNavigator().getViewer();
        if (structuredViewer instanceof TreeViewer) {
            return ((TreeViewer)structuredViewer).isExpandable(object);
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return false;
        }
        return object instanceof IContainer;
    }
}

