/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator.action;

import java.util.ArrayList;
import org.eclipse.hyades.ui.internal.action.CommonNavigatorFilterSetAction;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FiltersAction;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public abstract class NavigatorActionGroup
extends ActionGroup
implements IDisposable {
    public static final String GROUP_FILTERS = "group.filters";
    private Separator fAdditionsGroup;
    private Separator fOpenGroup;
    private Separator fDeleteGroup;
    private Separator fSaveGroup;
    private Separator fImportGroup;
    private Separator fRefreshGroup;
    private Separator fWorkbenchAdditionsGroup;
    private Separator fPropertiesGroup;
    private Separator fFiltersGroup;
    private IAction fFiltersAction;
    private IAction[] fCommonFilters;
    private INavigator navigator;

    public NavigatorActionGroup(INavigator iNavigator) {
        this.navigator = iNavigator;
        this.createActions();
        this.createActionGroups();
    }

    public void dispose() {
        this.navigator = null;
        this.disposeActionGroups();
        super.dispose();
    }

    public INavigator getNavigator() {
        return this.navigator;
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
    }

    protected void createActions() {
        this.fFiltersAction = new FiltersAction(this.navigator);
        ArrayList<CommonNavigatorFilterSetAction> arrayList = new ArrayList<CommonNavigatorFilterSetAction>();
        NavigatorFilterSet[] navigatorFilterSetArray = NavigatorExtensionUtil.getFilterSetElements(this.navigator.getID());
        int n = 0;
        while (n < navigatorFilterSetArray.length) {
            if (navigatorFilterSetArray[n].isCommon()) {
                arrayList.add(new CommonNavigatorFilterSetAction(navigatorFilterSetArray[n], this.navigator));
            }
            ++n;
        }
        this.fCommonFilters = new IAction[arrayList.size()];
        arrayList.toArray(this.fCommonFilters);
    }

    protected void createActionGroups() {
        this.fAdditionsGroup = new Separator("group.additions");
        this.fOpenGroup = new Separator("org.eclipse.ui.OpenWithSubMenu");
        this.fDeleteGroup = new Separator("group.delete");
        this.fSaveGroup = new Separator("group.save");
        this.fImportGroup = new Separator("group.import");
        this.fRefreshGroup = new Separator("group.refresh");
        this.fWorkbenchAdditionsGroup = new Separator("additions");
        this.fPropertiesGroup = new Separator("group.properties");
        this.fFiltersGroup = new Separator(GROUP_FILTERS);
    }

    protected void disposeActionGroups() {
        if (this.fAdditionsGroup != null) {
            this.fAdditionsGroup.dispose();
            this.fAdditionsGroup = null;
        }
        if (this.fOpenGroup != null) {
            this.fOpenGroup.dispose();
            this.fOpenGroup = null;
        }
        if (this.fDeleteGroup != null) {
            this.fDeleteGroup.dispose();
            this.fDeleteGroup = null;
        }
        if (this.fSaveGroup != null) {
            this.fSaveGroup.dispose();
            this.fSaveGroup = null;
        }
        if (this.fImportGroup != null) {
            this.fImportGroup.dispose();
            this.fImportGroup = null;
        }
        if (this.fRefreshGroup != null) {
            this.fRefreshGroup.dispose();
            this.fRefreshGroup = null;
        }
        if (this.fWorkbenchAdditionsGroup != null) {
            this.fWorkbenchAdditionsGroup.dispose();
            this.fWorkbenchAdditionsGroup = null;
        }
        if (this.fPropertiesGroup != null) {
            this.fPropertiesGroup.dispose();
            this.fPropertiesGroup = null;
        }
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)this.fAdditionsGroup);
        iMenuManager.add((IContributionItem)this.fOpenGroup);
        iMenuManager.add((IContributionItem)this.fDeleteGroup);
        iMenuManager.add((IContributionItem)this.fSaveGroup);
        iMenuManager.add((IContributionItem)this.fImportGroup);
        iMenuManager.add((IContributionItem)this.fRefreshGroup);
        iMenuManager.add((IContributionItem)this.fWorkbenchAdditionsGroup);
        iMenuManager.add((IContributionItem)this.fPropertiesGroup);
        NavigatorExtensionUtil.fillContextMenu(iMenuManager, this.navigator.getStructuredSelection(), this.navigator.getID());
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        if (this.fCommonFilters != null && this.fFiltersAction != null && NavigatorExtensionUtil.getFilterSetElements(this.navigator.getID()).length > 0) {
            IMenuManager iMenuManager = iActionBars.getMenuManager();
            iMenuManager.add((IContributionItem)this.fFiltersGroup);
            int n = 0;
            while (n < this.fCommonFilters.length) {
                iMenuManager.appendToGroup(GROUP_FILTERS, this.fCommonFilters[n]);
                ++n;
            }
            iMenuManager.appendToGroup(GROUP_FILTERS, this.fFiltersAction);
        }
    }
}

