/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.provider;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.adapter.IHyadesWorkbenchAdapter;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkbenchAdapterContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    private Class adapterClass;
    private Viewer viewer;
    private IResourceChangeUpdater resourceChangeUpdater;
    private IWorkspace currentWorkspace;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public WorkbenchAdapterContentProvider(Class clazz) throws IllegalArgumentException {
        if (clazz == null || !(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = WorkbenchAdapterContentProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(HyadesUIPlugin.getString("_ERROR_ARG_INV"));
        }
        this.adapterClass = clazz;
        this.inputChanged(null, null, ResourcesPlugin.getWorkspace());
    }

    public void dispose() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            this.currentWorkspace = null;
        }
        this.adapterClass = null;
        this.resourceChangeUpdater = null;
        this.viewer = null;
    }

    public void setResourceChangeUpdater(IResourceChangeUpdater iResourceChangeUpdater) {
        this.resourceChangeUpdater = iResourceChangeUpdater;
    }

    public IResourceChangeUpdater getResourceChangeUpdater() {
        return this.resourceChangeUpdater;
    }

    protected IWorkbenchAdapter getAdapter(Object object) {
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)object).getAdapter(this.adapterClass);
    }

    public Object getParent(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = this.getAdapter(object);
        if (iWorkbenchAdapter == null) {
            return null;
        }
        return iWorkbenchAdapter.getParent(object);
    }

    public boolean hasChildren(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = this.getAdapter(object);
        if (iWorkbenchAdapter == null) {
            return false;
        }
        if (iWorkbenchAdapter instanceof IHyadesWorkbenchAdapter) {
            return ((IHyadesWorkbenchAdapter)iWorkbenchAdapter).hasChildren(object);
        }
        return iWorkbenchAdapter.getChildren(object).length > 0;
    }

    public Object[] getChildren(Object object) {
        IWorkbenchAdapter iWorkbenchAdapter = this.getAdapter(object);
        if (iWorkbenchAdapter == null) {
            return new Object[0];
        }
        return iWorkbenchAdapter.getChildren(object);
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.viewer = viewer;
        IWorkspace iWorkspace = null;
        if (object2 instanceof IWorkspace) {
            iWorkspace = (IWorkspace)object2;
        } else if (object2 instanceof IContainer) {
            iWorkspace = ((IContainer)object2).getWorkspace();
        }
        if (iWorkspace != null && this.currentWorkspace != iWorkspace) {
            if (this.currentWorkspace != null) {
                this.currentWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            this.currentWorkspace = iWorkspace;
            this.currentWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (this.getResourceChangeUpdater() == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        final IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.getResourceChangeUpdater().started();
            try {
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        WorkbenchAdapterContentProvider.this.processDelta(iResourceDelta);
                    }
                });
                Object var5_4 = null;
                this.getResourceChangeUpdater().ended();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.getResourceChangeUpdater().ended();
                throw throwable;
            }
        }
    }

    protected void processDelta(IResourceDelta iResourceDelta) {
        int n;
        IResource[] iResourceArray;
        int n2;
        IResourceChangeUpdater iResourceChangeUpdater = this.getResourceChangeUpdater();
        if (iResourceChangeUpdater == null || !this.getResourceChangeUpdater().isActive()) {
            return;
        }
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        IResource iResource = iResourceDelta.getResource();
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n3 = 0;
        while (n3 < iResourceDeltaArray.length) {
            n2 = iResourceDeltaArray[n3].getFlags();
            if ((n2 & 0x8000) != 0 ? iResourceChangeUpdater.updateChildrenType(iResource) : (n2 & 0x100) != 0 && iResourceChangeUpdater.updateContent(iResource, iResourceDeltaArray[n3].getResource())) {
                return;
            }
            ++n3;
        }
        n2 = iResourceDelta.getFlags();
        if ((n2 & 0x14000) != 0 && iResourceChangeUpdater.updateProperties(iResource)) {
            return;
        }
        if ((n2 & 0x40000) != 0 && iResourceChangeUpdater.replaced(iResource)) {
            return;
        }
        int n4 = 0;
        while (n4 < iResourceDeltaArray.length) {
            this.processDelta(iResourceDeltaArray[n4]);
            ++n4;
        }
        iResourceDeltaArray = iResourceDelta.getAffectedChildren(2);
        if (iResourceDeltaArray.length > 0) {
            iResourceArray = new IResource[iResourceDeltaArray.length];
            n = 0;
            while (n < iResourceDeltaArray.length) {
                iResourceArray[n] = iResourceDeltaArray[n].getResource();
                ++n;
            }
            if (iResourceChangeUpdater.remove(iResource, iResourceArray)) {
                return;
            }
        }
        if ((iResourceDeltaArray = iResourceDelta.getAffectedChildren(1)).length > 0) {
            iResourceArray = new IResource[iResourceDeltaArray.length];
            n = 0;
            while (n < iResourceDeltaArray.length) {
                iResourceArray[n] = iResourceDeltaArray[n].getResource();
                ++n;
            }
            if (iResourceChangeUpdater.add(iResource, iResourceArray)) {
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

