/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavaUtil {
    public static void setVariableValue(final String string, final String string2, IProgressMonitor iProgressMonitor) throws JavaModelException, InterruptedException, InvocationTargetException {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = JavaUtil.getVariableValue(string);
        if (string3 != null) {
            if (string2.equals(string3)) {
                return;
            }
            if (new File(string2).equals(new File(string3))) {
                return;
            }
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaCore.setClasspathVariable((String)string, (IPath)new Path(string2), (IProgressMonitor)iProgressMonitor);
            }
        };
        workspaceModifyOperation.run(iProgressMonitor);
    }

    public static String getVariableValue(String string) {
        String string2;
        IPath iPath = JavaCore.getClasspathVariable((String)string);
        if (iPath != null && !(string2 = iPath.makeAbsolute().toString()).equals("")) {
            return string2;
        }
        return null;
    }

    public static void addResourcePatternToNotCopyList(String string) {
        String string2 = JavaCore.getOption((String)"org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        if (string2 == null) {
            string2 = "";
        }
        if (string2.indexOf(string) >= 0) {
            return;
        }
        if (!"".equals(string2)) {
            string2 = string2 + ",";
        }
        string2 = string2 + string;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        hashtable.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", string2);
        JavaCore.setOptions(hashtable);
    }

    public static void removeResourcePatternToNotCopyList(String string) {
        String string2 = JavaCore.getOption((String)"org.eclipse.jdt.core.builder.resourceCopyExclusionFilter");
        if (string2 == null) {
            string2 = "";
        }
        if (string2.indexOf(string) < 0) {
            return;
        }
        string2 = StringUtil.replace(string2, string, "");
        string2 = StringUtil.replace(string2, ",,", "");
        try {
            if (string2.startsWith(",")) {
                string2 = string2.substring(",".length());
            }
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(3);
        hashtable.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", string2);
        JavaCore.setOptions(hashtable);
    }

    public static String[] getProjectClasspath(IProject iProject, boolean bl) {
        Object object;
        if (iProject == null) {
            return new String[0];
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        if (iJavaProject == null) {
            return new String[0];
        }
        ArrayList<IClasspathEntry> arrayList = null;
        try {
            arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>(arrayList.size());
        try {
            object = iJavaProject.getOutputLocation();
            if (object != null) {
                hashSet.add(ResourceUtil.getFullPath((IPath)object));
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            IClasspathEntry iClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)((IClasspathEntry)object.next()));
            if (bl && !iClasspathEntry.isExported()) continue;
            String string = null;
            switch (iClasspathEntry.getEntryKind()) {
                case 1: 
                case 4: {
                    string = ResourceUtil.getFullPath(iClasspathEntry.getPath());
                    if (string == null) break;
                    hashSet.add(string);
                    break;
                }
                case 2: {
                    IPath iPath = iClasspathEntry.getPath().makeAbsolute();
                    IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.toString());
                    hashSet.addAll(Arrays.asList(JavaUtil.getProjectClasspath(iProject2, true)));
                    break;
                }
                case 5: {
                    break;
                }
                case 3: {
                    string = ResourceUtil.getFullPath(iClasspathEntry.getOutputLocation());
                    if (string == null) break;
                    hashSet.add(string);
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String getValidClassName(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        if (!bl && JavaConventions.validateIdentifier((String)string).isOK()) {
            return string;
        }
        string = StringUtil.toProperCase(string.trim());
        if (!Character.isLetter((string = StringUtil.replace(string, " ", "")).charAt(0))) {
            string = "C" + string;
        }
        if (!JavaConventions.validateIdentifier((String)string).isOK()) {
            return null;
        }
        return string;
    }

    public static String getValidIdentifierName(String string) {
        CharSequence charSequence;
        if (string == null) {
            return null;
        }
        if (Character.isLetter((string = string.trim()).charAt(0))) {
            charSequence = string.substring(0, 1).toLowerCase();
            if (string.length() > 1) {
                charSequence = (String)charSequence + string.substring(1);
            }
            string = charSequence;
        }
        if (JavaConventions.validateIdentifier((String)string).isOK()) {
            return string;
        }
        string = StringUtil.toProperCase(string.trim());
        if (Character.isLetter((string = StringUtil.replace(string, " ", "")).charAt(0))) {
            charSequence = string.substring(0, 1).toLowerCase();
            if (string.length() > 1) {
                charSequence = (String)charSequence + string.substring(1);
            }
            string = charSequence;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            string = "c" + string;
        }
        if (!JavaConventions.validateIdentifier((String)string).isOK()) {
            charSequence = new StringBuffer(string);
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                if (!Character.isJavaIdentifierPart(((StringBuffer)charSequence).charAt(n2))) {
                    ((StringBuffer)charSequence).replace(n2, n2 + 1, "_");
                }
                ++n2;
            }
            return ((StringBuffer)charSequence).toString();
        }
        return string;
    }
}

