/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.execution.testgen.http.TRCContext;
import org.eclipse.hyades.execution.testgen.http.TRCNode;
import org.eclipse.hyades.execution.testgen.http.TRCNodeHandler;
import org.eclipse.hyades.execution.testgen.http.TestgenHttpPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;

public class TestGenHttp {
    private static final String PACKET_A_CONNECTIONNAME = "connectionNumber";
    private static final String PACKET_S_DATA = "data";
    private static final String PACKET_S_DATA_A_ENCODING = "encoding";
    private static final String PACKET_S_DATA_A_ENCODING_V_NONE = "NONE";
    private static final String PACKET_S_DATA_A_ENCODING_V_ASCIIFY = "ASCIIFY";
    private static final String PACKET_S_DATA_A_ENCODING_V_BASE64 = "BASE64";
    private static final String PACKET_S_DATA_A_LENGTH = "length";
    private static final String PACKET_S_DATA_A_TYPE = "type";
    private static final String PACKET_S_DATA_A_TYPE_V_HTTPCONTENT = "HTTPCONTENT";
    private static final String PACKET_S_DATA_A_TYPE_V_HTTPMESSAGE = "HTTPMESSAGE";
    private static final String PACKET_A_FROM = "from";
    private static final String PACKET_A_FROM_V_CLIENT = "CLIENT";
    private static final String PACKET_A_FROM_V_SERVER = "SERVER";
    private static final String PACKET_A_TICKET = "ticket";
    private static final String PACKET_A_TIMESTAMP = "timestamp";
    private static final String PACKET_A_TYPE = "type";
    private static final String PACKET_A_TYPE_V_HTTP = "HTTP";
    private static final String PACKET_A_TYPE_V_HTTPS = "HTTPS";
    private static final String CRNL = "\r\n";
    private static final char SLASH = '/';
    private static final char COLON = ':';
    private static final String BLANK = " ";
    private static boolean isFirstPage = true;
    LinkedList connectionsList;
    private ParsedHttpMessage currentHttpRequest;
    private ParsedHttpMessage previousHttpRequest;
    TRCContext context = null;
    LinkedList newPageList;

    public TestGenHttp(TRCContext tRCContext) {
        this.context = tRCContext;
        isFirstPage = true;
        this.connectionsList = new LinkedList();
        this.newPageList = new LinkedList();
    }

    private void httpRequestMessage(TRCNode tRCNode) throws TestgenException {
        String string = tRCNode.getElement().getContent();
        if (string == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_CONTENT"), null);
        }
        String string2 = TRCNodeHandler.getAttributeValue(PACKET_S_DATA_A_ENCODING, tRCNode);
        if (string2 == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_ENCODING_ATT"), null);
        }
        if (!string2.equalsIgnoreCase(PACKET_S_DATA_A_ENCODING_V_NONE)) {
            if (string2.equals(PACKET_S_DATA_A_ENCODING_V_ASCIIFY)) {
                return;
            }
            if (string2.equals(PACKET_S_DATA_A_ENCODING_V_BASE64)) {
                return;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, CRNL);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (n == 0) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4);
                this.currentHttpRequest.method = stringTokenizer2.nextToken();
                string3 = stringTokenizer2.nextToken();
                if (string3.length() > 6 && string3.substring(0, 7).equals("http://")) {
                    try {
                        object = new URL(string3);
                        this.currentHttpRequest.path = ((URL)object).getPath();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    this.currentHttpRequest.path = string3;
                }
                object = stringTokenizer2.nextToken();
                this.currentHttpRequest.version = ((String)object).substring(((String)object).indexOf(47) + 1, ((String)object).length());
            } else {
                int n2 = string4.indexOf(58);
                string3 = string4.substring(0, n2);
                object = string4.substring(n2 + 1, string4.length());
                this.currentHttpRequest.headerNames.add(string3);
                this.currentHttpRequest.headerValues.add(object);
                if (string3.trim().equals("Host")) {
                    try {
                        URL uRL = new URL("http://" + ((String)object).trim());
                        this.currentHttpRequest.host = uRL.getHost();
                        this.currentHttpRequest.port = uRL.getPort();
                        if (this.currentHttpRequest.port == -1) {
                            this.currentHttpRequest.port = this.currentHttpRequest.bSSL ? 443 : 80;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
            ++n;
        }
    }

    private void httpRequestContent(TRCNode tRCNode) throws TestgenException {
        String string = tRCNode.getElement().getContent();
        if (string == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_CONTENT"), null);
        }
        String string2 = TRCNodeHandler.getAttributeValue(PACKET_S_DATA_A_ENCODING, tRCNode);
        if (string2 == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_ENCODING_ATT"), null);
        }
        if (string2.equalsIgnoreCase(PACKET_S_DATA_A_ENCODING_V_NONE)) {
            this.currentHttpRequest.body.append(string);
        } else if (string2.equals(PACKET_S_DATA_A_ENCODING_V_ASCIIFY) || string2.equals(PACKET_S_DATA_A_ENCODING_V_BASE64)) {
            // empty if block
        }
    }

    protected void handle_http_stop() throws TestgenException {
        this.reorderNodeList();
        this.writeNewPageList();
        this.context.setPageNumber(0);
    }

    private boolean checkResponseForNewPage(TRCNode tRCNode) throws TestgenException {
        boolean bl = false;
        List list = TRCNodeHandler.getSubNodeList(PACKET_S_DATA, tRCNode);
        if (list.isEmpty()) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_PACKET_NO_DATA"), null);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            String string = TRCNodeHandler.getAttributeValue("type", tRCNode2);
            if (string == null) {
                throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_TYPE_ATT"), null);
            }
            if (!string.equals(PACKET_S_DATA_A_TYPE_V_HTTPMESSAGE)) continue;
            bl = this.httpRequestMessageContentType(tRCNode2);
            break;
        }
        return bl;
    }

    private boolean httpRequestMessageContentType(TRCNode tRCNode) throws TestgenException {
        boolean bl = false;
        String string = tRCNode.getElement().getContent();
        if (string == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_CONTENT"), null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, CRNL);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n != 0) {
                int n2 = string2.indexOf(58);
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                if (string3.trim().equalsIgnoreCase("Content-Type")) {
                    String string5 = string4.trim().toLowerCase();
                    if (string5.trim().startsWith("text/html")) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
            ++n;
        }
        if (!bl) {
            bl = this.checkForRedirect(tRCNode);
        }
        return bl;
    }

    private void remove_unwanted_responses() throws TestgenException {
        LinkedList linkedList = null;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        TRCNode tRCNode = null;
        LinkedList<TRCNode> linkedList2 = new LinkedList<TRCNode>();
        linkedList = this.context.getPageList();
        n = linkedList.size();
        n2 = 0;
        while (n2 < n) {
            tRCNode = (TRCNode)linkedList.get(n2);
            bl = this.shouldIWriteNode(tRCNode);
            if (bl) {
                linkedList2.add(tRCNode);
            }
            ++n2;
        }
        int n3 = linkedList2.size();
        if (n3 > 0) {
            linkedList.clear();
            this.context.setPageList(linkedList2);
        }
    }

    boolean shouldIWriteNode(TRCNode tRCNode) throws TestgenException {
        List list;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = TRCNodeHandler.getAttributeValue(PACKET_A_FROM, tRCNode);
        if (string.equals(PACKET_A_FROM_V_CLIENT)) {
            bl2 = true;
            return true;
        }
        if (string.equals(PACKET_A_FROM_V_SERVER)) {
            bl3 = true;
        }
        if ((list = TRCNodeHandler.getSubNodeList(PACKET_S_DATA, tRCNode)).isEmpty()) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_PACKET_NO_DATA"), null);
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            String string2 = TRCNodeHandler.getAttributeValue("type", tRCNode2);
            if (string2 == null) {
                throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_TYPE_ATT"), null);
            }
            if (string2.equals(PACKET_S_DATA_A_TYPE_V_HTTPMESSAGE)) {
                bl5 = true;
                return true;
            }
            if (!string2.equals(PACKET_S_DATA_A_TYPE_V_HTTPCONTENT)) continue;
            bl4 = true;
            break;
        }
        if (bl3 && bl4) {
            bl = false;
        }
        return bl;
    }

    boolean checkIsResponse(TRCNode tRCNode) {
        boolean bl = false;
        String string = TRCNodeHandler.getAttributeValue(PACKET_A_FROM, tRCNode);
        if (string.equals(PACKET_A_FROM_V_CLIENT)) {
            bl = false;
        } else if (string.equals(PACKET_A_FROM_V_SERVER)) {
            bl = true;
        }
        return bl;
    }

    boolean checkIsRequest(TRCNode tRCNode) {
        boolean bl = false;
        String string = TRCNodeHandler.getAttributeValue(PACKET_A_FROM, tRCNode);
        if (string.equals(PACKET_A_FROM_V_CLIENT)) {
            bl = true;
        } else if (string.equals(PACKET_A_FROM_V_SERVER)) {
            bl = false;
        }
        return bl;
    }

    boolean checkForRedirect(TRCNode tRCNode) throws TestgenException {
        boolean bl = false;
        String string = tRCNode.getElement().getContent();
        if (string == null) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_CONTENT"), null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, CRNL);
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, BLANK);
        String string3 = stringTokenizer2.nextToken();
        String string4 = stringTokenizer2.nextToken();
        Integer n = new Integer(string4);
        int n2 = n;
        if (n2 == 302 || n2 == 301) {
            bl = true;
        }
        return bl;
    }

    private boolean parseHttpRequest(TRCNode tRCNode) throws TestgenException {
        int n;
        String string;
        List list;
        boolean bl = false;
        int n2 = 0;
        String string2 = TRCNodeHandler.getAttributeValue(PACKET_A_TIMESTAMP, tRCNode);
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if ((list = TRCNodeHandler.getSubNodeList(PACKET_S_DATA, tRCNode)).isEmpty()) {
            throw new TestgenException(TestgenHttpPlugin.getResourceString("E_PACKET_NO_DATA"), null);
        }
        this.currentHttpRequest = new ParsedHttpMessage();
        String string3 = TRCNodeHandler.getAttributeValue("type", tRCNode);
        this.currentHttpRequest.bSSL = string3.equals(PACKET_A_TYPE_V_HTTPS);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            string = TRCNodeHandler.getAttributeValue("type", tRCNode2);
            if (string == null) {
                throw new TestgenException(TestgenHttpPlugin.getResourceString("E_DATA_NO_TYPE_ATT"), null);
            }
            if (string.equals(PACKET_S_DATA_A_TYPE_V_HTTPMESSAGE)) {
                this.httpRequestMessage(tRCNode2);
                continue;
            }
            if (!string.equals(PACKET_S_DATA_A_TYPE_V_HTTPCONTENT)) continue;
            this.httpRequestContent(tRCNode2);
        }
        this.currentHttpRequest.nPageNum = n = this.context.getPageNumber();
        string = TRCNodeHandler.getAttributeValue(PACKET_A_CONNECTIONNAME, tRCNode);
        Integer n3 = new Integer(string);
        this.currentHttpRequest.nConnID = n3;
        Object var11_12 = null;
        this.currentHttpRequest.timeStampString = string2;
        return bl;
    }

    private boolean createPage(ParsedHttpMessage parsedHttpMessage) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        ILoop iLoop = null;
        int n = 0;
        int n2 = this.context.getPageNumber();
        String string2 = parsedHttpMessage.timeStampString;
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if (parsedHttpMessage.enumPage == 4 || parsedHttpMessage.enumPage == 1 || n2 == 0) {
            this.context.setPageNumber(++n2);
            string = parsedHttpMessage.host + parsedHttpMessage.path;
            iLoop = this.context.createNewPage(string);
        }
        string = parsedHttpMessage.method + BLANK + parsedHttpMessage.host;
        this.context.newTestCaseContext(string);
        parsedHttpMessage.nPageNum = n2;
        RequestHelper requestHelper = this.context.getRequestHelper();
        requestHelper.setAttribute(5, parsedHttpMessage.method);
        requestHelper.setAttribute(1, parsedHttpMessage.host);
        requestHelper.setAttribute(2, Integer.toString(parsedHttpMessage.port));
        requestHelper.setAttribute(3, parsedHttpMessage.path);
        requestHelper.setAttribute(6, parsedHttpMessage.version);
        int n3 = 0;
        while (n3 < parsedHttpMessage.headerNames.size()) {
            requestHelper.setHeader(((String)parsedHttpMessage.headerNames.get(n3)).trim(), ((String)parsedHttpMessage.headerValues.get(n3)).trim());
            ++n3;
        }
        requestHelper.setAttribute(8, Integer.toString(parsedHttpMessage.nPageNum));
        requestHelper.setAttribute(9, Integer.toString(parsedHttpMessage.enumPage));
        requestHelper.setAttribute(10, Integer.toString(parsedHttpMessage.nConnID));
        if (parsedHttpMessage.bSSL) {
            requestHelper.setAttribute(12, "true");
        } else {
            requestHelper.setAttribute(12, "false");
        }
        requestHelper.setAttribute(4, parsedHttpMessage.body.toString());
        HashMap hashMap = this.context.getLastRecvHashMap();
        int n4 = 0;
        Integer n5 = (Integer)hashMap.get("__global");
        if (n5 != null) {
            int n6 = n5;
            int n7 = n4 = n6 == -1 ? 0 : n - n6;
            if (n4 < 0) {
                n4 = 0;
            }
        }
        requestHelper.setAttribute(7, Integer.toString(n4));
        return bl;
    }

    private ResponseInfo parseHttpResponse(TRCNode tRCNode) throws TestgenException {
        ResponseInfo responseInfo = new ResponseInfo();
        HashMap hashMap = this.context.getLastRecvHashMap();
        int n = Integer.parseInt(TRCNodeHandler.getAttributeValue(PACKET_A_TIMESTAMP, tRCNode));
        hashMap.put("__global", new Integer(n));
        this.context.setLastRecvHashMap(hashMap);
        responseInfo.timeStampString = TRCNodeHandler.getAttributeValue(PACKET_A_TIMESTAMP, tRCNode);
        responseInfo.newPage = this.checkResponseForNewPage(tRCNode);
        return responseInfo;
    }

    private void reorderNodeList() throws TestgenException {
        int n = -1;
        int n2 = 0;
        this.remove_unwanted_responses();
        LinkedList linkedList = this.context.getPageList();
        n = linkedList.size();
        int n3 = -1;
        int n4 = -1;
        n2 = 0;
        while (n2 < n) {
            TRCNode tRCNode = (TRCNode)linkedList.get(n2);
            String string = TRCNodeHandler.getAttributeValue(PACKET_A_CONNECTIONNAME, tRCNode);
            Integer n5 = new Integer(string);
            n4 = n5;
            n3 = this.findConnection(n4);
            if (n3 == -1) {
                this.addConnectionNode(n4, tRCNode);
            } else {
                this.addConnectionChild(n3, tRCNode);
            }
            ++n2;
        }
        this.createNewPageList();
        int n6 = this.newPageList.size();
    }

    private int findConnection(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        n3 = this.connectionsList.size();
        if (n3 == 0) {
            n2 = -1;
        } else {
            n4 = 0;
            while (n4 < n3) {
                ConnectionNode connectionNode = (ConnectionNode)this.connectionsList.get(n4);
                if (connectionNode.connectionNumber == n) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
        }
        return n2;
    }

    private boolean addConnectionNode(int n, TRCNode tRCNode) {
        boolean bl = true;
        ConnectionNode connectionNode = new ConnectionNode();
        connectionNode.connectionNumber = n;
        connectionNode.childrenNodes = new LinkedList();
        connectionNode.childrenNodes.add(tRCNode);
        this.connectionsList.add(connectionNode);
        return bl;
    }

    public boolean addConnectionChild(int n, TRCNode tRCNode) {
        boolean bl = true;
        ConnectionNode connectionNode = (ConnectionNode)this.connectionsList.get(n);
        connectionNode.childrenNodes.add(tRCNode);
        return bl;
    }

    private void createNewPageList() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        ConnectionNode connectionNode = null;
        TRCNode tRCNode = null;
        int n4 = -1;
        n = this.connectionsList.size();
        n2 = 0;
        while (n2 < n) {
            connectionNode = (ConnectionNode)this.connectionsList.get(n2);
            n4 = connectionNode.childrenNodes.size();
            n3 = 0;
            while (n3 < n4) {
                tRCNode = (TRCNode)connectionNode.childrenNodes.get(n3);
                this.newPageList.add(tRCNode);
                ++n3;
            }
            ++n2;
        }
    }

    public void writeNewPageList() throws TestgenException {
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        TRCNode tRCNode = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ResponseInfo responseInfo = null;
        n = this.newPageList.size();
        n2 = 0;
        while (n2 < n) {
            tRCNode = (TRCNode)this.newPageList.get(n2);
            bl = this.checkIsRequest(tRCNode);
            if (bl) {
                bl2 = true;
                bl5 = this.parseHttpRequest(tRCNode);
            } else {
                bl3 = true;
                responseInfo = this.parseHttpResponse(tRCNode);
                this.currentHttpRequest.timeStampString = responseInfo.timeStampString;
                this.currentHttpRequest.newPage = responseInfo.newPage;
            }
            if (bl2 && bl3) {
                bl2 = false;
                bl3 = false;
                if (n == 2) {
                    this.currentHttpRequest.newPage = true;
                    this.currentHttpRequest.enumPage = 4;
                    this.createPage(this.currentHttpRequest);
                    break;
                }
                if (this.previousHttpRequest == null || n2 == 1) {
                    this.currentHttpRequest.newPage = true;
                    this.currentHttpRequest.enumPage = 1;
                    this.previousHttpRequest = this.currentHttpRequest;
                } else {
                    this.previousHttpRequest.enumPage = this.previousHttpRequest.newPage ? (this.currentHttpRequest.newPage ? 4 : 1) : (this.currentHttpRequest.newPage ? 3 : 2);
                    this.createPage(this.previousHttpRequest);
                    this.previousHttpRequest = this.currentHttpRequest;
                    this.previousHttpRequest.enumPage = 3;
                    if (n2 == n - 1) {
                        if (this.previousHttpRequest.newPage) {
                            this.previousHttpRequest.enumPage = 4;
                        }
                        this.createPage(this.previousHttpRequest);
                    }
                }
            }
            ++n2;
        }
    }

    private class ResponseInfo {
        String timeStampString;
        boolean newPage;

        private ResponseInfo() {
        }
    }

    private class ConnectionNode {
        int connectionNumber;
        LinkedList childrenNodes;

        private ConnectionNode() {
        }
    }

    private class ParsedHttpMessage {
        String method;
        String protocol;
        String host;
        int port;
        String path;
        String version;
        boolean bSSL;
        int enumPage;
        int nPageNum;
        int nConnID;
        boolean newPage;
        String timeStampString;
        ArrayList headerNames = new ArrayList();
        ArrayList headerValues = new ArrayList();
        StringBuffer body = new StringBuffer();

        private ParsedHttpMessage() {
        }
    }
}

