/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.IDetails;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class DBDetails
extends Composite
implements IDetails,
Listener {
    private Text txtDBName;
    private Text txtURL;
    private Text txtExtLocation;
    private Text txtDescription;
    private boolean isDisplaying = false;
    private SymptomDBEditor editor;
    private SDBRuntime currentSel = null;

    public DBDetails(RASWidgetFactory rASWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_SYPMTOMDBNAME_LABEL"), 0);
        this.txtDBName = rASWidgetFactory.createText(this, "", 0);
        this.txtDBName.setLayoutData((Object)new GridData(768));
        this.txtDBName.setData((Object)new Integer(0));
        Label label2 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_URL_LABEL"), 0);
        this.txtURL = rASWidgetFactory.createText(this, "", 0);
        this.txtURL.setLayoutData((Object)new GridData(768));
        this.txtURL.setData((Object)new Integer(1));
        Label label3 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_EXTERNALLOC_LABEL"), 0);
        this.txtExtLocation = rASWidgetFactory.createText(this, "", 0);
        this.txtExtLocation.setLayoutData((Object)new GridData(768));
        this.txtExtLocation.setData((Object)new Integer(2));
        Label label4 = rASWidgetFactory.createLabel(this, SDbPlugin.getResourceString("STR_DESCRIPTION_LABEL"), 0);
        this.txtDescription = rASWidgetFactory.createText(this, "", 770);
        GridData gridData = new GridData(1808);
        this.txtDescription.setLayoutData((Object)gridData);
        this.txtDescription.setData((Object)new Integer(3));
        WorkbenchHelp.setHelp((Control)this.txtDBName, (String)ContextIds.SYMDB_EDITOR_DETAILS_NAME);
        WorkbenchHelp.setHelp((Control)this.txtURL, (String)ContextIds.SYMDB_EDITOR_DETAILS_URL);
        WorkbenchHelp.setHelp((Control)this.txtExtLocation, (String)ContextIds.SYMDB_EDITOR_DETAILS_LOCATION);
        WorkbenchHelp.setHelp((Control)this.txtDescription, (String)ContextIds.SYMDB_EDITOR_DETAILS_DESCRIPTION);
        this.txtDBName.addListener(24, (Listener)this);
        this.txtURL.addListener(24, (Listener)this);
        this.txtExtLocation.addListener(24, (Listener)this);
        this.txtDescription.addListener(24, (Listener)this);
    }

    public void display(EObject eObject) {
        this.currentSel = (SDBRuntime)eObject;
        this.isDisplaying = true;
        this.txtDBName.setText(this.currentSel.getName() == null ? "" : this.currentSel.getName());
        this.txtURL.setText(this.currentSel.getSymptomUrl() == null ? "" : this.currentSel.getSymptomUrl());
        this.txtExtLocation.setText(this.currentSel.getLocalExternalFileLocation() == null ? "" : this.currentSel.getLocalExternalFileLocation());
        this.txtDescription.setText(this.currentSel.getDescription() == null ? "" : this.currentSel.getDescription());
        this.isDisplaying = false;
    }

    public void init(SymptomDBEditor symptomDBEditor) {
        this.editor = symptomDBEditor;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSel = (SDBRuntime)eObject;
        this.currentSel.setName(this.txtDBName.getText());
        this.currentSel.setSymptomUrl(this.txtURL.getText());
        this.currentSel.setLocalExternalFileLocation(this.txtExtLocation.getText());
        this.currentSel.setDescription(this.txtDescription.getText());
        return false;
    }

    public void setFocusToTextBox() {
        this.txtDBName.setFocus();
        this.txtDBName.setSelection(0, this.txtDBName.getText().length());
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        boolean bl = false;
        if (this.currentSel != null && !this.isDisplaying) {
            switch ((Integer)widget.getData()) {
                case 0: {
                    bl = this.editor.validateState((Widget)this.txtDBName, this, this.currentSel.getName() == null ? "" : this.currentSel.getName());
                    break;
                }
                case 1: {
                    bl = this.editor.validateState((Widget)this.txtURL, this, this.currentSel.getSymptomUrl() == null ? "" : this.currentSel.getSymptomUrl());
                    break;
                }
                case 2: {
                    bl = this.editor.validateState((Widget)this.txtExtLocation, this, this.currentSel.getLocalExternalFileLocation() == null ? "" : this.currentSel.getLocalExternalFileLocation());
                    break;
                }
                case 3: {
                    bl = this.editor.validateState((Widget)this.txtDescription, this, this.currentSel.getDescription() == null ? "" : this.currentSel.getDescription());
                }
            }
            if (bl) {
                this.editor.updateUIDirtyStatus(true);
                this.editor.updateModelDirtyStatus(true);
            }
        }
    }
}

