/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DBLabelProvider
extends LabelProvider {
    public Image getImage(Object object) {
        if (object instanceof SDBRuntime) {
            return SDbPluginImages.getImage("symptomdb_obj.gif");
        }
        if (object instanceof SDBSymptom) {
            return SDbPluginImages.getImage("symptomdb_desc_obj.gif");
        }
        if (object instanceof SDBSolution) {
            return SDbPluginImages.getImage("symptomdb_solution_obj.gif");
        }
        if (object instanceof SDBDirective) {
            return SDbPluginImages.getImage("trcdirective_obj.gif");
        }
        return null;
    }

    public String getText(Object object) {
        String string = SDbPlugin.getResourceString("STR_DEFAULT_NAME_LABEL");
        if (object instanceof SDBRuntime) {
            string = ((SDBRuntime)object).getName();
        } else if (object instanceof SDBSymptom) {
            string = ((SDBSymptom)object).getDescription();
            string = this.truncateString(string);
        } else if (object instanceof SDBSolution) {
            string = ((SDBSolution)object).getDescription();
            string = this.truncateString(string);
        } else if (object instanceof SDBDirective) {
            string = ((SDBDirective)object).getDescription();
            string = this.truncateString(string);
        }
        return string;
    }

    private String truncateString(String string) {
        int n = string.indexOf("\r\n", 0);
        if (n != -1) {
            string = string.substring(0, n);
        } else {
            n = string.indexOf("\n");
            if (n != -1) {
                string = string.substring(0, n);
            }
        }
        return string;
    }
}

