/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorDetailsPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditorOverviewPage;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.sdb.internal.util.ResourceStateInputProvider;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidatorImpl;
import org.eclipse.hyades.sdb.internal.util.SymptomDBSearchDialog;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.hyades.sdb.internal.util.ValidateSymptomDBEditListener;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.xml.sax.SAXParseException;

public class SymptomDBEditor
extends MultiPageEditorPart
implements ResourceStateInputProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    IFile iFile;
    SymptomDBEditorOverviewPage overviewPage = null;
    SymptomDBEditorDetailsPage detailsPage = null;
    private RASWidgetFactory factory = new RASWidgetFactory();
    private SDBRuntime fDatabase;
    private boolean dirtyUI = false;
    private boolean dirtyModel = false;
    private final String NL = System.getProperties().getProperty("line.separator");
    private List resources;
    private ValidateSymptomDBEditListener validateEditListener;
    private long cachedTimestamp;
    private ArrayList mofResources = new ArrayList(0);
    private boolean changed = false;
    private Display display;

    private RASWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        if (iEditorInput instanceof IFileEditorInput) {
            this.iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.setTitle(this.iFile.getName());
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.cachedTimestamp = this.getFileTimestamp();
        this.display = Display.getCurrent();
        this.enableEditActions();
    }

    public void createPages() {
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.getContainer(), 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        scrolledComposite.setLayout((Layout)gridLayout);
        this.overviewPage = new SymptomDBEditorOverviewPage(this.getWidgetFactory());
        scrolledComposite.setContent(this.overviewPage.getContent((Composite)scrolledComposite));
        int n = this.addPage((Control)scrolledComposite);
        this.setPageText(n, SDbPlugin.getResourceString("STR_OVERVIEW_LABEL"));
        WorkbenchHelp.setHelp((Control)scrolledComposite, (String)ContextIds.SYMDB_EDITOR_PAGE_OVERVIEW);
        scrolledComposite = new ScrolledComposite(this.getContainer(), 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        scrolledComposite.setLayout((Layout)gridLayout);
        this.detailsPage = new SymptomDBEditorDetailsPage(this.getWidgetFactory());
        scrolledComposite.setContent(this.detailsPage.getContent((Composite)scrolledComposite));
        Point point = this.detailsPage.getContent().computeSize(-1, -1);
        scrolledComposite.setMinWidth(point.x);
        scrolledComposite.setMinHeight(point.y);
        int n2 = this.addPage((Control)scrolledComposite);
        this.setPageText(n2, SDbPlugin.getResourceString("STR_DETAILS_LABEL"));
        WorkbenchHelp.setHelp((Control)scrolledComposite, (String)ContextIds.SYMDB_EDITOR_PAGE_DETAILS);
        this.overviewPage.init(this);
        if (this.getSearchDialog() != null) {
            this.getSearchDialog().setTarget(this.detailsPage);
            this.getSearchDialog().enableButton(false);
        }
    }

    protected void pageChange(int n) {
        if (n == 1) {
            if (this.fDatabase == null) {
                BusyIndicator.showWhile((Display)this.getContainer().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            SymptomDBEditor.this.loadModel();
                        }
                        catch (Exception exception) {
                            String string = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
                            MessageDialog.openError((Shell)SymptomDBEditor.this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string);
                            exception.printStackTrace();
                            return;
                        }
                    }
                });
                this.validateEditListener = new ValidateSymptomDBEditListener((IWorkbenchPart)this, new ResourceStateValidatorImpl(this));
                this.setViewerInput();
            }
            this.setGlobalFindActionHandler((IAction)this.detailsPage.getFindAction());
            if (this.getSearchDialog() != null) {
                this.getSearchDialog().enableButton(true);
            }
        } else {
            this.setGlobalFindActionHandler(null);
        }
        if (n == 0) {
            this.overviewPage.init(this);
            if (this.getSearchDialog() != null) {
                this.getSearchDialog().enableButton(false);
            }
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        try {
            if (this.isModelDirty() && !this.detailsPage.updateCurrentSelection(this.detailsPage.getCurrentSelection())) {
                return;
            }
            if (this.validateEditListener.checkSave()) {
                this.changed = true;
                this.validateModel();
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                hashMap.put("DECLARE_XML", Boolean.TRUE);
                this.fDatabase.eResource().save(hashMap);
                this.changed = false;
                this.cachedTimestamp = this.getFileTimestamp();
                this.updateUIDirtyStatus(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = SDbPlugin.getResourceString("STR_SAVE_SYMPTOMDB_ERROR_");
            string = TString.change(string, "%1", this.fDatabase.getName());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker iMarker) {
    }

    public boolean isDirtyUI() {
        return this.dirtyUI;
    }

    public void updateUIDirtyStatus(boolean bl) {
        this.dirtyUI = bl;
        this.firePropertyChange(257);
    }

    public boolean validateState(Widget widget, Listener listener, String string) {
        boolean bl = this.validateEditListener.validateState().isOK();
        if (!bl && widget != null) {
            widget.removeListener(24, listener);
            if (widget instanceof Text) {
                ((Text)widget).setText(string);
                widget.addListener(24, listener);
            } else if (widget instanceof CCombo) {
                ((CCombo)widget).setText(string);
                widget.addListener(13, listener);
            }
        }
        return bl;
    }

    public boolean isModelDirty() {
        return this.dirtyModel;
    }

    public void updateModelDirtyStatus(boolean bl) {
        this.dirtyModel = bl;
    }

    public boolean isDirty() {
        return this.isDirtyUI();
    }

    public void dispose() {
        this.factory.dispose();
        this.iFile.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public IFile getFile() {
        return this.iFile;
    }

    public SDBRuntime getModel() {
        return this.fDatabase;
    }

    public void loadModel() {
        if (this.fDatabase != null || this.iFile == null) {
            return;
        }
        try {
            SDBResourceSetImpl sDBResourceSetImpl = new SDBResourceSetImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
            Resource resource = sDBResourceSetImpl.getResource(URI.createURI((String)("platform:/resource" + this.iFile.getFullPath().toString())), true);
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                EList eList;
                Object e = iterator.next();
                if (!(e instanceof SDBRuntime)) continue;
                this.fDatabase = (SDBRuntime)e;
                EList eList2 = this.fDatabase.getSolutions();
                int n = 0;
                while (n < eList2.size()) {
                    eList = (SDBSolution)eList2.get(n);
                    eList.setDescription(this.convertToPlatformNL(eList.getDescription()));
                    ++n;
                }
                eList = this.fDatabase.getDirectives();
                int n2 = 0;
                while (n2 < eList.size()) {
                    SDBDirective sDBDirective = (SDBDirective)eList.get(n2);
                    sDBDirective.setDirectiveString(this.convertToPlatformNL(sDBDirective.getDirectiveString()));
                    ++n2;
                }
                return;
            }
        }
        catch (Exception exception) {
            String string = SDbPlugin.getResourceString("STR_LOAD_XMI_ERROR_");
            if (exception instanceof SAXParseException) {
                Status status = new Status(2, "org.eclipse.core.resources", 566, SDbPlugin.getResourceString("STR_LOAD_XMI_EXC_REASON_"), (Throwable)exception);
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string, (IStatus)status);
            } else {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string);
            }
            exception.printStackTrace();
            return;
        }
    }

    public IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public boolean isSetGlobalFindActionHandler() {
        IActionBars iActionBars;
        IAction iAction = null;
        IEditorActionBarContributor iEditorActionBarContributor = this.getEditorSite().getActionBarContributor();
        if (iEditorActionBarContributor != null && (iActionBars = ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars()) != null) {
            iAction = iActionBars.getGlobalActionHandler(ActionFactory.FIND.getId());
        }
        return iAction instanceof SymptomDBEditorDetailsPage.FindAction;
    }

    public IAction getGlobalFindActionHandler() {
        return this.detailsPage.getFindAction();
    }

    public SymptomDBSearchDialog getSearchDialog() {
        return this.detailsPage.getDialog();
    }

    public void setGlobalFindActionHandler(IAction iAction) {
        IEditorActionBarContributor iEditorActionBarContributor;
        if ((iAction == null || this.getActivePage() == 1) && (iEditorActionBarContributor = this.getEditorSite().getActionBarContributor()) != null) {
            IActionBars iActionBars = ((EditorActionBarContributor)iEditorActionBarContributor).getActionBars();
            if (iActionBars != null) {
                iActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), iAction);
            }
            iActionBars.updateActionBars();
        }
    }

    private String convertToPlatformNL(String string) {
        int n = 0;
        String string2 = string;
        String string3 = "\r\n";
        if (this.NL.equals("\r\n")) {
            string3 = "\n";
        } else if (this.NL.equals("\n")) {
            string3 = "\r\n";
        }
        if (string.indexOf(string3) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        int n2 = 0;
        if (this.NL.equals("\r\n")) {
            while (n <= string.length()) {
                n2 = string.indexOf(string3, n);
                if (n2 <= -1) {
                    stringBuffer.append(string.substring(n));
                    break;
                }
                if (n2 != 0 && string.charAt(n2 - 1) == '\r') {
                    stringBuffer.append(string.substring(n, n2 - 1) + this.NL);
                } else {
                    stringBuffer.append(string.substring(n, n2) + this.NL);
                }
                n = n2 + string3.length();
            }
        } else if (this.NL.equals("\n")) {
            while (n <= string.length()) {
                n2 = string.indexOf(string3, n);
                if (n2 <= -1) {
                    stringBuffer.append(string.substring(n));
                    break;
                }
                stringBuffer.append(string.substring(n, n2) + this.NL);
                n = n2 + string3.length();
            }
        }
        string2 = stringBuffer.toString();
        return string2;
    }

    public List getNonResourceFiles() {
        if (this.resources == null) {
            this.resources = new ArrayList();
            this.resources.add(this.iFile);
        }
        return this.resources;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            IResourceDelta iResourceDelta2;
            if (iResourceDelta != null && (iResourceDelta2 = iResourceDelta.findMember(this.iFile.getFullPath())) != null) {
                iResourceDelta2.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) {
        long l = this.getFileTimestamp();
        if (iResourceDelta.getKind() == 4 && (iResourceDelta.getFlags() & 0x100) != 0 && this.cachedTimestamp != l && !this.changed) {
            if (this.fDatabase == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                    }
                });
            } else {
                this.refreshEditor();
            }
            this.cachedTimestamp = this.getFileTimestamp();
        }
        if (iResourceDelta.getKind() == 2) {
            this.closeEditor();
        }
        return true;
    }

    private void setViewerInput() {
        Object[] objectArray = new Object[]{this.fDatabase};
        this.detailsPage.getViewer().setInput((Object)objectArray);
        this.detailsPage.setTreeRoot(objectArray);
        this.detailsPage.getViewer().setExpandedState(objectArray[0], true);
        this.detailsPage.init(this);
    }

    private void refreshEditor() {
        if (Thread.currentThread() == this.display.getThread()) {
            BusyIndicator.showWhile((Display)this.getContainer().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SymptomDBEditor.this.fDatabase = null;
                        SymptomDBEditor.this.loadModel();
                        SymptomDBEditor.this.setViewerInput();
                        SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                        SymptomDBEditor.this.updateUIDirtyStatus(false);
                    }
                    catch (Exception exception) {
                        String string = SDbPlugin.getResourceString("STR_LOAD_MODEL_ERROR_");
                        MessageDialog.openError((Shell)SymptomDBEditor.this.getContainer().getShell(), (String)SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"), (String)string);
                        exception.printStackTrace();
                        return;
                    }
                }
            });
        } else {
            this.fDatabase = null;
            this.loadModel();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SymptomDBEditor.this.setViewerInput();
                    SymptomDBEditor.this.overviewPage.init(SymptomDBEditor.this);
                    SymptomDBEditor.this.updateUIDirtyStatus(false);
                }
            });
        }
    }

    private void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SymptomDBEditor.this.getSite().getPage().closeEditor((IEditorPart)SymptomDBEditor.this, false);
            }
        });
    }

    private long getFileTimestamp() {
        long l = 0L;
        IPath iPath = this.iFile.getLocation();
        if (iPath != null) {
            l = iPath.toFile().lastModified();
        }
        return l;
    }

    public Control getControl(int n) {
        return super.getControl(n);
    }

    public EditorPage getPage(int n) {
        EditorPage editorPage = null;
        if (n == 0) {
            editorPage = this.overviewPage;
        } else if (n == 1) {
            editorPage = this.detailsPage;
        }
        return editorPage;
    }

    public int getActivePage() {
        return super.getActivePage();
    }

    private void validateModel() {
        SDBSolution sDBSolution;
        Iterator iterator;
        Iterator iterator2;
        Iterator iterator3 = this.fDatabase.getDirectives().iterator();
        while (iterator3.hasNext()) {
            iterator2 = ((SDBDirective)iterator3.next()).getSolutions().iterator();
            while (iterator2.hasNext()) {
                iterator = (SDBSolution)iterator2.next();
                if (iterator.eContainer() != null) continue;
                this.fDatabase.getSolutions().add((Object)iterator);
            }
        }
        iterator2 = this.fDatabase.getSymptoms().iterator();
        while (iterator2.hasNext()) {
            iterator = ((SDBSymptom)iterator2.next()).getSolutions().iterator();
            while (iterator.hasNext()) {
                sDBSolution = (SDBSolution)iterator.next();
                if (sDBSolution.eContainer() != null) continue;
                this.fDatabase.getSolutions().add((Object)sDBSolution);
            }
        }
        iterator = this.fDatabase.getSolutions().iterator();
        while (iterator.hasNext()) {
            Iterator iterator4;
            sDBSolution = (SDBSolution)iterator.next();
            Iterator iterator5 = sDBSolution.getSymptoms().iterator();
            while (iterator5.hasNext()) {
                iterator4 = (SDBSymptom)iterator5.next();
                if (iterator4.eContainer() != null) continue;
                this.fDatabase.getSymptoms().add((Object)iterator4);
            }
            iterator4 = sDBSolution.getDirectives().iterator();
            while (iterator4.hasNext()) {
                SDBDirective sDBDirective = (SDBDirective)iterator4.next();
                if (sDBDirective.eContainer() != null) continue;
                this.fDatabase.getDirectives().add((Object)sDBDirective);
            }
        }
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

