/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBExportUtil {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.NL + "" + this.NL + "<!DOCTYPE symptomDatabase [" + this.NL + "" + this.NL + "<!ELEMENT symptomDatabase (runtime+)>" + this.NL + "<!ATTLIST symptomDatabase>" + this.NL + "" + this.NL + "<!ELEMENT runtime (symptom+ , solution+ , directive*)>" + this.NL + "<!ATTLIST runtime" + this.NL + "    id ID #REQUIRED" + this.NL + "    name CDATA #IMPLIED" + this.NL + "    symptomUrl CDATA #IMPLIED" + this.NL + "    localExternalFileLocation CDATA #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT symptom (matchPattern+)>" + this.NL + "<!ATTLIST symptom" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    solutions IDREFS #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT matchPattern EMPTY>" + this.NL + "<!ATTLIST matchPattern" + this.NL + "    name CDATA #IMPLIED" + this.NL + "    value CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT solution EMPTY>" + this.NL + "<!ATTLIST solution" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    directives IDREFS #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT directive EMPTY>" + this.NL + "<!ATTLIST directive" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    directiveString CDATA #REQUIRED>" + this.NL + "]>" + this.NL + "" + this.NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + this.NL + "" + this.NL + "<symptomDatabase>" + this.NL + "    <runtime id=\"Runtime_0\" name=\"";
    protected final String TEXT_2 = "\" symptomUrl=\"";
    protected final String TEXT_3 = "\" localExternalFileLocation=\"";
    protected final String TEXT_4 = "\">" + this.NL + "    " + this.NL + "        <!-- Symptoms: -->" + this.NL;
    protected final String TEXT_5 = "         " + this.NL + "        <symptom id=\"Symptom_";
    protected final String TEXT_6 = "\" description=\"";
    protected final String TEXT_7 = "\" ";
    protected final String TEXT_8 = "solutions=\"";
    protected final String TEXT_9 = "\"";
    protected final String TEXT_10 = ">";
    protected final String TEXT_11 = this.NL + "            <matchPattern name=\"";
    protected final String TEXT_12 = "\" value=\"";
    protected final String TEXT_13 = "\"/>";
    protected final String TEXT_14 = "               " + this.NL + "        </symptom>";
    protected final String TEXT_15 = this.NL + this.NL + "        <!-- Solutions: -->" + this.NL;
    protected final String TEXT_16 = "         " + this.NL + "        <solution id=\"Solution_";
    protected final String TEXT_17 = "\" description=\"";
    protected final String TEXT_18 = "\" ";
    protected final String TEXT_19 = "directives=\"";
    protected final String TEXT_20 = "\"";
    protected final String TEXT_21 = "/>";
    protected final String TEXT_22 = this.NL + "     " + this.NL + "        <!-- Directives: -->" + this.NL;
    protected final String TEXT_23 = this.NL + "        <directive id=\"Directive_";
    protected final String TEXT_24 = "\" description=\"";
    protected final String TEXT_25 = "\" directiveString=\"";
    protected final String TEXT_26 = "\"/>";
    protected final String TEXT_27 = this.NL + "    </runtime>" + this.NL + "</symptomDatabase>";

    public String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String generate(SDBRuntime sDBRuntime, IProgressMonitor iProgressMonitor) {
        String string;
        EList eList;
        SDBSymptom sDBSymptom;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(this.normalize(sDBRuntime.getName()));
        stringBuffer.append("\" symptomUrl=\"");
        stringBuffer.append(this.normalize(sDBRuntime.getSymptomUrl()));
        stringBuffer.append("\" localExternalFileLocation=\"");
        stringBuffer.append(this.normalize(sDBRuntime.getLocalExternalFileLocation()));
        stringBuffer.append(this.TEXT_4);
        EList eList2 = sDBRuntime.getSymptoms();
        EList eList3 = sDBRuntime.getSolutions();
        EList eList4 = sDBRuntime.getDirectives();
        int n = eList2.size() + eList3.size() + eList4.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (!eList2.isEmpty()) {
            n2 = 0;
            while (n2 < eList2.size()) {
                sDBSymptom = (SDBSymptom)eList2.get(n2);
                eList = sDBSymptom.getSolutions();
                string = "";
                if (!eList.isEmpty()) {
                    n3 = 0;
                    while (n3 < eList.size() - 1) {
                        n4 = eList3.indexOf((Object)((SDBSolution)eList.get(n3)));
                        string = string + "Solution_" + n4 + " ";
                        ++n3;
                    }
                    n4 = eList3.indexOf((Object)((SDBSolution)eList.get(n3)));
                    string = string + "Solution_" + n4;
                }
                stringBuffer.append(this.TEXT_5);
                stringBuffer.append(n2);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(sDBSymptom.getDescription()));
                stringBuffer.append("\" ");
                if (!string.equals("")) {
                    stringBuffer.append("solutions=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                EList eList5 = sDBSymptom.getPatterns();
                if (!eList5.isEmpty()) {
                    n3 = 0;
                    while (n3 < eList5.size()) {
                        SDBMatchPattern sDBMatchPattern = (SDBMatchPattern)eList5.get(n3);
                        stringBuffer.append(this.TEXT_11);
                        stringBuffer.append(this.normalize(sDBMatchPattern.getName()));
                        stringBuffer.append("\" value=\"");
                        stringBuffer.append(this.normalize(sDBMatchPattern.getValue()));
                        stringBuffer.append("\"/>");
                        ++n3;
                    }
                }
                iProgressMonitor.worked(8000 / n);
                stringBuffer.append(this.TEXT_14);
                ++n2;
            }
        }
        stringBuffer.append(this.TEXT_15);
        if (!eList3.isEmpty()) {
            n2 = 0;
            while (n2 < eList3.size()) {
                sDBSymptom = (SDBSolution)eList3.get(n2);
                eList = sDBSymptom.getDirectives();
                string = "";
                n4 = 0;
                if (!eList.isEmpty()) {
                    n3 = 0;
                    while (n3 < eList.size() - 1) {
                        n4 = eList4.indexOf((Object)((SDBDirective)eList.get(n3)));
                        string = string + "Directive_" + n4 + " ";
                        ++n3;
                    }
                    n4 = eList4.indexOf((Object)((SDBDirective)eList.get(n3)));
                    string = string + "Directive_" + n4;
                }
                stringBuffer.append(this.TEXT_16);
                stringBuffer.append(n2);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(sDBSymptom.getDescription()));
                stringBuffer.append("\" ");
                if (!string.equals("")) {
                    stringBuffer.append("directives=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("/>");
                iProgressMonitor.worked(8000 / n);
                ++n2;
            }
        }
        stringBuffer.append(this.TEXT_22);
        if (!eList4.isEmpty()) {
            n2 = 0;
            while (n2 < eList4.size()) {
                sDBSymptom = (SDBDirective)eList4.get(n2);
                stringBuffer.append(this.TEXT_23);
                stringBuffer.append(n2);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(sDBSymptom.getDescription()));
                stringBuffer.append("\" directiveString=\"");
                stringBuffer.append(this.normalize(sDBSymptom.getDirectiveString()));
                stringBuffer.append("\"/>");
                iProgressMonitor.worked(8000 / n);
                ++n2;
            }
        }
        stringBuffer.append(this.TEXT_27);
        return stringBuffer.toString();
    }
}

