/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OutputterSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected CCombo typeCombo;
    protected Label uniqueIDText;
    protected Text descriptionText;
    protected boolean isDisplaying;
    protected OutputterConfigType currentSelection;
    protected OutputterConfigTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory = new OutputterItemProviderAdapterFactory();

    public OutputterSection(RuleBuilderWidgetFactory ruleBuilderWidgetFactory, Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_Outputter_Type"), 0);
        this.typeCombo = ruleBuilderWidgetFactory.createCombo(this, 8);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.typeCombo.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        this.initializeTypeCombo();
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_DESCR"), 0);
        this.descriptionText = ruleBuilderWidgetFactory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_ID"), 0);
        this.uniqueIDText = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        this.uniqueIDText.setLayoutData((Object)new GridData(768));
        label = ruleBuilderWidgetFactory.createLabel(this, "", 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.itemProvider = (OutputterConfigTypeItemProvider)this.itemFactory.createOutputterConfigTypeAdapter();
        this.itemProvider.addListener(this);
    }

    protected void initializeTypeCombo() {
        int n = 0;
        while (n < OutputterType.VALUES.size()) {
            this.typeCombo.add(((OutputterType)OutputterType.VALUES.get(n)).getName());
            ++n;
        }
    }

    public void display(EObject eObject) {
        if (eObject != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)eObject.eContainer());
        }
        if (this.currentSelection == eObject) {
            return;
        }
        if (this.uniqueIDText.isFocusControl() || this.descriptionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (OutputterConfigType)eObject;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueIDText.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.typeCombo.select(OutputterType.VALUES.indexOf(this.currentSelection.getType()));
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject eObject) {
        this.currentSelection = (OutputterConfigType)eObject;
        this.currentSelection.setUniqueID(this.uniqueIDText.getText());
        this.currentSelection.setDescription(this.descriptionText.getText());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (modifyEvent.getSource() == this.descriptionText) {
            String string2 = this.descriptionText.getText();
            if (!string2.equals(this.currentSelection.getDescription())) {
                if (string2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, OutputterConfigTypeItemProvider.DESCRIPTION);
                if (iItemPropertyDescriptor != null) {
                    iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string2);
                }
            }
        } else if (modifyEvent.getSource() == this.uniqueIDText && !(string = this.uniqueIDText.getText()).equals(this.currentSelection.getUniqueID())) {
            if (string.length() == 0 && this.currentSelection.getUniqueID() == null) {
                return;
            }
            IItemPropertyDescriptor iItemPropertyDescriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, OutputterConfigTypeItemProvider.UNIQUE_ID);
            if (iItemPropertyDescriptor != null) {
                iItemPropertyDescriptor.setPropertyValue((Object)this.currentSelection, (Object)string);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object == null || object != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string;
        if (selectionEvent.getSource() == this.typeCombo && !(string = this.typeCombo.getText()).equals(this.currentSelection.getType().getName())) {
            this.currentSelection.setType(OutputterType.get((String)string));
        }
    }
}

