/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.provider.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.provider.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.provider.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ResourceSelectionDialog
extends SelectionDialog {
    protected EditingDomain editingDomain;
    protected Object selection;

    public ResourceSelectionDialog(Shell shell, EditingDomain editingDomain) {
        super(shell);
        this.setTitle(AcadEditorPlugin.getPlugin().getString("STR_SELC_DLG_TITLE"));
        this.editingDomain = editingDomain;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridUtil.createFill();
        gridData.widthHint = 300;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(composite2, 2052);
        tree.setLayoutData((Object)GridUtil.createFill());
        final TreeViewer treeViewer = new TreeViewer(tree);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ResourceItemProviderAdapterFactory());
        arrayList.add((Object)new ConfigurationItemProviderAdapterFactory());
        arrayList.add((Object)new ExtractorItemProviderAdapterFactory());
        arrayList.add((Object)new ContextItemProviderAdapterFactory());
        arrayList.add((Object)new OutputterItemProviderAdapterFactory());
        arrayList.add((Object)new SensorItemProviderAdapterFactory());
        arrayList.add((Object)new AdapterItemProviderAdapterFactory());
        arrayList.add((Object)new ParserItemProviderAdapterFactory());
        arrayList.add((Object)new FormatterItemProviderAdapterFactory());
        arrayList.add((Object)new UnitItemProviderAdapterFactory());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(arrayList);
        treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)composedAdapterFactory));
        treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory));
        EList eList = this.editingDomain.getResourceSet().getResources();
        if (eList.size() > 0) {
            treeViewer.setInput(eList.get(0));
        } else {
            treeViewer.setInput((Object)this.editingDomain.getResourceSet());
        }
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                ResourceSelectionDialog.this.setSelection(iStructuredSelection.getFirstElement());
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (treeViewer.getExpandedState(object)) {
                        treeViewer.collapseToLevel(object, 1);
                    } else {
                        treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        return composite2;
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Object object) {
        this.selection = object;
    }
}

