/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class RuleBuilderWidgetFactory {
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BACKGROUND = "__bg";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    private Hashtable colorRegistry = new Hashtable();
    private Color backgroundColor;
    private Color clientAreaColor;
    private Color foregroundColor;
    private Color disabledColor;
    private Display display;
    public static final int BORDER_STYLE = 0;
    private BorderPainter borderPainter;
    private Color borderColor;

    public RuleBuilderWidgetFactory() {
        this(Display.getCurrent());
    }

    public RuleBuilderWidgetFactory(Display display) {
        this.display = display;
        this.initialize();
    }

    public Composite createComposite(Composite composite) {
        return this.createComposite(composite, 0);
    }

    public Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, n);
        composite2.setBackground(this.backgroundColor);
        return composite2;
    }

    public Button createButton(Composite composite, String string, int n) {
        int n2 = 0x800000;
        Button button = new Button(composite, n | n2);
        button.setBackground(this.backgroundColor);
        button.setForeground(this.foregroundColor);
        if (string != null) {
            button.setText(string);
        }
        return button;
    }

    public Composite createCompositeSeparator(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        GridData gridData = new GridData(768);
        gridData.heightHint = 3;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    public Label createLabel(Composite composite, String string) {
        return this.createLabel(composite, string, 0);
    }

    public Group createGroup(Composite composite, String string, int n) {
        Group group = new Group(composite, 0x800000);
        group.setText(string);
        group.setBackground(this.backgroundColor);
        return group;
    }

    public Table createTable(Composite composite, int n) {
        int n2 = 0x800000;
        return new Table(composite, n | n2);
    }

    public Label createLabel(Composite composite, String string, int n) {
        Label label = new Label(composite, n);
        if (string != null) {
            label.setText(string);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        return label;
    }

    public Label createSeparator(Composite composite, int n) {
        Label label = new Label(composite, 2 | n);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.borderColor);
        return label;
    }

    public Text createText(Composite composite, String string) {
        return this.createText(composite, string, 4);
    }

    public StyledText createStyledText(Composite composite, String string) {
        return this.createStyledText(composite, string, 4);
    }

    public StyledText createStyledText(Composite composite, String string, int n) {
        StyledText styledText = new StyledText(composite, n);
        if (string != null) {
            styledText.setText(string);
        }
        styledText.setBackground(this.clientAreaColor);
        styledText.setForeground(this.foregroundColor);
        return styledText;
    }

    public Text createText(Composite composite, String string, int n) {
        Text text = new Text(composite, n);
        if (string != null) {
            text.setText(string);
        }
        text.setBackground(this.clientAreaColor);
        text.setForeground(this.foregroundColor);
        return text;
    }

    public CCombo createCombo(Composite composite, int n) {
        CCombo cCombo = new CCombo(composite, 0x800000 | n);
        cCombo.setBackground(this.clientAreaColor);
        cCombo.setForeground(this.foregroundColor);
        return cCombo;
    }

    public Tree createTree(Composite composite, int n) {
        Tree tree = new Tree(composite, 0 | n);
        tree.setBackground(this.backgroundColor);
        tree.setForeground(this.foregroundColor);
        return tree;
    }

    public void dispose() {
        Enumeration enumeration = this.colorRegistry.elements();
        while (enumeration.hasMoreElements()) {
            Color color = (Color)enumeration.nextElement();
            color.dispose();
        }
        this.colorRegistry = null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getClientAreaColor() {
        return this.clientAreaColor;
    }

    public Color getColor(String string) {
        return (Color)this.colorRegistry.get(string);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    private void initialize() {
        this.clientAreaColor = this.display.getSystemColor(25);
        this.registerColor(COLOR_BACKGROUND, 255, 254, 249);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.backgroundColor = this.clientAreaColor;
        this.borderColor = this.getColor(COLOR_BORDER);
        this.foregroundColor = this.display.getSystemColor(24);
        this.disabledColor = this.display.getSystemColor(15);
    }

    public void paintBordersFor(Composite composite) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        composite.addPaintListener((PaintListener)this.borderPainter);
    }

    public void paintChildControlsFor(Composite composite) {
        this.paintBordersFor(composite);
        Control[] controlArray = composite.getChildren();
        if (!composite.getBackground().equals((Object)this.getColor(COLOR_COMPOSITE_SEPARATOR))) {
            composite.setBackground(this.getBackgroundColor());
        }
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (control instanceof Text || control instanceof CCombo || control instanceof Label || control instanceof Button || control instanceof Tree) {
                control.setBackground(this.backgroundColor);
                control.setForeground(this.foregroundColor);
            } else if (control instanceof Composite) {
                this.paintChildControlsFor((Composite)control);
            }
            ++n;
        }
    }

    public Color registerColor(String string, int n, int n2, int n3) {
        Color color = new Color((Device)this.display, n, n2, n3);
        this.colorRegistry.put(string, color);
        return color;
    }

    class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent paintEvent) {
            Composite composite = (Composite)paintEvent.widget;
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Control control = controlArray[n];
                if (control.isVisible()) {
                    GC gC;
                    Rectangle rectangle;
                    if (control instanceof Text || control instanceof StyledText || control instanceof Canvas || control instanceof Combo || control instanceof CCombo) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        if (control.isEnabled()) {
                            control.setBackground(RuleBuilderWidgetFactory.this.backgroundColor);
                        } else {
                            control.setBackground(RuleBuilderWidgetFactory.this.disabledColor);
                        }
                        control.setForeground(RuleBuilderWidgetFactory.this.foregroundColor);
                        gC.drawRectangle(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3);
                    } else if (control instanceof Tree || control instanceof Table) {
                        rectangle = control.getBounds();
                        gC = paintEvent.gc;
                        gC.setForeground(RuleBuilderWidgetFactory.this.borderColor);
                        if (control.isEnabled()) {
                            control.setBackground(RuleBuilderWidgetFactory.this.backgroundColor);
                        } else {
                            control.setBackground(RuleBuilderWidgetFactory.this.disabledColor);
                        }
                        gC.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                    }
                }
                ++n;
            }
        }
    }
}

