/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class ContentView
extends ViewPart {
    private final String CONTENT_TITLE = AcadEditorPlugin.getPlugin().getString("LOG_CONTENT");
    TextViewer contentViewer;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        this.init(iViewSite);
        this.enableEditActions();
    }

    public void createPartControl(Composite composite) {
        this.contentViewer = new TextViewer(composite, 2882);
        this.contentViewer.setEditable(false);
        this.set_Title();
        WorkbenchHelp.setHelp((Control)composite, (String)ContextIds.ACAD_EDITOR_CONTENT_VIEW);
    }

    public void showLog() {
        if (AcadGuiModelManager.getCurrentModel() != null) {
            this.setContent(AcadGuiModelManager.getCurrentModel().getLogContent());
        }
    }

    public void setFocus() {
        if (this.contentViewer != null && this.contentViewer.getControl().isDisposed()) {
            this.contentViewer.getControl().setFocus();
        }
    }

    private ImageDescriptor getImageDescriptor(String string) {
        String string2 = "icons/full/elcl16/";
        try {
            URL uRL = AcadEditorPlugin.getPlugin().getBaseURL();
            URL uRL2 = new URL(uRL, string2 + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void hookGlobalActions() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
    }

    private void updateActionEnablement() {
    }

    public void set_Title() {
        AcadGuiModel acadGuiModel = AcadGuiModelManager.getCurrentModel();
        StringBuffer stringBuffer = new StringBuffer(this.CONTENT_TITLE).append(" ");
        if (acadGuiModel != null) {
            long l = acadGuiModel.getCurrentCount();
            l = l >= 0L ? ++l : 0L;
            if (acadGuiModel.getContextInstance() == null || acadGuiModel.getContextInstance().eContainer() == null) {
                stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensorConfigType = AcadGuiModelManager.getLogForConfiguration(acadGuiModel);
                if (sensorConfigType != null) {
                    if (acadGuiModel.getEventCount() > 0L) {
                        String string = AcadEditorPlugin.getPlugin().getString("STR_CONTENT_TITLE", new Object[]{"0", String.valueOf(acadGuiModel.getEventCount())});
                        stringBuffer.append(" ").append(string);
                    }
                } else {
                    stringBuffer.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(stringBuffer.toString());
    }

    public void dispose() {
        super.dispose();
    }

    public String getText() {
        return ((StyledText)this.contentViewer.getControl()).getText();
    }

    public static final ContentView getContentView(boolean bl) {
        try {
            IWorkbenchPage iWorkbenchPage = AcadEditorPlugin.getDefault().getActivePage();
            if (iWorkbenchPage == null) {
                return null;
            }
            IViewPart iViewPart = null;
            if (bl && (iViewPart = iWorkbenchPage.showView("org.eclipse.hyades.logging.adapter.ui.views.contentview")) != null && iViewPart instanceof ContentView) {
                return (ContentView)iViewPart;
            }
            iViewPart = iWorkbenchPage.findView("org.eclipse.hyades.logging.adapter.ui.views.contentview");
            if (iViewPart != null && iViewPart instanceof ContentView) {
                return (ContentView)iViewPart;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public void reset() {
        this.setContent("");
    }

    public void setContent(String string) {
        if (this.contentViewer != null && string != null) {
            this.contentViewer.setDocument((IDocument)new Document(string));
        }
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }
}

