/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class CorrelateLogAction
implements IRunnableWithProgress {
    private final String corrName = LogCorrelatorPlugin.getResourceString((String)"CORR_NAME");
    private EObject mofObject;

    public EObject getMofObject() {
        return this.mofObject;
    }

    public void setMofObject(EObject eObject) {
        this.mofObject = eObject;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iProgressMonitor.worked(1);
        this.run();
        iProgressMonitor.done();
    }

    public void run() {
        if (this.mofObject != null && this.mofObject instanceof EObject) {
            IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
            try {
                IConfigurationElement iConfigurationElement = CorrelationHelper.getInstance().getCorrelationByName(this.corrName);
                if (iConfigurationElement != null) {
                    CorrelationContainerProxy correlationContainerProxy = CorrelationHelper.getInstance().createCorrelationContainer(iConfigurationElement, (Object)this.mofObject, this.corrName);
                    Navigator navigator = (Navigator)HyadesUtil.getActiveNavigator();
                    navigator.selectReveal((ISelection)new StructuredSelection((Object)correlationContainerProxy));
                    SDView sDView = (SDView)iWorkbenchPage.showView("org.eclipse.hyades.uml2sd.ui.view.SDView");
                    LoadersManager.getLoadersManager().createLoader("org.eclipse.hyades.sd.logc.internal.loader.LogInteractions", this.getClass().getClassLoader(), sDView);
                    ((LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader()).generateLogInteractions((EObject)correlationContainerProxy, false);
                }
            }
            catch (Exception exception) {
                String string = SDLogcPlugin.getResourceString((String)"STR_LOAD_SD_ERR_");
                Status status = new Status(2, "org.eclipse.core.resources", 566, exception.toString(), null);
                IWorkbenchWindow iWorkbenchWindow = SDLogcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)string, (String)"", (IStatus)status);
                exception.printStackTrace();
            }
        }
        this.mofObject = null;
    }

    public void dispose() {
    }
}

