/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class DataPoolRowGroupDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_EQUIVALENCE_CLASSES = "equivalenceClasses";
    private static final int HEIGHT = 70;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private IDatapool datapool = null;
    private String title = null;
    private boolean insertionMode = false;
    private Table table = null;
    private IDatapoolEquivalenceClass selectedEquivalenceClass = null;
    private IDatapoolEquivalenceClass previousEquivalenceClass = null;
    private Text nameField = null;
    private Color nameFieldForeground = null;
    private Combo equivalenceClassCombo = null;
    private Label errorLabel = null;
    private String name = null;
    private int insertionIndex = -1;

    public DataPoolRowGroupDialog(Shell shell, IDatapool iDatapool, Table table, IDatapoolEquivalenceClass iDatapoolEquivalenceClass, IDatapoolEquivalenceClass iDatapoolEquivalenceClass2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = iDatapool;
        this.title = string;
        this.table = table;
        this.previousEquivalenceClass = iDatapoolEquivalenceClass2;
        this.selectedEquivalenceClass = iDatapoolEquivalenceClass;
        if (string.equals(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))) {
            this.insertionMode = true;
        }
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 70;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_NAME"));
        this.nameField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        if (this.selectedEquivalenceClass != null) {
            this.name = this.selectedEquivalenceClass.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
        }
        Label label2 = new Label(composite2, 0);
        if (this.insertionMode) {
            label2.setText(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_INS"));
        } else {
            label2.setText(DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_MOVE"));
        }
        this.equivalenceClassCombo = new Combo(composite2, 12);
        IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = null;
        iDatapoolEquivalenceClassArray = this.getEquivalenceClasses(null);
        String[] stringArray = this.getEquivalenceClassLabels(iDatapoolEquivalenceClassArray);
        this.equivalenceClassCombo.setItems(stringArray);
        this.equivalenceClassCombo.setData(TAG_EQUIVALENCE_CLASSES, (Object)iDatapoolEquivalenceClassArray);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 150;
        this.equivalenceClassCombo.setLayoutData((Object)gridData);
        this.equivalenceClassCombo.addSelectionListener((SelectionListener)this);
        if (this.previousEquivalenceClass != null) {
            int n = this.datapool.getEquivalenceClassIndex(this.previousEquivalenceClass.getName());
            if (n != -1) {
                this.equivalenceClassCombo.select(n);
                this.insertionIndex = n;
            }
        } else {
            this.equivalenceClassCombo.select(this.equivalenceClassCombo.getItemCount() - 1);
            this.insertionIndex = -1;
        }
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.errorLabel = new Label(composite2, 0);
        this.errorLabel.setLayoutData((Object)gridData);
        return composite2;
    }

    private boolean enableOK() {
        boolean bl = true;
        String string = new String();
        Display display = Display.getDefault();
        Color color = display.getSystemColor(3);
        String string2 = this.nameField.getText();
        if (string2 != null && string2.length() > 0) {
            boolean bl2 = this.isNameUnique(string2);
            boolean bl3 = this.isNameValid(string2);
            if (bl2 && bl3) {
                this.nameField.setForeground(this.nameFieldForeground);
            } else {
                this.nameField.setForeground(color);
                if (!bl2) {
                    string = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_UNIQUE");
                } else if (!bl3) {
                    string = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID");
                }
                bl = false;
            }
        }
        if (bl) {
            this.getButton(0).setEnabled(true);
            this.errorLabel.setText(new String());
            return true;
        }
        String string3 = DatapoolPlugin.getResourceString("DATA_DLG_ERROR_INDICATOR") + string;
        this.errorLabel.setText(string3);
        this.errorLabel.setForeground(color);
        this.getButton(0).setEnabled(false);
        return false;
    }

    private IDatapoolEquivalenceClass[] getEquivalenceClasses(String string) {
        Object object;
        int n = this.datapool.getEquivalenceClassCount();
        Vector<IDatapoolEquivalenceClass> vector = new Vector<IDatapoolEquivalenceClass>();
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n2);
            object = iDatapoolEquivalenceClass.getName();
            if (!((String)object).equals(string)) {
                vector.add(iDatapoolEquivalenceClass);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new IDatapoolEquivalenceClass[n3];
        vector.toArray((T[])object);
        return object;
    }

    private String[] getEquivalenceClassLabels(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray) {
        int n = 0;
        if (iDatapoolEquivalenceClassArray != null) {
            n = iDatapoolEquivalenceClassArray.length;
        }
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n2];
            stringArray[n2] = iDatapoolEquivalenceClass.getName();
            ++n2;
        }
        stringArray[n] = DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_HEAD_VAR");
        return stringArray;
    }

    private String[] getRecordIndexLabels(IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClass == null) {
            return null;
        }
        int n = iDatapoolEquivalenceClass.getRecordCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = String.valueOf(n2);
            ++n2;
        }
        return stringArray;
    }

    private int findEquivalenceClassIndexInCombo(IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray, IDatapoolEquivalenceClass iDatapoolEquivalenceClass) {
        if (iDatapoolEquivalenceClassArray == null || iDatapoolEquivalenceClass == null) {
            return -1;
        }
        int n = 0;
        while (n < iDatapoolEquivalenceClassArray.length) {
            if (iDatapoolEquivalenceClassArray[n].equals(iDatapoolEquivalenceClass)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isNameUnique(String string) {
        if (this.datapool == null) {
            return true;
        }
        int n = 0;
        while (n < this.datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
            if (!iDatapoolEquivalenceClass.equals(this.selectedEquivalenceClass) && string.equals(iDatapoolEquivalenceClass.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        Combo combo = (Combo)selectionEvent.widget;
        if (combo.getSelectionIndex() != combo.getItemCount() - 1) {
            int n = combo.getSelectionIndex();
            IDatapoolEquivalenceClass[] iDatapoolEquivalenceClassArray = (IDatapoolEquivalenceClass[])combo.getData(TAG_EQUIVALENCE_CLASSES);
            iDatapoolEquivalenceClass = iDatapoolEquivalenceClassArray[n];
            this.insertionIndex = this.datapool.getEquivalenceClassIndex(iDatapoolEquivalenceClass.getName());
        } else {
            this.insertionIndex = -1;
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        this.enableOK();
    }

    private boolean isNameValid(String string) {
        String string2 = DatapoolPlugin.getResourceString("DATA_DLG_INVALID_NAME_CHARACTERS");
        return !this.hasInvalidCharacters(string, string2);
    }

    private boolean hasInvalidCharacters(String string, String string2) {
        int n = 0;
        while (n < string2.length()) {
            String string3 = string2.substring(n, n + 1);
            if (string.lastIndexOf(string3) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

