/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.IViewSelectionChangedListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.hyades.trace.views.util.internal.ColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.IPercentChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.PrintColumnsDialog;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class StatisticView
implements IViewSelectionChangedListener,
SelectionListener,
ControlListener,
IPercentChangedListener {
    protected ArrayList tmpList;
    protected StructuredViewer _viewer;
    protected TableLayout _tableLayout;
    protected Composite _viewContainer;
    protected Composite _filterContainer;
    protected ViewForm _dataPane;
    protected Composite _viewComp;
    protected Text _filterText;
    protected Button _caseControl;
    protected boolean _initialized = false;
    protected TraceViewerPage _page;
    protected StatisticFilter _viewerFilter;
    protected StatisticSorter _viewerSorter;
    protected ArrayList _currentColumns = null;
    protected boolean _newSelection = false;
    protected boolean _isShowPercent = false;
    protected boolean _deltaColumns = false;
    protected boolean _refresh = false;
    protected Action _updateAction;
    protected Action _chooseColumnAction;
    protected Action _showPercent;
    protected Action _deltaColumnsAction;
    protected Action _printColumnsAction;
    protected Separator fSeparator;
    protected double _maxTime;
    protected int _totalInst;
    protected int _totalCalls;
    protected int _activeInst;
    protected long _totalSize;
    protected long _activeSize;
    protected ArrayList _listOfColumExtension = new ArrayList();
    protected String _templateOfColumExtension = "";
    protected boolean _firstTime = true;

    protected StatisticView(Composite composite, TraceViewerPage traceViewerPage) {
        this._page = traceViewerPage;
        this._currentColumns = ColumnData.createColumnData(this.getColumnsPreferencesKey(), this.getDefaultColumnsTemplate());
        ArrayList arrayList = this.parseExtensions();
        if (arrayList != null && arrayList.size() != 0) {
            this._currentColumns.addAll(arrayList);
        }
        this.createControl(composite, this._currentColumns);
        int n = TraceUIPlugin.getDefault().getPreferenceStore().getInt("percent");
        if (n == 1) {
            this._isShowPercent = true;
        }
        this.initialize();
        this.tmpList = new ArrayList();
        this.fSeparator = new Separator();
        TraceUIPlugin.getDefault().addPercentChangedEventListener(this);
    }

    private void setMenuListener(IMenuListener iMenuListener) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(iMenuListener);
        Menu menu = menuManager.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget instanceof TableColumn) {
            this._viewerSorter.setSortedColumn((TableColumn)selectionEvent.widget);
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
            this._viewer.refresh();
        } else if (selectionEvent.widget instanceof Table || selectionEvent.widget instanceof TableTree) {
            this.updateModelSelection();
        } else if (selectionEvent.widget instanceof Button && selectionEvent.widget == this._caseControl) {
            this.filterNames();
        }
        this.updateButtons();
    }

    public abstract Table getTable();

    protected abstract IContentProvider getContentProvider();

    protected abstract void handleSelectionEvent();

    protected abstract StructuredViewer createTableViewer(Composite var1);

    protected abstract Composite createTable(Composite var1, int var2);

    protected abstract String getColumnsPreferencesKey();

    protected abstract String getDefaultColumnsTemplate();

    protected Composite getViewComponent() {
        return this._viewComp;
    }

    protected TraceViewerPage getTraceViewerPage() {
        return this._page;
    }

    protected ViewForm getDataPane() {
        return this._dataPane;
    }

    public void showNewSelection() {
        if (this._newSelection) {
            this.getTable().showSelection();
            this._newSelection = false;
        }
    }

    public boolean showingDeltaColumns() {
        return this._deltaColumns;
    }

    protected void setNewSelection() {
        this._newSelection = true;
    }

    public Action getUpdateAction() {
        if (this._updateAction == null) {
            this._updateAction = new UpdateAction(UIPlugin.getResourceString((String)"REFRESH_VIEWS"));
        }
        return this._updateAction;
    }

    public Action getDeltaColumnsAction() {
        if (this._deltaColumnsAction == null) {
            this._deltaColumnsAction = new DeltaColumnsAction(TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS"));
        }
        return this._deltaColumnsAction;
    }

    public Action getChooseColumnsAction(ArrayList arrayList, String string) {
        if (this._chooseColumnAction == null) {
            this._chooseColumnAction = new ChooseColumnsAction(TraceUIPlugin.getString("STR_ST_CHOOSE_COL"), arrayList, string);
        }
        return this._chooseColumnAction;
    }

    public Action getPrintColumnsAction() {
        if (this._printColumnsAction == null) {
            this._printColumnsAction = new PrintColumnsAction(TraceUIPlugin.getString("STR_ST_PRINT_COL"));
        }
        return this._printColumnsAction;
    }

    public Action getShowPercentAction() {
        if (this._showPercent == null) {
            this._showPercent = new ShowPercentAction(TraceUIPlugin.getString("SHOW_PERCENT"));
        }
        return this._showPercent;
    }

    public boolean isShowPercent() {
        return this._isShowPercent;
    }

    public Control getControl() {
        return this._viewContainer;
    }

    public ArrayList getColumnDataList() {
        return this._currentColumns;
    }

    public StructuredViewer getTableViewer() {
        return this._viewer;
    }

    public StatisticSorter getViewerSorter() {
        return this._viewerSorter;
    }

    public StatisticFilter getViewerFilter() {
        return this._viewerFilter;
    }

    public TableLayout getTableLayout() {
        return this._tableLayout;
    }

    protected abstract void updateButtons();

    public abstract void updateModelSelection();

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void controlMoved(ControlEvent controlEvent) {
    }

    public void controlResized(ControlEvent controlEvent) {
        Rectangle rectangle = this.getViewComponent().getClientArea();
        this.getDataPane().setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (controlEvent.getSource() instanceof TableColumn) {
            TableColumn tableColumn = (TableColumn)controlEvent.getSource();
            StatisticTableColumnInfo statisticTableColumnInfo = (StatisticTableColumnInfo)tableColumn.getData();
            ColumnData.setColumns(this.getColumnDataList(), this.getColumnsPreferencesKey());
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
    }

    public void refresh() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        if (!this.getTableViewer().getControl().isDisposed()) {
            this.update();
        }
    }

    public void selectionChanged() {
        this.handleSelectionEvent();
    }

    protected void filterNames() {
        String string = this._filterText.getText().trim();
        this._viewerFilter.setPattern(string, this._caseControl.getSelection());
        this._viewer.getControl().setRedraw(false);
        this._viewer.refresh();
        this._viewer.getControl().setRedraw(true);
    }

    public void updateUI(ArrayList arrayList) {
        this.update();
        this.updateButtons();
    }

    public void update() {
        if (this._firstTime) {
            this._viewer.addFilter((ViewerFilter)this._viewerFilter);
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn tableColumn = table.getColumn(0);
            this._viewerSorter.setSortedColumn(tableColumn);
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        this.getTableViewer().refresh();
    }

    protected void resetColumns(ArrayList arrayList) {
        Object object;
        String string = "";
        int n = this._viewerSorter.getSortSequence();
        Table table = this.getTable();
        table.setRedraw(false);
        this._tableLayout = new TableLayout();
        table.setLayout((Layout)this._tableLayout);
        int n2 = table.getColumnCount();
        while (n2 > 0) {
            TableColumn tableColumn = table.getColumn(table.getColumnCount() - 1);
            object = (StatisticTableColumnInfo)tableColumn.getData();
            if (((StatisticTableColumnInfo)object).isSortColumn()) {
                string = ((StatisticTableColumnInfo)object).getColumnData().name();
            }
            tableColumn.dispose();
            --n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            object = (ColumnData)arrayList.get(n3);
            if (((ColumnData)object).visible()) {
                StatisticTableColumnInfo statisticTableColumnInfo = new StatisticTableColumnInfo(this, (ColumnData)object, this._deltaColumns);
                if (((ColumnData)object).name().equals(string)) {
                    statisticTableColumnInfo.setSortColumn(true);
                }
            }
            ++n3;
        }
        if (this._viewerSorter.resetSortColumn(this.getTable()) == null) {
            this._viewer.setSorter(null);
        } else {
            this._viewerSorter.setSortSequence(n * -1);
            this._viewerSorter.setSortedColumn(this._viewerSorter.resetSortColumn(this.getTable()));
            this._viewer.setSorter((ViewerSorter)this._viewerSorter);
        }
        table.layout(true);
        table.redraw();
        this._viewer.refresh();
        table.setRedraw(true);
    }

    private void createControl(Composite composite, ArrayList arrayList) {
        this._viewContainer = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this._viewContainer.setLayout((Layout)gridLayout);
        this._viewContainer.setLayoutData((Object)GridUtil.createFill());
        this._filterContainer = new Composite(this._viewContainer, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this._filterContainer.setLayout((Layout)gridLayout);
        GridData gridData = GridUtil.createHorizontalFill();
        gridData.horizontalSpan = 2;
        this._filterContainer.setLayoutData((Object)gridData);
        this.createFilterControl(this._filterContainer);
        this._viewComp = new Composite(this._viewContainer, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this._viewComp.setLayout((Layout)gridLayout);
        gridData = GridUtil.createFill();
        gridData.horizontalSpan = 2;
        this._viewComp.setLayoutData((Object)gridData);
        this._dataPane = new ViewForm(this._viewComp, 0);
        Control control = this.createTableViewer((Composite)this._dataPane, arrayList);
        this._dataPane.setContent(control);
        this._dataPane.setLayoutData((Object)GridUtil.createFill());
        this._viewContainer.addControlListener((ControlListener)this);
    }

    private void createFilterControl(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(TraceUIPlugin.getString("STR_ST_FILTER"));
        this._filterText = new Text(composite, 2048);
        this._filterText.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    StatisticView.this.filterNames();
                }
            }
        });
        this._caseControl = new Button(composite, 32);
        this._caseControl.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._caseControl.setText(TraceUIPlugin.getString("STR_ST_CASE_SENSITIVE"));
        this._caseControl.setSelection(true);
        this._caseControl.addSelectionListener((SelectionListener)this);
        WorkbenchHelp.setHelp((Control)this._filterText, (String)(TraceUIPlugin.getPluginId() + ".stvw0001"));
        WorkbenchHelp.setHelp((Control)this._caseControl, (String)(TraceUIPlugin.getPluginId() + ".stvw0002"));
    }

    private Control createTableViewer(Composite composite, ArrayList arrayList) {
        Object object;
        this._tableLayout = new TableLayout();
        Composite composite2 = this.createTable(composite, 65540);
        this._viewer = this.createTableViewer(composite2);
        int n = 0;
        while (n < arrayList.size()) {
            object = (ColumnData)arrayList.get(n);
            if (((ColumnData)object).visible()) {
                new StatisticTableColumnInfo(this, (ColumnData)object, this._deltaColumns);
            }
            ++n;
        }
        object = this.getTable();
        object.setLinesVisible(true);
        object.setHeaderVisible(true);
        object.setLayout((Layout)this._tableLayout);
        object.setLayoutData((Object)new GridData(1808));
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
        if (composite2 instanceof TableTree) {
            ((TableTree)composite2).addSelectionListener((SelectionListener)this);
        } else if (composite2 instanceof Table) {
            ((Table)composite2).addSelectionListener((SelectionListener)this);
        }
        UIPlugin.getDefault().addViewSelectionChangedListener((IViewSelectionChangedListener)this);
        return this._viewer.getControl();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removePercentChangedEventListener(this);
        UIPlugin.getDefault().removeViewSelectionChangedListener((IViewSelectionChangedListener)this);
        this._page = null;
    }

    private void initialize() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
    }

    public abstract LabelProvider getTableLabelProvider();

    public void handlePercentChangedEvent() {
        this._isShowPercent = !this._isShowPercent;
        TraceUIPlugin.getDefault().getPreferenceStore().setValue("percent", this._isShowPercent ? 1 : 0);
        this.refresh();
        this.updateButtons();
    }

    private void printColumnsToHTML(String string) {
        String string2;
        FileOutputStream fileOutputStream;
        Object object;
        OutputStreamWriter outputStreamWriter = null;
        try {
            object = new File(string);
            fileOutputStream = new FileOutputStream(((File)object).toString(), false);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = this._page.getTraceViewer().getTitle();
        fileOutputStream = this._page.getMOFObject();
        if (fileOutputStream != null && fileOutputStream instanceof TRCAgent && (string2 = String.valueOf(((TRCAgent)fileOutputStream).getStartTime())) != null) {
            object = (String)object + " (" + string2 + ")";
        }
        string2 = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>" + string2);
        stringBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">" + string2 + "<head>" + string2 + "<STYLE TYPE=\"text/css\">" + string2 + "p, table, td, th {  font-family: arial, helvetica, geneva; font-size: 10pt}" + string2 + "body {  font-family: arial, helvetica, geneva; font-size: 10pt; clip:   rect(   ); margin-top: 5mm; margin-left: 3mm}" + string2 + "</STYLE>" + string2 + "</head>" + string2);
        stringBuffer.append("<body text=\"#000000\" bgcolor=\"#ffffff\">" + string2);
        stringBuffer.append("<table border=0 cellspacing=2 cellpadding=2 WIDTH=\"100%\">" + string2);
        stringBuffer.append("<caption align=top><B>" + string2);
        stringBuffer.append((String)object + string2);
        stringBuffer.append("</B></caption>" + string2);
        Table table = this.getTable();
        stringBuffer.append("<tr>" + string2);
        int n = 0;
        while (n < table.getColumnCount()) {
            if (n != 1) {
                String string3 = table.getColumn(n).getText();
                if (string3.indexOf("<") == 0) {
                    string3 = "&lt;" + string3.substring(1);
                } else if (string3.indexOf(">") == 0) {
                    string3 = "&gt;" + string3.substring(1);
                }
                stringBuffer.append("<th align=left>" + string3 + "</th>" + string2);
            }
            ++n;
        }
        stringBuffer.append("</tr>" + string2);
        boolean bl = true;
        int n2 = 0;
        while (n2 < table.getItemCount()) {
            if (bl) {
                stringBuffer.append("<tr BGCOLOR=\"#ffffbb\">" + string2);
            } else {
                stringBuffer.append("<tr>" + string2);
            }
            bl = !bl;
            int n3 = 0;
            while (n3 < table.getColumnCount()) {
                if (n3 != 1) {
                    String string4 = table.getItem(n2).getText(n3);
                    stringBuffer.append("<td align=left>" + string4 + "</td>" + string2);
                }
                ++n3;
            }
            stringBuffer.append("</tr>" + string2);
            ++n2;
        }
        stringBuffer.append("</table>" + string2);
        stringBuffer.append("</body>" + string2);
        stringBuffer.append("</html>" + string2);
        try {
            outputStreamWriter.write(stringBuffer.toString());
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected ArrayList parseExtensions() {
        return null;
    }

    class DeltaColumnsAction
    extends Action {
        public DeltaColumnsAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".ccol0000"));
        }

        public void run() {
            StatisticView.this._deltaColumns = !StatisticView.this._deltaColumns;
            StatisticView.this.resetColumns(StatisticView.this._currentColumns);
        }
    }

    class ShowPercentAction
    extends Action {
        public ShowPercentAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".clst0003"));
        }

        public void setChecked(boolean bl) {
            super.setChecked(bl);
        }

        public void run() {
            TraceUIPlugin.getDefault().notifyPercentChangedEventListener();
        }
    }

    class PrintColumnsAction
    extends Action {
        public PrintColumnsAction(String string) {
            super(string);
        }

        public void run() {
            PrintColumnsDialog printColumnsDialog = new PrintColumnsDialog(StatisticView.this.getControl().getShell(), TraceUIPlugin.getString("STR_ST_PRINT_COL"), null);
            printColumnsDialog.open();
            if (printColumnsDialog.getReturnCode() == 0) {
                StatisticView.this.printColumnsToHTML(printColumnsDialog.getFileName());
            }
        }
    }

    class ChooseColumnsAction
    extends Action {
        private ArrayList _cols;
        private String _key;

        public ChooseColumnsAction(String string, ArrayList arrayList, String string2) {
            super(string);
            this._cols = arrayList;
            this._key = string2;
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".ccol0000"));
        }

        public void run() {
            ColumnsDialog columnsDialog = new ColumnsDialog(StatisticView.this.getControl().getShell(), TraceUIPlugin.getString("STR_ST_COL_SETTINGS"), null, this._cols, StatisticView.this.getDefaultColumnsTemplate());
            columnsDialog.open();
            if (columnsDialog.getReturnCode() == 0) {
                ColumnData.setColumns(columnsDialog.getData(), this._cols, this._key);
                StatisticView.this.resetColumns(this._cols);
            }
        }
    }

    class UpdateAction
    extends Action {
        public UpdateAction(String string) {
            super(string);
            WorkbenchHelp.setHelp((IAction)this, (String)(TraceUIPlugin.getPluginId() + ".uvew0000"));
            PDPluginImages.setImageDescriptors((IAction)this, (String)"lcl16", (String)"updateviews_co.gif");
        }

        public void run() {
            ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
            profileEvent.setSource((Object)StatisticView.this._page.getMOFObject());
            profileEvent.setType(32);
            UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        }
    }

    public class StatisticFilter
    extends ViewerFilter {
        protected String _pattern;
        protected String _prefix = "";
        protected String _suffix = "";
        protected ArrayList _textList;
        protected boolean _caseSensitive = true;
        protected boolean _exactMatch;
        protected boolean _noPattern = true;

        public void setPattern(String string, boolean bl) {
            this._caseSensitive = bl;
            this._pattern = this._caseSensitive ? string : string.toLowerCase();
            this._noPattern = string == "*" || string == "";
            this._exactMatch = this._pattern.indexOf("*") == -1;
            StringTokenizer stringTokenizer = new StringTokenizer(this._pattern, "*");
            this._textList = new ArrayList();
            while (stringTokenizer.hasMoreTokens()) {
                this._textList.add(stringTokenizer.nextToken());
            }
            if (this._pattern.startsWith("*")) {
                this._prefix = "";
            } else if (this._textList.size() > 0) {
                this._prefix = (String)this._textList.get(0);
                this._textList.remove(0);
            }
            if (this._pattern.endsWith("*")) {
                this._suffix = "";
            } else if (this._textList.size() > 0) {
                this._suffix = (String)this._textList.get(this._textList.size() - 1);
                this._textList.remove(this._textList.size() - 1);
            }
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            boolean bl = true;
            if (this._noPattern) {
                return true;
            }
            String string = "";
            if (object2 instanceof TRCPackage) {
                string = ((TRCPackage)object2).getName();
                if (string.equals("")) {
                    string = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                }
            } else if (object2 instanceof TRCClass) {
                string = ((TRCClass)object2).getName();
            } else if (object2 instanceof TRCMethod) {
                string = ((TRCMethod)object2).getName() + ((TRCMethod)object2).getSignature();
            } else if (object2 instanceof TRCObject) {
                TRCObject tRCObject = (TRCObject)object2;
                string = tRCObject.getIsA().getName();
            }
            if (!this._caseSensitive) {
                string = string.toLowerCase();
            }
            if (this._exactMatch) {
                return string.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                bl = string.startsWith(this._prefix);
            }
            if (bl && this._suffix != "") {
                bl = string.endsWith(this._suffix);
            }
            if (bl) {
                int n = 0;
                while (n < this._textList.size()) {
                    String string2 = (String)this._textList.get(n);
                    int n2 = string.lastIndexOf(string2);
                    if (n2 == -1) {
                        bl = false;
                        break;
                    }
                    string = string.substring(n2 + string2.length());
                    ++n;
                }
            }
            return bl;
        }
    }

    public abstract class StatisticSorter
    extends ViewerSorter {
        protected TableColumn _sortColumn;
        protected int _sortSequence = -1;
        protected StatisticTableColumnInfo _info;
        protected int _pos = 0;

        public void setSortedColumn(TableColumn tableColumn) {
            String string;
            this._sortColumn = tableColumn;
            TableColumn tableColumn2 = this.getCurrentSortColumn(tableColumn.getParent());
            if (tableColumn2 != null) {
                string = tableColumn2.getText();
                if (string.startsWith(">") || string.startsWith("<")) {
                    string = string.substring(1);
                }
                this._sortSequence = tableColumn2 == tableColumn ? -this._sortSequence : -1;
                tableColumn2.setText(string);
                StatisticTableColumnInfo.getStatisticTableColumnInfo(tableColumn2).setSortColumn(false);
            } else {
                this._sortSequence = 1;
            }
            string = tableColumn.getText();
            this._info = StatisticTableColumnInfo.getStatisticTableColumnInfo(tableColumn);
            this._pos = this._info.getColumnData().getInitalPos();
            tableColumn.setText((this._sortSequence > 0 ? ">" : "<") + string);
            StatisticTableColumnInfo.getStatisticTableColumnInfo(tableColumn).setSortColumn(true);
        }

        protected int getSortSequence() {
            return this._sortSequence;
        }

        protected void setSortSequence(int n) {
            this._sortSequence = n;
        }

        private TableColumn getCurrentSortColumn(Table table) {
            int n = 0;
            while (n < table.getColumnCount()) {
                if (StatisticTableColumnInfo.getStatisticTableColumnInfo(table.getColumn(n)).isSortColumn()) {
                    return table.getColumn(n);
                }
                ++n;
            }
            return null;
        }

        public TableColumn resetSortColumn(Table table) {
            this._sortColumn = this.getCurrentSortColumn(table);
            return this._sortColumn;
        }
    }
}

