/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AbstractListenerActionDelegate;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StopTraceActionDelegate
extends AbstractListenerActionDelegate {
    public void doAction(Object object) throws Exception {
        if (object == null || !(object instanceof TRCAgentProxy)) {
            return;
        }
        INavigator iNavigator = (INavigator)this.getView();
        if (iNavigator == null) {
            MessageDialog.openInformation((Shell)UIPlugin.getActiveWorkbenchShell(), (String)"title", (String)"Action not available in current context");
            return;
        }
        this.run((TRCAgentProxy)object, iNavigator);
    }

    public void run(TRCAgentProxy tRCAgentProxy, INavigator iNavigator) {
        TRCProcessProxy tRCProcessProxy = tRCAgentProxy.getProcessProxy();
        String string = tRCProcessProxy.getNode().getName();
        try {
            Agent agent;
            Node node = PDCoreUtil.profileConnect(string, String.valueOf(tRCProcessProxy.getNode().getPort()));
            if (node == null) {
                return;
            }
            Object object = LoadersUtils.locateAgentInstance((TRCAgentProxy)tRCAgentProxy);
            if (object != null && object instanceof Agent && (agent = (Agent)object).isMonitored()) {
                agent.stopMonitoring();
                tRCAgentProxy.setMonitored(false);
                tRCAgentProxy.setAttached(true);
                tRCAgentProxy.setActive(true);
                ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
                profileEvent.setSource(tRCAgentProxy);
                profileEvent.setType(2);
                UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
            }
            iNavigator.getViewer().refresh((Object)tRCAgentProxy);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean isEnabledFor(Object object) {
        if (object != null && object instanceof TRCAgentProxy && ((TRCAgentProxy)object).isMonitored()) {
            this.getAction().setEnabled(true);
            return true;
        }
        this.getAction().setEnabled(false);
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

